/*
 * $Id$
 */
package csbase.server.services.projectservice;

/**
 * Informaes sobre a atualizao de um arquivo.
 * 
 * @author Tecgraf/PUC-Rio
 */
final class FileUpdateInfo {
  /**
   * O login do usurio que solicitou a atualizao.
   */
  private String userLogin;
  /**
   * O intervalo de tempo entre as atualizaes.
   */
  private long interval;

  /**
   * @param userLogin O login do usurio que solicitou a atualizao.
   * @param interval O intervalo de tempo entre as atualizaes.
   */
  public FileUpdateInfo(String userLogin, long interval) {
    this.userLogin = userLogin;
    this.interval = interval;
  }

  /**
   * Obtm o login do usurio que solicitou a atualizao.
   * 
   * @return O login do usurio que solicitou a atualizao.
   */
  public String getUserLogin() {
    return this.userLogin;
  }

  /**
   * Obtm o intervalo de tempo entre as atualizaes.
   * 
   * @return O intervalo de tempo entre as atualizaes.
   */
  public long getInterval() {
    return this.interval;
  }
}
