/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_01;

import tecgraf.openbus.data_service.core.v1_01.AbsentViews;
import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataAlreadyExist;
import tecgraf.openbus.data_service.core.v1_01.DataDescription;
import tecgraf.openbus.data_service.core.v1_01.DataNotFound;
import tecgraf.openbus.data_service.core.v1_01.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_01.ServiceFailure;
import tecgraf.openbus.data_service.core.v1_01.UnsupportedView;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalManagementDataServicePOA;
import tecgraf.openbus.data_service.hierarchical.v1_01.InvalidPrototype;
import tecgraf.openbus.data_service.hierarchical.v1_01.UnsupportedOperation;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalManagementDataServiceOperations;
import tecgraf.openbus.data_service.hierarchical.v1_02.InvalidContainer;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.DataValidation;

/**
 * 
 * 
 * @author Tecgraf
 */
public class IHierarchicalManagementDataServiceServant extends
  IHierarchicalManagementDataServicePOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public byte[] copyData(byte[] fSourceKey, byte[] fParentKey)
    throws ServiceFailure, DataAlreadyExist, DataNotFound, DataAccessDenied,
    UnsupportedOperation, InvalidDataKey {
    try {
      IHierarchicalManagementDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();
      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[] fSourceKeyV1_02;
        byte[] fParentKeyV1_02;

        try {
          fSourceKeyV1_02 = DataBridge.convertDataKeyToV1_02(fSourceKey);
          fParentKeyV1_02 = DataBridge.convertDataKeyToV1_02(fParentKey);

        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        byte[] newKeyV1_01 =
          DataBridge.convertDataKeyToV1_01(service.copyData(fSourceKeyV1_02,
            fParentKeyV1_02));

        return newKeyV1_01;
      }
      catch (InvalidContainer e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation e) {
        throw new UnsupportedOperation();
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAlreadyExist e) {
        throw new DataAlreadyExist();
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo copyData: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public byte[] createData(DataDescription fPrototype, byte[] fParentKey)
    throws InvalidPrototype, ServiceFailure, DataAlreadyExist, DataNotFound,
    DataAccessDenied, UnsupportedOperation, InvalidDataKey {
    try {
      IHierarchicalManagementDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();

      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        tecgraf.openbus.data_service.core.v1_02.DataDescription fPrototypeV1_02;
        try {
          fPrototypeV1_02 =
            DataBridge.convertDataDescriptionToV1_02(fPrototype);
        }
        catch (UnsupportedView e1) {
          throw new InvalidPrototype();
        }

        byte[] fParentKeyV1_02;

        try {
          fParentKeyV1_02 = DataBridge.convertDataKeyToV1_02(fParentKey);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        byte[] newKeyV1_01 =
          DataBridge.convertDataKeyToV1_01(service.createData(fPrototypeV1_02,
            fParentKeyV1_02));

        return newKeyV1_01;
      }
      catch (InvalidContainer e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation e) {
        throw new UnsupportedOperation();
      }
      catch (tecgraf.openbus.data_service.hierarchical.v1_02.InvalidPrototype e) {
        throw new InvalidPrototype();
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAlreadyExist e) {
        throw new DataAlreadyExist();
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo createData: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }

    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void deleteData(byte[] fKey) throws ServiceFailure, DataNotFound,
    DataAccessDenied, UnsupportedOperation, InvalidDataKey {
    try {
      IHierarchicalManagementDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();
      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[] fKeyV1_02;
        try {
          fKeyV1_02 = DataBridge.convertDataKeyToV1_02(fKey);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        service.deleteData(fKeyV1_02);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation e) {
        throw new UnsupportedOperation();
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo deleteData: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void moveData(byte[] fKey, byte[] fNewParentKey)
    throws ServiceFailure, DataAlreadyExist, DataNotFound, DataAccessDenied,
    UnsupportedOperation, InvalidDataKey {
    try {
      IHierarchicalManagementDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();
      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[] fKeyV1_02;
        byte[] fNewParentKeyV1_02;
        try {
          fKeyV1_02 = DataBridge.convertDataKeyToV1_02(fKey);
          fNewParentKeyV1_02 = DataBridge.convertDataKeyToV1_02(fNewParentKey);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        service.moveData(fKeyV1_02, fNewParentKeyV1_02);
      }
      catch (InvalidContainer e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation e) {
        throw new UnsupportedOperation();
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAlreadyExist e) {
        throw new DataAlreadyExist();
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo moveData: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void updateData(byte[] fKey, byte[] fSourceKey) throws ServiceFailure,
    DataNotFound, DataAccessDenied, AbsentViews, UnsupportedOperation,
    InvalidDataKey {
    try {
      IHierarchicalManagementDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();
      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[] fKeyV1_01;
        byte[] fSourceKeyV1_01;

        try {
          fKeyV1_01 = DataBridge.convertDataKeyToV1_02(fKey);
          fSourceKeyV1_01 = DataBridge.convertDataKeyToV1_02(fSourceKey);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        service.updateData(fKeyV1_01, fSourceKeyV1_01);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation e) {
        throw new UnsupportedOperation();
      }
      catch (tecgraf.openbus.data_service.core.v1_02.AbsentViews e) {
        try {
          throw new AbsentViews(DataBridge.convertDataKeySeqToV1_01(e.fKey),
            DataBridge.convertInterfaceNameSeqToV1_01(e.fViews));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo updateData: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }
}
