package csbase.server.services.projectservice.v1_02;

import java.util.Properties;

import scs.core.IComponent;
import tecgraf.openbus.data_service.core.v1_02.DataKeyWrapper;
import tecgraf.openbus.data_service.core.v1_02.IDataService;
import tecgraf.openbus.data_service.core.v1_02.IDataServiceHelper;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import csbase.exception.OperationFailureException;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Utilitrio para fazer a busca de servios de dados da verso 1.1 a partir da
 * chave informada.
 * 
 * @author Tecgraf
 */
public class FindService {
  /**
   * O nome da propriedade que representa o identificador de uma fonte de dados
   * em um servio de dados.
   */
  private static String DATA_SOURCE_ID_PROPERTY_NAME = "openbus.data_source_id";
  /**
   * O nome da propriedade que indica qual o sistema responsvel pela oferta de
   * um servio no OpenBus.
   */
  private static final String REGISTERING_ENTITY_PROPERTY_NAME =
    "openbus.offer.entity";

  /**
   * O nome da propriedade que indica que o sistema deve prover uma interface.
   */
  private static final String INTERFACE_PROPERTY_NAME =
    "openbus.component.interface";

  /**
   * Realiza uma busca por um Servio de Dados a partir da chave de um dado. O
   * dado representado pela chave  oriundo do Servio de Dados encontrado.
   * 
   * @param dataKey A chave do dado que contm as informaes sobre o Servio de
   *        Dados procurado.
   * 
   * @return O Servio de Dados.
   * @throws ServiceFailure caso ocorra algum erro na busca do servio de dados
   */
  protected static IDataService find(DataKeyWrapper dataKey)
    throws ServiceFailure {
    String systemDeploymentId = dataKey.getSystemDeploymentId();
    String dataSourceId = dataKey.getDataSourceId();
    Properties properties = new Properties();
    properties
      .setProperty(REGISTERING_ENTITY_PROPERTY_NAME, systemDeploymentId);
    properties.setProperty(DATA_SOURCE_ID_PROPERTY_NAME, dataSourceId);
    properties.setProperty(INTERFACE_PROPERTY_NAME, IDataServiceHelper.id());

    IComponent component;
    try {
      component = OpenBusService.getInstance().findService(properties);
      if (component == null) {
        return null;
      }
    }
    catch (OperationFailureException e) {
      throw new ServiceFailure("Erro ao buscar o servio de dados.");
    }

    org.omg.CORBA.Object obj = component.getFacet(IDataServiceHelper.id());
    IDataService dataService = IDataServiceHelper.narrow(obj);

    return dataService;
  }
}
