/**
 * $Id$
 */
package csbase.server.services.sharedobjectservice.v1_00;

import csbase.logic.SharedObject;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.DataValidation;
import csbase.server.services.sharedobjectservice.SharedObjectService;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataKeyWrapper;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectDataView;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectDataViewImpl;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectServicePOA;

/**
 * Classe que implementa no lado do servidor CSBASE o servio de provimento de
 * shared objects para o barramento. Acessa SharedObjectService j existente no
 * CSBASE para obter o objeto cuja categoria, usurio e nome est na chave
 * enviada pelo cliente do barramento
 *
 *
 * @see SharedObjectService
 * @author Tecgraf/PUC-Rio
 */
public class ISharedObjectServiceServant extends SharedObjectServicePOA {

  /**
   * Prefixo do identificador de dados do tipo shared object: <code>
   * SHAREDOBJECT:&lt;CATEGORY&gt;:&lt;USERNAME&gt;:&lt;OBJECT_NAME&gt;"
   * </code> por exemplo, "SHAREDOBJECT:pvtsim:admin:tabela2fluidos.tab" ou
   * "SHAREDOBJECT:UserPreferences:usuario12:preferences"
   */
  final private String SHARED_OBJECT_DATAID_PREFIX = "SHAREDOBJECT:";

  /**
   * {@inheritDoc}
   */
  @Override
  public SharedObjectDataView getSharedObject(byte[] fKey)
    throws ServiceFailure, DataAccessDenied, DataNotFound, InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      SharedObjectDataView ret = null;

      DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
      DataValidation.checkDataKey(dataKey);

      if (dataKey.getDataId().contains(SHARED_OBJECT_DATAID_PREFIX)) {
        String category = dataKey.getDataId().split(":")[1];
        String user = dataKey.getDataId().split(":")[2];
        String objectName = dataKey.getDataId().split(":")[3];

        try {
          SharedObject sharedObject = SharedObjectService.getInstance()
            .getSharedObject(category, user, objectName);
          if (sharedObject != null) {
            ret = new SharedObjectDataViewImpl(fKey, sharedObject.getContents()
              .toString());
          }
          else {
            throw new ServiceFailure(
              "Usurio sem permisso de acesso ao shared object ou shared object no existente para: "
                + new String(fKey));
          }
        }
        catch (Exception e) {
          String reason = "";
          // No caso de ServiceFailure detalhar a razo para o cliente:
          if (e instanceof ServiceFailure) {
            reason = ": " + ((ServiceFailure) e).fMessage;
          }
          throw new ServiceFailure(e.getMessage() + reason);
        }
      }
      else {
        throw new InvalidDataKey(SHARED_OBJECT_DATAID_PREFIX
          + " prefixo est faltando", new byte[][] { fKey });
      }
      return ret;
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }
}
