/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice;

import csbase.logic.CommandFinalizationType;
import csbase.logic.UserOutline;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.diagnosticservice.CommandExecutionStatisticsInfo;
import csbase.logic.diagnosticservice.DeploymentInfo;
import csbase.logic.diagnosticservice.LoginStatisticsInfo;
import csbase.logic.diagnosticservice.PropertyInfo;
import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.ServerBasicInfo;
import csbase.logic.diagnosticservice.ServerDiagnosticInfo;
import csbase.logic.diagnosticservice.ServerStatisticsInfo;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.UsersStatisticsInfo;
import csbase.remote.DiagnosticServiceInterface;
import csbase.remote.ServerEntryPoint;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.diagnosticservice.engine.Engine;
import csbase.server.services.diagnosticservice.monitors.csfs.CSFSMonitor;
import csbase.server.services.diagnosticservice.monitors.disk.DiskMonitor;
import csbase.server.services.diagnosticservice.monitors.openbus.OpenbusMonitor;
import csbase.server.services.diagnosticservice.monitors.openbus.ServiceOfferMonitor;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.server.services.serverservice.ServerService;
import csbase.server.services.sgaservice.SGAService;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scs.core.ComponentId;

public class DiagnosticService
extends Service
implements DiagnosticServiceInterface {
    private Engine diagEngine;

    protected DiagnosticService() throws ServerException {
        super("DiagnosticService");
        Engine.setLocale(this.getDefaultLocale());
        this.diagEngine = new Engine();
    }

    public static DiagnosticService getInstance() {
        return (DiagnosticService)DiagnosticService.getInstance("DiagnosticService");
    }

    @Override
    protected void initService() throws ServerException {
        Server.logInfoMessage("Iniciando o servi\u00e7o de Diagn\u00f3stico!");
        if (this.getBooleanProperty("csfs")) {
            try {
                this.diagEngine.addMonitor(new CSFSMonitor());
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro ao criar monitor do CSFS", e);
            }
        }
        if (this.getBooleanProperty("openbus")) {
            try {
                this.diagEngine.addMonitor(new OpenbusMonitor());
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro ao criar monitor do barramento", e);
            }
        }
        if (this.getBooleanProperty("published.services")) {
            Set<ComponentId> components = OpenBusService.getInstance().getRegisteredComponents();
            for (ComponentId component : components) {
                try {
                    this.diagEngine.addMonitor(new ServiceOfferMonitor(component));
                }
                catch (Exception e) {
                    Server.logSevereMessage("Erro ao criar o monitor de components publicados", e);
                }
            }
        }
        try {
            this.diagEngine.addMonitor(new DiskMonitor());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao criar os monitores de disco", e);
        }
    }

    @Override
    protected void shutdownService() throws ServerException {
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    public static void createService() throws ServerException {
        DiagnosticService.extracted();
    }

    private static DiagnosticService extracted() throws ServerException {
        return new DiagnosticService();
    }

    public Status getStatus(String resourceName) {
        try {
            return this.diagEngine.getStatus(resourceName, this.getDefaultLocale());
        }
        catch (ResourceException e) {
            Server.logWarningMessage(MessageFormat.format("Solicitado o estado de recurso n\u00e3o monitorado: {0}.", resourceName));
            return new Status(resourceName, StatusCode.NOT_MONITORED);
        }
    }

    public ServerBasicInfo getServerBasicInfo() {
        ServerEntryPoint entryPoint = Server.getInstance().getEntryPoint();
        String systemName = null;
        String systemVersion = null;
        try {
            systemName = entryPoint.getSystemName();
        }
        catch (Exception e) {
            systemName = "";
        }
        try {
            systemVersion = entryPoint.getVersionName();
        }
        catch (Exception e) {
            systemVersion = "";
        }
        long startupTime = ServerService.getInstance().getStartupTime();
        String operationalSystem = String.format("%s %s %s", DeploymentInfo.OS_NAME, DeploymentInfo.OS_ARCH, DeploymentInfo.OS_VERSION);
        String javaVersion = String.format("%s %s (%s)", DeploymentInfo.JAVA_NAME, DeploymentInfo.JAVA_VERSION, DeploymentInfo.JAVA_VENDOR);
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer JVMArgs = new StringBuffer();
        for (String arg : arguments) {
            JVMArgs.append(arg);
            JVMArgs.append(" ");
        }
        String projectDir = this.getPath(new File(ProjectService.getInstance().getProjectRepositoryPath()));
        String algoDir = this.getPath(new File(AlgorithmService.getInstance().getAlgorithmRepositoryPath()));
        String persistencyDir = this.getPath(new File(Server.getInstance().getPersistencyRootDirectoryName()));
        String serverRunningDir = this.getPath(new File(Server.getInstance().getRunningDirectoryName()));
        return new ServerBasicInfo(systemName, systemVersion, startupTime, operationalSystem, Server.getInstance().getHostName(), Server.getInstance().getHostAddr(), Server.getInstance().getServerHostCharsetName(), javaVersion, JVMArgs.toString(), Server.getInstance().getRegistryPort(), Server.getInstance().getServerLibs(), projectDir, algoDir, persistencyDir, serverRunningDir);
    }

    private String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    public UsersStatisticsInfo getUsersStatisticsInfo() throws RemoteException {
        int numUsers = ServerService.getInstance().getNumRegisteredUsers();
        ServerEntryPoint entryPoint = Server.getInstance().getEntryPoint();
        UserOutline[] loggedUsers = entryPoint.getLoggedUsers();
        return new UsersStatisticsInfo(numUsers, loggedUsers);
    }

    public LoginStatisticsInfo getLoginStatisticsInfo() throws RemoteException {
        Map<String, Integer> succeededLogins = ServerService.getInstance().getLoginStats(true);
        Map<String, Integer> failedLogins = ServerService.getInstance().getLoginStats(false);
        return new LoginStatisticsInfo(succeededLogins, failedLogins);
    }

    public CommandExecutionStatisticsInfo getCommandExecutionStatisticsInfo() throws RemoteException {
        Map<ExecutionType, Integer> exeStats = SchedulerService.getInstance().getExeTypeStats();
        int flowStats = SchedulerService.getInstance().getFlowExecutionStats();
        Map<String, Integer> algoStats = SchedulerService.getInstance().getAlgoStats(false);
        Map<String, Integer> flowAlgoStats = SchedulerService.getInstance().getAlgoStats(true);
        Map<String, Integer> userStats = SchedulerService.getInstance().getUserStats();
        Map<String, Integer> sgasStats = SGAService.getInstance().getSGAsStats();
        Map<CommandFinalizationType, Integer> resultsStats = SGAService.getInstance().getExeResultsStats(false);
        Map<CommandFinalizationType, Integer> flowResultsStats = SGAService.getInstance().getExeResultsStats(true);
        return new CommandExecutionStatisticsInfo(exeStats, flowStats, algoStats, flowAlgoStats, userStats, sgasStats, resultsStats, flowResultsStats);
    }

    public DeploymentInfo getDeploymentInfo() throws RemoteException {
        return ServerService.getInstance().getDeploymentInfo();
    }

    public Map<String, PropertyInfo> getPropertiesInfo() {
        return Server.getInstance().getPropertiesInfo();
    }

    public ServerDiagnosticInfo getServerDiagnosticInfo() throws RemoteException {
        ServerBasicInfo basicInfo = this.getServerBasicInfo();
        Map<String, PropertyInfo> propertiesInfo = this.getPropertiesInfo();
        Status openbusStatus = null;
        if (this.getBooleanProperty("openbus")) {
            openbusStatus = this.getStatus("openbus");
        }
        Status csfsStatus = null;
        if (this.getBooleanProperty("csfs")) {
            csfsStatus = this.getStatus("csfs");
        }
        ArrayList<Status> publishedComponentsStatus = null;
        if (this.getBooleanProperty("published.services")) {
            Set<ComponentId> components = OpenBusService.getInstance().getRegisteredComponents();
            publishedComponentsStatus = new ArrayList<Status>();
            for (ComponentId componentId : components) {
                Status status = this.getStatus(componentId.name);
                publishedComponentsStatus.add(status);
            }
        }
        Status diskStatus = this.getStatus("server");
        UsersStatisticsInfo usersStatisticsInfo = this.getUsersStatisticsInfo();
        LoginStatisticsInfo loginStatisticsInfo = this.getLoginStatisticsInfo();
        CommandExecutionStatisticsInfo commandExecutionStatisticsInfo = this.getCommandExecutionStatisticsInfo();
        ServerStatisticsInfo statisticsInfo = new ServerStatisticsInfo(usersStatisticsInfo, loginStatisticsInfo, commandExecutionStatisticsInfo, new Date(basicInfo.startUpTime));
        return new ServerDiagnosticInfo(basicInfo, propertiesInfo.values().toArray(new PropertyInfo[0]), statisticsInfo, openbusStatus, publishedComponentsStatus.toArray(new Status[0]), csfsStatus, diskStatus);
    }
}

