/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.openurlservice;

import csbase.exception.CSBaseException;
import csbase.exception.ServiceFailureException;
import csbase.logic.ServerURI;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.logic.openurlservice.PredefinedURLSystem;
import csbase.logic.url.URLParameters;
import csbase.remote.OpenURLServiceInterface;
import csbase.remote.ServerEntryPoint;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.loginservice.ReferedServerCache;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;

public class OpenURLService
extends Service
implements OpenURLServiceInterface {
    private final List<PredefinedURLSystem> predefinedURLSystems = new ArrayList<PredefinedURLSystem>();

    private URL buildURL(OpenBusLoginToken token, String hostName, int hostPort, Locale locale, String currentClientId, String newClientId, boolean startVisible) {
        String urlText;
        ServerEntryPoint serverEntryPoint;
        if (locale == null) {
            String err = this.getString("internal.null.locale.error");
            throw new ServiceFailureException(err);
        }
        ReferedServerCache referedServerCache = ReferedServerCache.getInstance();
        ServerURI uri = ServerURI.create((String)hostName, (int)hostPort);
        try {
            serverEntryPoint = referedServerCache.getServer(uri);
            String uriFmt = "Servidor/Porta %s:%d definido com URI: %s";
            String uriMsg = String.format("Servidor/Porta %s:%d definido com URI: %s", hostName, hostPort, uri);
            Server.logInfoMessage(uriMsg);
        }
        catch (CSBaseException e) {
            String fmt = this.getString("not.monitored.server.error");
            String err = String.format(fmt, uri);
            throw new ServiceFailureException(err);
        }
        if (serverEntryPoint == null) {
            String fmt = this.getString("no.server.error");
            String err = String.format(fmt, uri);
            throw new ServiceFailureException(err);
        }
        try {
            urlText = serverEntryPoint.getSystemURLWithRMIPort();
        }
        catch (RemoteException e) {
            String fmt = this.getString("comm.server.error");
            String err = String.format(fmt, uri);
            throw new ServiceFailureException(err, (Throwable)e);
        }
        String visParamName = "desktop_visible";
        String visValue = Boolean.toString(startVisible);
        urlText = URLParameters.addUrlParam((String)urlText, (String)"desktop_visible", (String)visValue);
        String locParamName = "locale";
        String locValue = locale.toString();
        urlText = URLParameters.addUrlParam((String)urlText, (String)"locale", (String)locValue);
        String orParamName = "source_client_identifier";
        urlText = URLParameters.addUrlParam((String)urlText, (String)"source_client_identifier", (String)currentClientId);
        String newcliParamName = "current_client_identifier";
        urlText = URLParameters.addUrlParam((String)urlText, (String)"current_client_identifier", (String)newClientId);
        String urlFmt = "Servidor/Porta %s:%d gerou URL (sem id): [%s]";
        String urlMsg = String.format("Servidor/Porta %s:%d gerou URL (sem id): [%s]", hostName, hostPort, urlText);
        Server.logInfoMessage(urlMsg);
        String userParamName = "openbus_token_user";
        String userValue = token.user;
        urlText = URLParameters.addUrlParam((String)urlText, (String)"openbus_token_user", (String)userValue);
        String secretParamName = "openbus_token_secret";
        byte[] secretValue = token.secret;
        urlText = URLParameters.addUrlParam((String)urlText, (String)"openbus_token_secret", (String)Base64.encodeBase64String((byte[])secretValue));
        try {
            URL url = new URL(urlText);
            return url;
        }
        catch (MalformedURLException e) {
            String fmt = this.getString("bad.url.error");
            String err = String.format(fmt, uri);
            throw new ServiceFailureException(err, (Throwable)e);
        }
    }

    private void checkEnabled() {
        if (!this.isEnabled()) {
            String err = this.getString("disabled.service.error");
            throw new ServiceFailureException(err);
        }
    }

    public List<PredefinedURLSystem> getPredefinedURLSystems() {
        ArrayList<PredefinedURLSystem> list = new ArrayList<PredefinedURLSystem>();
        list.addAll(this.predefinedURLSystems);
        Collections.unmodifiableList(list);
        return list;
    }

    private PredefinedURLSystem getSystem(String systemLabel) {
        for (PredefinedURLSystem sys : this.predefinedURLSystems) {
            if (!sys.getLabel().equals(systemLabel)) continue;
            return sys;
        }
        return null;
    }

    public URL getSystemURL(Locale locale, OpenBusLoginToken token, String systemLabel, String currentClientId, String newClientId, boolean startVisible) {
        this.checkEnabled();
        if (!this.hasSystem(systemLabel)) {
            String fmt = this.getString("no.system.error");
            String err = String.format(fmt, systemLabel);
            throw new ServiceFailureException(err);
        }
        Locale loc = locale == null ? Locale.getDefault() : locale;
        String owner = token.user;
        String logFmt = "Pedido de URL pelo usu\u00e1rio: %s (%s)- tag [%s]";
        String locText = loc.toString();
        String logMsg = String.format("Pedido de URL pelo usu\u00e1rio: %s (%s)- tag [%s]", owner, locText, systemLabel);
        Server.logInfoMessage(logMsg);
        PredefinedURLSystem system = this.getSystem(systemLabel);
        String hostAddress = system.getHostAddress();
        int hostPort = system.getHostPort();
        String reqFmt = "Pedido de [%s]/[%s] direcionado para: %s - porta %d";
        String reqMsg = String.format("Pedido de [%s]/[%s] direcionado para: %s - porta %d", owner, systemLabel, hostAddress, hostPort);
        Server.logInfoMessage(reqMsg);
        URL url = this.buildURL(token, hostAddress, hostPort, loc, currentClientId, newClientId, startVisible);
        return url;
    }

    public URL getURL(Locale locale, OpenBusLoginToken token, String currentClientId, String newClientId, boolean startVisible) throws RemoteException {
        this.checkEnabled();
        Server server = Server.getInstance();
        String hostName = server.getHostName();
        int hostPort = server.getRegistryPort();
        Locale loc = locale == null ? Locale.getDefault() : locale;
        URL url = this.buildURL(token, hostName, hostPort, loc, currentClientId, newClientId, startVisible);
        return url;
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    private boolean hasSystem(String systemLabel) {
        PredefinedURLSystem system = this.getSystem(systemLabel);
        return system != null;
    }

    @Override
    public void initService() throws ServerException {
        this.loadPredefinedSystems();
    }

    private void loadPredefinedSystems() {
        String prefix = "predefined.systems.";
        List<String> labels = this.getStringListProperty("predefined.systems.label");
        int i = 1;
        for (String label : labels) {
            if (this.hasSystem(label)) {
                String fmt = "Defini\u00e7\u00e3o de [%s] duplicada! Descartando...";
                String err = String.format("Defini\u00e7\u00e3o de [%s] duplicada! Descartando...", label);
                Server.logSevereMessage(err);
            } else {
                String hostAdressTag = "predefined.systems.host.address." + i;
                String hostPortTag = "predefined.systems.host.port." + i;
                String hostAddress = this.getStringProperty(hostAdressTag);
                int hostPort = this.getIntProperty(hostPortTag);
                PredefinedURLSystem system = new PredefinedURLSystem(label, hostAddress, hostPort);
                String fmt = "Sistema predefinido encontrado: %s - %s:%d";
                String msg = String.format("Sistema predefinido encontrado: %s - %s:%d", label, hostAddress, hostPort);
                Server.logInfoMessage(msg);
                this.predefinedURLSystems.add(system);
            }
            ++i;
        }
    }

    @Override
    public void shutdownService() throws ServerException {
    }

    public static void createService() throws ServerException {
        new OpenURLService();
    }

    public static OpenURLService getInstance() {
        String serviceName = "OpenURLService";
        return (OpenURLService)Service.getInstance("OpenURLService");
    }

    protected OpenURLService() throws ServerException {
        super("OpenURLService");
        this.setEnabled(this.getBooleanProperty("enabled"));
    }
}

