/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;
import csbase.server.services.administrationservice.DAOException;
import csbase.server.services.administrationservice.UserGroupDAO;
import csbase.server.services.administrationservice.UserGroupIO;
import java.io.IOException;
import java.util.List;

public class DefaultUserGroupDAO
implements UserGroupDAO {
    private UserGroupIO userGroupsRepository = new UserGroupIO();

    @Override
    public UserGroup createUserGroup(UserGroupInfo info) throws DAOException {
        UserGroup userGroup;
        try {
            userGroup = this.userGroupsRepository.writeNew(info);
        }
        catch (IOException e) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.desc + "]";
            throw new DAOException(e, operationInfo);
        }
        if (userGroup == null) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.desc + "]";
            throw new DAOException("Falha em UserGroupIO.writeNew", operationInfo);
        }
        return userGroup;
    }

    @Override
    public void deleteUserGroup(Object id) throws DAOException {
        try {
            this.userGroupsRepository.delete(id);
        }
        catch (IOException e) {
            throw new DAOException(e, "id: " + id);
        }
    }

    @Override
    public UserGroup modifyUserGroup(Object id, UserGroupInfo info) throws DAOException {
        UserGroup userGroup;
        try {
            userGroup = this.userGroupsRepository.write(id, info);
        }
        catch (IOException e) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.desc + "] - para o usu\u00e1rio: " + id;
            throw new DAOException(e, operationInfo);
        }
        if (userGroup == null) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.desc + "] - para o usu\u00e1rio: " + id;
            throw new DAOException("Falha em UserGroupIO.write", operationInfo);
        }
        return userGroup;
    }

    @Override
    public List<UserGroup> readAllUserGroups() throws DAOException {
        try {
            return this.userGroupsRepository.readAll();
        }
        catch (IOException e) {
            throw new DAOException(e);
        }
    }

    @Override
    public UserGroup readUserGroup(Object id) throws DAOException {
        try {
            return this.userGroupsRepository.read(id);
        }
        catch (IOException e) {
            throw new DAOException(e, "id: " + id);
        }
    }
}

