/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v2_0;

import csbase.exception.ParseException;
import csbase.exception.PermissionException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.server.Service;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.opendreamsservice.opendreams.v2_0.InvalidJobTemplateException;
import csbase.server.services.projectservice.ProjectService;
import java.rmi.RemoteException;
import java.util.Arrays;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.openbus.opendreams.v2_0.OpenDreamsJobTemplate;

public class JobTemplateValidator {
    @Option(name="-name")
    private String algoName;
    @Option(name="-version")
    private String algoVersion;
    private AlgorithmConfigurator configurator;
    private AlgorithmVersionId versionId;
    private Object projectId;
    private String userId;
    private static String EXEC_ALGO = "execAlgo";
    private static String EXEC_FLOW = "execFlow";
    private static String[] VALID_COMMANDS = new String[]{EXEC_ALGO, EXEC_FLOW};
    private static String[] VALID_JOB_CATEGORIES = new String[]{"CSBase", "System"};

    public JobTemplateValidator(String userId, OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        this.userId = userId;
        this.validateProject(jt);
        this.validateArgs(jt);
        this.validateRemoteCommand(jt);
        this.validateJobParameters(jt);
        this.validateJobPriority(jt);
        this.validateJobEnvironment(jt);
        this.validateWorkingDirectory(jt);
        this.validateJobCategory(jt);
        this.validateEmail(jt);
        this.validateBlockEmail(jt);
        this.validateJobName(jt);
        this.validateInputPath(jt);
        this.validateOutputPath(jt);
        this.validateErrorPath(jt);
        this.validateJoinFiles(jt);
        this.validateTransferFiles(jt);
    }

    public Object getProjectId() {
        return this.projectId;
    }

    private void validateProject(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.projectName.isEmpty()) {
            throw new InvalidJobTemplateException("O nome do projeto n\u00e3o foi especificado.");
        }
        String projectOwner = jt.projectOwner.isEmpty() ? this.userId : jt.projectOwner;
        this.checkProject(jt.projectName, projectOwner);
        JobTemplateValidator.checkProjectPermission(jt.projectName, this.userId);
        ProjectService projectService = ProjectService.getInstance();
        this.projectId = projectService.getProjectId(projectOwner, jt.projectName);
    }

    private void checkProject(String projectName, String userId) throws InvalidJobTemplateException {
        Object projectId;
        if (AdministrationService.getInstance().getUser(userId) == null) {
            throw new InvalidJobTemplateException("N\u00e3o existe um usu\u00e1rio com identificador " + userId);
        }
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsProject(projectId = projectService.getProjectId(userId, projectName))) {
            throw new InvalidJobTemplateException("O usu\u00e1rio " + userId + " n\u00e3o possui um projeto com nome " + projectName);
        }
    }

    public static void checkProjectPermission(String projectName, String userId) throws InvalidJobTemplateException {
        ProjectService projectService = ProjectService.getInstance();
        Object projectId = projectService.getProjectId(userId, projectName);
        try {
            projectService.checkWritePermission(projectId);
        }
        catch (PermissionException e) {
            throw new InvalidJobTemplateException("O usu\u00e1rio " + Service.getUser().getId() + " n\u00e3o possui acesso de escrita no projeto " + projectName + " do usu\u00e1rio " + userId);
        }
    }

    private void validateRemoteCommand(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.remoteCommand.isEmpty()) {
            switch (this.configurator.getConfiguratorType()) {
                case SIMPLE: {
                    jt.remoteCommand = EXEC_ALGO;
                    break;
                }
                case FLOW: {
                    jt.remoteCommand = EXEC_FLOW;
                }
            }
            return;
        }
        for (String command : VALID_COMMANDS) {
            if (!jt.remoteCommand.equals(command)) continue;
            return;
        }
        throw new InvalidJobTemplateException("Falha na valida\u00e7\u00e3o de remoteCommand:" + jt.remoteCommand);
    }

    private void validateArgs(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(jt.args);
            this.versionId = AlgorithmVersionId.create((String)this.algoVersion);
            this.configurator = AlgorithmService.getInstance().createAlgorithmConfigurator(this.getAlgoName(), this.getAlgoVersionId());
        }
        catch (CmdLineException e) {
            StringBuffer args = new StringBuffer();
            for (String arg : jt.args) {
                args.append(arg);
                args.append(" ");
            }
            throw new InvalidJobTemplateException("Falha na valida\u00e7\u00e3o de args:" + args, e);
        }
        catch (AlgorithmNotFoundException e) {
            throw new InvalidJobTemplateException("Algoritmo " + this.getAlgoName() + " vers\u00e3o " + this.getAlgoVersionId() + " n\u00e3o encontrados", e);
        }
    }

    private void validateJobParameters(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        StringBuffer pars = new StringBuffer();
        for (String[] parameter : jt.jobParameters) {
            try {
                String name = parameter[0];
                String value = parameter[1];
                pars.append(name + " " + value + " ");
                this.configurator.setParameterValue(name, value);
            }
            catch (ParseException e) {
                throw new InvalidJobTemplateException("O par\u00e2metro " + pars + " possui o valor com formato inv\u00e1lido", e);
            }
            catch (ParameterNotFoundException e) {
                throw new InvalidJobTemplateException("O par\u00e2metro " + pars + " n\u00e3o existe na configura\u00e7\u00e3o do algoritmo", e);
            }
        }
        try {
            ValidationContext context = new ValidationContext(ValidationMode.FULL, this.projectId, (Object)this.userId);
            Validation result = this.configurator.validate(context);
            if (!result.isWellSucceded()) {
                LocalizedMessage message = result.getMessage();
                throw new InvalidJobTemplateException("Valida\u00e7\u00e3o dos par\u00e2metros do algoritmo falhou: " + message);
            }
        }
        catch (RemoteException e) {
            throw new InvalidJobTemplateException("N\u00e3o foi poss\u00edvel validar os par\u00e2metros do algoritmo", e);
        }
    }

    private void validateJobPriority(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.priority < 0 || jt.priority >= Priority.values().length) {
            throw new InvalidJobTemplateException("O atributo jobPriority deve ter um dos seguintes valores: 0 (ROOT), 1 (HIGH), 2 (MEDIUM) ou 3 (LOW)");
        }
    }

    private void validateJobEnvironment(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.priority < 0 || jt.priority >= Priority.values().length) {
            throw new InvalidJobTemplateException("O atributo jobPriority deve ser maior ou igual a 0 (prioridade ROOT) e menor ou igual a 3 (prioridade LOW)");
        }
    }

    private void validateWorkingDirectory(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.workingDirectory != null && !jt.workingDirectory.isEmpty()) {
            throw new InvalidJobTemplateException("O atributo workingDirectory n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateJobCategory(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.jobCategory != null && !Arrays.asList(VALID_JOB_CATEGORIES).contains(jt.jobCategory)) {
            throw new InvalidJobTemplateException("O atributo jobCategory deve ser CSBase ou System");
        }
        if (jt.jobCategory != null && jt.jobCategory.equals("System")) {
            throw new InvalidJobTemplateException("A categoria System ainda n\u00e3o est\u00e1 implementada no OpenDreams");
        }
    }

    private void validateEmail(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
    }

    private void validateBlockEmail(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
    }

    private void validateJobName(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.jobName != null && !jt.jobName.isEmpty()) {
            throw new InvalidJobTemplateException("O atributo jobName n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateInputPath(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.inputPath != null && !jt.inputPath.isEmpty()) {
            throw new InvalidJobTemplateException("O atributo inputPath n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateOutputPath(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        String dirPath = FileUtils.getFilePath((String)jt.outputPath);
        String[] paths = FileUtils.splitPath((String)dirPath);
        if (paths.length > 0 && !ProjectService.getInstance().existsFile(this.projectId, paths)) {
            throw new InvalidJobTemplateException("O diret\u00f3rio " + dirPath + " n\u00e3o existe no projeto");
        }
    }

    private void validateErrorPath(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
        if (jt.errorPath != null && !jt.errorPath.isEmpty()) {
            throw new InvalidJobTemplateException("O atributo errorPath n\u00e3o \u00e9 implementado pelo OpenDreams");
        }
    }

    private void validateJoinFiles(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
    }

    private void validateTransferFiles(OpenDreamsJobTemplate jt) throws InvalidJobTemplateException {
    }

    public String getAlgoName() {
        return this.algoName;
    }

    public AlgorithmVersionId getAlgoVersionId() {
        return this.versionId;
    }

    public AlgorithmConfigurator getAlgorithmConfigurator() {
        return this.configurator;
    }
}

