/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice.ftp;

import csbase.exception.ServiceFailureException;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.server.Server;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.projectservice.ProjectService;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;

class FTPUploadJob
extends FileTransferJob {
    @Override
    protected void transfer() throws Exception {
        ProjectService projectService = ProjectService.getInstance();
        FileTransferRequest request = this.getRequest();
        FileTransferConnection connection = request.getConnection();
        Object projectId = connection.getProjectId();
        String[] localPath = request.getLocalFilePath();
        String remoteFilePath = request.getRemoteFilePath();
        String password = connection.getPassword();
        String userName = connection.getUserName();
        String serverName = connection.getServerName();
        FTPClient ftp = new FTPClient();
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            ftp.connect(serverName);
            if (!ftp.login(userName, password)) {
                throw new ServiceFailureException("Invalid login.");
            }
            inStream = projectService.getInputStream(projectId, localPath);
            outStream = ftp.storeFileStream(remoteFilePath);
            int chunkSize = 65536;
            byte[] b = new byte[chunkSize];
            int bytesRead = 0;
            while ((bytesRead = inStream.read(b)) != -1) {
                outStream.write(b, 0, bytesRead);
                request.addTransferredSize((long)bytesRead);
                if (request.getStatus() != FileTransferRequestStatus.INTERRUPTED) continue;
                return;
            }
        }
        catch (Exception e) {
            try {
                if (ftp.isConnected()) {
                    ftp.disconnect();
                }
            }
            catch (Exception e2) {
                Server.logSevereMessage(e.getMessage(), e2);
            }
            throw new ServiceFailureException(e.getMessage());
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    Server.logSevereMessage(e.getMessage(), e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    Server.logSevereMessage(e.getMessage(), e);
                }
            }
        }
    }

    FTPUploadJob(FileTransferRequest request) {
        super(request);
    }
}

