/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket;

import csbase.exception.ParseException;
import csbase.server.Server;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.restservice.CSBaseAuthenticationServiceImpl;
import csbase.server.services.restservice.RestService;
import csbase.server.services.restservice.websocket.Project;
import csbase.server.services.restservice.websocket.User;
import ibase.rest.api.authentication.v1.adapter.UnauthorizedException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.UUID;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class CSBaseWebSocket
extends DefaultWebSocket {
    private volatile String id;
    private volatile User user;
    private volatile Project project;
    private volatile long timestamp;
    private volatile long modifiedAt;

    public CSBaseWebSocket(ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) throws UnauthorizedException {
        super(protocolHandler, request, listeners);
        Server.logInfoMessage("Instantiating CSBaseWebSocket\n\tRequest URI: " + request.getRequestURI() + "\n\tRequest query: " + request.getQueryString());
        this.id = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
        this.modifiedAt = System.currentTimeMillis();
        this.authenticate(request);
    }

    private void authenticate(HttpRequestPacket request) throws UnauthorizedException {
        AdministrationService adminService = AdministrationService.getInstance();
        try {
            String token = request.getQueryString();
            Server.logInfoMessage("Authenticating user with token " + token);
            String userId = RestService.getInstance().parserToken(token, null);
            if (userId == null) {
                throw new UnauthorizedException("Invalid token");
            }
            csbase.logic.User user = adminService.getUser(userId);
            if (user == null) {
                throw new UnauthorizedException("User " + userId + " does not exist");
            }
            this.user = new User();
            this.user.setId(userId);
            this.user.setLogin(user.getLogin());
            this.user.setName(user.getName());
            if (adminService.getPhotoFile(user.getId()) != null) {
                this.user.setAvatar(this.buildAvatarURL(userId));
            }
            Server.logInfoMessage("User " + userId + " successfully authenticated");
        }
        catch (ParseException e) {
            throw new UnauthorizedException(e.getMessage());
        }
    }

    public String buildAvatarURL(String userId) throws UnauthorizedException {
        CSBaseAuthenticationServiceImpl auth = new CSBaseAuthenticationServiceImpl();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("userId", userId);
        Calendar c = Calendar.getInstance();
        c.add(1, 10);
        return RestService.getInstance().getExternalURL() + "/links/avatar/" + auth.createToken(this.getId(), attrs, c.getTime());
    }

    public String getId() {
        return this.id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.modifiedAt = System.currentTimeMillis();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
        this.modifiedAt = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }
}

