/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice;

import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.filetransferservice.FileTransferService;

public abstract class FileTransferJob
implements Runnable {
    private final FileTransferRequest request;

    public FileTransferRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.request.markRunning();
        FileTransferService service = FileTransferService.getInstance();
        String requestId = this.request.getId();
        FileTransferConnection connection = this.request.getConnection();
        Object userId = connection.getUserId();
        Service.setUserId(userId);
        try {
            this.transfer();
        }
        catch (Exception e) {
            this.request.markError(e.getMessage());
            Server.logSevereMessage("Falha em: " + requestId, e);
        }
        finally {
            Service.setUserId(null);
        }
        this.request.markEnd();
        service.moveToEndedList(requestId);
    }

    protected abstract void transfer() throws Exception;

    public FileTransferJob(FileTransferRequest request) {
        this.request = request;
    }
}

