/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_7;

import csbase.exception.PermissionException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.logic.CommandStatus;
import csbase.logic.CommandSubmission;
import csbase.logic.CommonClientProject;
import csbase.logic.ManifestVersion;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.opendreams.v1_7.AlgorithmTemplate;
import csbase.server.services.opendreamsservice.opendreams.v1_7.AlgorithmTemplateException;
import csbase.server.services.opendreamsservice.opendreams.v1_7.JobInfoQueue;
import csbase.server.services.opendreamsservice.opendreams.v1_7.OpenDreams;
import csbase.server.services.opendreamsservice.opendreams.v1_7.Session;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.server.services.sgaservice.SGAService;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.filters.BodyTypeFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.openbus.DRMAA.v1_7.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.v1_7.AuthorizationException;
import tecgraf.openbus.DRMAA.v1_7.DeniedByDrmException;
import tecgraf.openbus.DRMAA.v1_7.DrmCommunicationException;
import tecgraf.openbus.DRMAA.v1_7.ExitTimeoutException;
import tecgraf.openbus.DRMAA.v1_7.InternalException;
import tecgraf.openbus.DRMAA.v1_7.InvalidArgumentException;
import tecgraf.openbus.DRMAA.v1_7.InvalidContactStringException;
import tecgraf.openbus.DRMAA.v1_7.InvalidJobException;
import tecgraf.openbus.DRMAA.v1_7.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.v1_7.JobControlAction;
import tecgraf.openbus.DRMAA.v1_7.JobInfo;
import tecgraf.openbus.DRMAA.v1_7.JobState;
import tecgraf.openbus.DRMAA.v1_7.JobTemplate;
import tecgraf.openbus.DRMAA.v1_7.NoActiveSessionException;
import tecgraf.openbus.DRMAA.v1_7.Version;
import tecgraf.openbus.opendreams.v1_7.OpenDreamsJobTemplate;
import tecgraf.openbus.opendreams.v1_7.OpenDreamsJobTemplateImpl;

public class OpenDreamsSession
extends Session {
    private static final int TERMINATE_SLEEP_TRY = 50;
    private CommonClientProject project;
    private String userId;
    private boolean isActive = false;
    private Set<JobTemplate> validJobTemplates;
    private JobInfoQueue jobInfoQueue = new JobInfoQueue();
    private Version drmsVersion;
    private String drmsInfo;
    private String drmaaImplementation;
    private String drmsContact;
    private Map<String, OpenDreamsJobTemplate> contexts;
    private Serializable consumerId;

    public OpenDreamsSession() {
        ManifestVersion version = new ManifestVersion(((Object)((Object)this)).getClass());
        this.drmsVersion = new Version(version.getMajorVersion(), version.getMinorVersion());
        this.drmsContact = OpenBusService.getInstance().getEntityName();
        this.drmsInfo = Server.getInstance().getSystemName();
        this.drmaaImplementation = MessageFormat.format("{0} - {1} - {2}", this.drmsContact, this.drmsInfo, version.getVersionName());
        this.contexts = new Hashtable<String, OpenDreamsJobTemplate>();
        this.registerListener();
    }

    @Override
    public void init(String contactString) throws AlreadyActiveSessionException, InternalException, AuthorizationException, InvalidContactStringException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: init (" + contactString + ")");
            OpenDreams.checkUser(userId);
            if (contactString != null && !contactString.equals("") && !contactString.equals(this.drmsContact)) {
                throw new InvalidContactStringException("N\u00e3o existe um DRMS com nome " + contactString + ". O correto deve ser: " + this.drmsContact);
            }
            if (this.isActive) {
                throw new AlreadyActiveSessionException("A sess\u00e3o j\u00e1 est\u00e1 ativa");
            }
            this.isActive = true;
            this.validJobTemplates = new HashSet<JobTemplate>();
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de iniciar uma sess\u00e3o OpenDreams do usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidContactStringException e) {
            String msg = "Falha na tentativa de iniciar uma sess\u00e3o OpenDreams do usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (AlreadyActiveSessionException e) {
            String msg = "Falha na tentativa de iniciar uma sess\u00e3o OpenDreams do usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na inicializa\u00e7\u00e3o da sess\u00e3o do usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public void exit() throws AuthorizationException, NoActiveSessionException, InternalException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: exit()");
            OpenDreams.checkUser(userId);
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o j\u00e1 est\u00e1 fechada");
            }
            this.isActive = false;
            this.validJobTemplates.clear();
            this.validJobTemplates = null;
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de fechar uma sess\u00e3o OpenDreams do usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (NoActiveSessionException e) {
            String msg = "Falha na tentativa de fechar uma sess\u00e3o OpenDreams do usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na finaliza\u00e7\u00e3o da sess\u00e3o OpenDreams do usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public JobTemplate createJobTemplate() throws AuthorizationException, NoActiveSessionException, InternalException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: createJobTemplate()");
            OpenDreams.checkUser(userId);
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o n\u00e3o est\u00e1 ativa");
            }
            OpenDreamsJobTemplateImpl jt = new OpenDreamsJobTemplateImpl();
            this.validJobTemplates.add((JobTemplate)jt);
            OpenDreamsJobTemplateImpl openDreamsJobTemplateImpl = jt;
            return openDreamsJobTemplateImpl;
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de criar um JobTemplate pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (NoActiveSessionException e) {
            String msg = "Falha na tentativa de criar um JobTemplate pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na cria\u00e7\u00e3o de um JobTemplate pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public void deleteJobTemplate(JobTemplate jt) throws InvalidJobTemplateException, AuthorizationException, NoActiveSessionException, InternalException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: deleteJobTemplate()");
            OpenDreams.checkUser(userId);
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o n\u00e3o est\u00e1 ativa");
            }
            if (!this.isValidJobTemplate(jt)) {
                throw new InvalidJobTemplateException("N\u00e3o \u00e9 um job template v\u00e1lido nessa sess\u00e3o");
            }
            this.validJobTemplates.remove(jt);
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de remover um JobTemplate pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (NoActiveSessionException e) {
            String msg = "Falha na tentativa de remover um JobTemplate pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidJobTemplateException e) {
            String msg = "Falha na tentativa de remover um JobTemplate pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na remo\u00e7\u00e3o de um jobtemplate pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public String[] runBulkJobs(JobTemplate jt, int beginIndex, int endIndex, int step) throws InvalidArgumentException, InternalException, AuthorizationException, DeniedByDrmException, InvalidJobTemplateException, NoActiveSessionException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: runBulkJobs (" + beginIndex + ", " + endIndex + ", " + step + ")");
            OpenDreams.checkUser(userId);
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o n\u00e3o est\u00e1 ativa");
            }
            if (!this.isValidJobTemplate(jt)) {
                throw new InvalidJobTemplateException("N\u00e3o \u00e9 um job template v\u00e1lido");
            }
            if (beginIndex < 1) {
                throw new InvalidArgumentException("O valor do argumento beginIndex deve ser maior que 1");
            }
            if (beginIndex > endIndex) {
                throw new InvalidArgumentException("O valor do argumento beginIndex deve ser menor ou igual ao valor do argumento endIndex");
            }
            if (step <= 0) {
                throw new InvalidArgumentException("O valor do argumento step deve ser positivo");
            }
            if (OpenDreamsJobTemplate.class.isInstance(jt)) {
                Vector<String> jobsIds = new Vector<String>();
                String baseOutputPath = jt.outputPath;
                for (int i = beginIndex; i <= endIndex; i += step) {
                    OpenDreamsJobTemplate subJobTemplate = (OpenDreamsJobTemplate)OpenDreamsJobTemplate.class.cast(((OpenDreamsJobTemplateImpl)OpenDreamsJobTemplateImpl.class.cast(jt)).clone());
                    if (baseOutputPath != null && baseOutputPath.length() > 0) {
                        subJobTemplate.outputPath = baseOutputPath.replaceAll("_drmaa_incr_ph_", String.valueOf(i));
                    }
                    jobsIds.add(this.executeAlgorithm(userId, subJobTemplate));
                }
                String[] stringArray = jobsIds.toArray(new String[0]);
                return stringArray;
            }
            String[] jobsIds = null;
            return jobsIds;
        }
        catch (AuthorizationException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (NoActiveSessionException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidJobTemplateException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidArgumentException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (AlgorithmTemplateException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.getMessage();
            Server.logWarningMessage(msg);
            throw new DeniedByDrmException(msg);
        }
        catch (PermissionException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.getMessage();
            Server.logWarningMessage(msg);
            throw new AuthorizationException(msg);
        }
        catch (Throwable e) {
            String msg = "Erro na submiss\u00e3o do comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public String runJob(JobTemplate jt) throws InternalException, AuthorizationException, DeniedByDrmException, InvalidJobTemplateException, NoActiveSessionException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: runJob");
            OpenDreams.checkUser(userId);
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o n\u00e3o est\u00e1 ativa");
            }
            if (!this.isValidJobTemplate(jt)) {
                throw new InvalidJobTemplateException("N\u00e3o \u00e9 um job template v\u00e1lido");
            }
            if (OpenDreamsJobTemplate.class.isInstance(jt)) {
                String result;
                String string = result = this.executeAlgorithm(userId, (OpenDreamsJobTemplate)OpenDreamsJobTemplate.class.cast(jt));
                return string;
            }
            String result = null;
            return result;
        }
        catch (AuthorizationException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (NoActiveSessionException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidJobTemplateException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (AlgorithmTemplateException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.getMessage();
            Server.logWarningMessage(msg);
            throw new DeniedByDrmException(msg);
        }
        catch (PermissionException e) {
            String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.getMessage();
            Server.logWarningMessage(msg);
            throw new AuthorizationException(msg);
        }
        catch (Throwable e) {
            String msg = "Erro na submiss\u00e3o do comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public void synchronize(String[] jobList, long timeout, boolean dispose) throws AuthorizationException, ExitTimeoutException, InternalException, InvalidJobException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            StringBuffer jobListString = new StringBuffer("{ ");
            for (String jobName : jobList) {
                jobListString.append(jobName + " ");
            }
            jobListString.append("}");
            Server.logFineMessage("OpenDreamsSession: synchronize (" + jobListString.toString() + ", " + timeout + ", " + dispose + ")");
            OpenDreams.checkUser(userId);
            if (jobList[0].equals("DRMAA_JOB_IDS_SESSION_ALL")) {
                this.jobInfoQueue.waitForAllJobs(timeout, dispose);
            } else {
                this.jobInfoQueue.waitFor(jobList, timeout, dispose);
            }
        }
        catch (AuthorizationException e) {
            String msg = "Falha na consulta synchronize ao t\u00e9rmino do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (ExitTimeoutException e) {
            String msg = "Timeout esgotado na consulta synchronize do t\u00e9rmino do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidJobException e) {
            String msg = "Falha na consulta synchronize ao t\u00e9rmino do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na consulta synchronize ao t\u00e9rmino do comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public JobInfo _wait(String jobName, long timeout) throws AuthorizationException, ExitTimeoutException, InternalException, InvalidJobException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: _wait (" + jobName + ", " + timeout + ")");
            OpenDreams.checkUser(userId);
            if (jobName.equals("DRMAA_JOB_IDS_SESSION_ANY")) {
                JobInfo jobInfo = this.jobInfoQueue.waitForAnyJob(timeout);
                return jobInfo;
            }
            JobInfo jobInfo = this.jobInfoQueue.waitFor(jobName, timeout);
            return jobInfo;
        }
        catch (AuthorizationException e) {
            String msg = "Falha na consulta wait ao t\u00e9rmino do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (ExitTimeoutException e) {
            String msg = "Falha na consulta wait ao t\u00e9rmino do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidJobException e) {
            String msg = "Falha na consulta wait ao t\u00e9rmino do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na consulta wait ao t\u00e9rmino do comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobState jobStatus(String jobName) throws AuthorizationException, InternalException, InvalidJobException {
        String msg;
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: jobStatus (" + jobName + ")");
            OpenDreams.checkUser(userId);
            try {
                JobInfoQueue jobInfoQueue = this.jobInfoQueue;
                synchronized (jobInfoQueue) {
                    JobInfo jobInfo = this.jobInfoQueue.getJobInfo(jobName);
                    if (jobInfo.hasExited) {
                        JobState jobState = jobInfo.exitStatus == 0 ? JobState.DONE : JobState.FAILED;
                        return jobState;
                    }
                }
            }
            catch (InvalidJobException invalidJobException) {
                // empty catch block
            }
            CommandInfo commandInfo = CommandPersistenceService.getInstance().getCommandInfo(this.project.getId(), jobName);
            if (commandInfo == null) {
                throw new InvalidJobException("N\u00e3o foi encontrado um job com o nome: " + jobName);
            }
            CommandStatus status = commandInfo.getStatus();
            if (status == CommandStatus.SCHEDULED) {
                JobState jobState = JobState.QUEUED_ACTIVE;
                return jobState;
            }
            if (status == CommandStatus.INIT || status == CommandStatus.UPLOADING || status == CommandStatus.EXECUTING || status == CommandStatus.DOWNLOADING) {
                JobState jobState = JobState.RUNNING;
                return jobState;
            }
            if (status == CommandStatus.FINISHED) {
                CommandFinalizationType finnalizationType = commandInfo.getFinalizationType();
                if (finnalizationType == CommandFinalizationType.UNKNOWN || finnalizationType == CommandFinalizationType.END || finnalizationType == CommandFinalizationType.SUCCESS) {
                    JobState jobState = JobState.DONE;
                    return jobState;
                }
                if (finnalizationType == CommandFinalizationType.EXECUTION_ERROR || finnalizationType == CommandFinalizationType.FAILED || finnalizationType == CommandFinalizationType.KILLED || finnalizationType == CommandFinalizationType.NO_EXIT_CODE) {
                    JobState jobState = JobState.FAILED;
                    return jobState;
                }
            }
            JobState jobState = JobState.UNDETERMINED;
            return jobState;
        }
        catch (AuthorizationException e) {
            msg = "Falha na recupera\u00e7\u00e3o do estado do job " + jobName + " pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidJobException e) {
            msg = "Falha na recupera\u00e7\u00e3o do estado do job " + jobName + " pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do estado do job " + jobName + " pelo usu\u00e1rio " + userId, e);
            throw new InternalException(e.toString());
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public String contact() {
        return this.drmsContact;
    }

    @Override
    public void control(String jobName, JobControlAction operation) throws NoActiveSessionException, AuthorizationException, InvalidArgumentException, InvalidJobException, DrmCommunicationException, InternalException {
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreamsSession: control (" + jobName + ", " + operation.toString());
            OpenDreams.checkUser(userId);
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o n\u00e3o est\u00e1 ativa");
            }
            if (operation.equals(JobControlAction.HOLD) || operation.equals(JobControlAction.RELEASE) || operation.equals(JobControlAction.SUSPEND) || operation.equals(JobControlAction.RESUME)) {
                throw new InvalidArgumentException("Opera\u00e7\u00e3o " + operation.toString() + " n\u00e3o implementada");
            }
            if (jobName.equals("DRMAA_JOB_IDS_SESSION_ALL")) {
                String[] jobIds;
                for (String jobId : jobIds = this.jobInfoQueue.getAllJobs()) {
                    this.terminateJob(jobId);
                }
            } else {
                this.terminateJob(jobName);
            }
        }
        catch (NoActiveSessionException e) {
            String msg = "Falha na tentativa de alterar o estado de um comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de alterar o estado de um comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidArgumentException e) {
            String msg = "Falha na tentativa de alterar o estado de um comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidJobException e) {
            String msg = "Falha na tentativa de alterar o estado de um comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (DrmCommunicationException e) {
            String msg = "Falha na tentativa de alterar o estado de um comando pelo usu\u00e1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na tentativa de alterar o estado de um comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public Version version() {
        return this.drmsVersion;
    }

    @Override
    public String drmaaImplementation() {
        return this.drmaaImplementation;
    }

    @Override
    public String drmsInfo() {
        return this.drmsInfo;
    }

    public void setProject(CommonClientProject project) {
        this.project = project;
    }

    public void setUser(String userId) {
        this.userId = userId;
    }

    public CommonClientProject getProject() {
        return this.project;
    }

    private boolean isValidJobTemplate(JobTemplate jt) {
        return this.validJobTemplates.contains(jt);
    }

    private String executeAlgorithm(String userId, OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        AlgorithmTemplate validator = new AlgorithmTemplate(this.project, userId, jt);
        AlgorithmConfigurator configurator = validator.getAlgorithmConfigurator();
        CommandSubmission submission = new CommandSubmission(configurator, this.project.getId());
        submission.setDescription(jt.jobDescription);
        submission.setPriority(Priority.values()[jt.jobPriority]);
        submission.setEmailList(jt.email);
        submission.setMailAtEnd(!jt.blockEmail);
        submission.configureSimpleExecution(jt.jobExecutionServer.isEmpty() ? null : jt.jobExecutionServer);
        Set<CommandInfo> commandInfos = null;
        try {
            commandInfos = SchedulerService.getInstance().submitCommand(submission);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        String cmdId = commandInfos.toArray(new CommandInfo[0])[0].getId();
        this.jobInfoQueue.jobSubmited(cmdId);
        this.contexts.put(cmdId, jt);
        return cmdId;
    }

    private void registerListener() {
        MessageService messageService = MessageService.getInstance();
        this.consumerId = messageService.setServerMessageListener(new IMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    CommandNotification notification = (CommandNotification)message.getBody();
                    String cmdId = (String)notification.getCommandId();
                    OpenDreamsJobTemplate jt = (OpenDreamsJobTemplate)OpenDreamsSession.this.contexts.get(cmdId);
                    if (jt == null) continue;
                    try {
                        Service.setUserId(OpenDreamsSession.this.userId);
                        OpenDreamsSession.this.commandFinished(notification, jt, OpenDreamsSession.this.userId);
                    }
                    catch (Exception e) {
                        Server.logSevereMessage("Erro ao finalizar o comando " + jt.jobName, e);
                    }
                    finally {
                        Service.setUserId(null);
                    }
                }
            }
        }, new BodyTypeFilter(CommandNotification.class));
    }

    private void commandFinished(CommandNotification notification, OpenDreamsJobTemplate template, String userId) {
        try {
            if (template.outputPath != null && !template.outputPath.isEmpty()) {
                String jobId = notification.getCommandId().toString();
                CommandInfo info = CommandPersistenceService.getInstance().getCommandInfo(this.project.getId(), jobId);
                try {
                    Set files = info.getConfigurator().getStandardOutputFiles();
                    this.createOutputFile(userId, files, template.outputPath);
                }
                catch (RemoteException e) {
                    Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do configurador do comando.", e);
                }
            }
        }
        catch (Throwable e) {
            Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do log de sa\u00edda do comando.", e);
        }
        this.jobInfoQueue.jobExit(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createOutputFile(String userId, Set<FileURLValue> stdOutputFiles, String outputFile) {
        ProjectService projectService = ProjectService.getInstance();
        String[] outputFilePath = FileUtils.splitPath((String)outputFile);
        if (projectService.existsFile(this.project.getId(), outputFilePath)) {
            projectService.removeFile(this.project.getId(), outputFilePath);
        }
        String[] outputDirPath = FileUtils.splitPath((String)FileUtils.getFilePath((String)outputFile));
        String newFileName = FileUtils.getFileName((String)outputFile);
        projectService.createFile(this.project.getId(), outputDirPath, newFileName, "TEXT");
        ClientProjectFile cpf = projectService.getChild(this.project.getId(), outputDirPath, newFileName);
        OutputStream fileTo = null;
        try {
            fileTo = projectService.getOutputStream(this.project.getId(), outputFilePath);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(fileTo));
            for (FileURLValue stdOutputFile : stdOutputFiles) {
                String[] stdOutputFilePath = stdOutputFile.getPathAsArray();
                InputStream fileFrom = null;
                try {
                    if (stdOutputFiles.size() > 1) {
                        printWriter.printf("\n---- %s ----\n", stdOutputFile.getPath());
                    }
                    if (!projectService.existsFile(this.project.getId(), stdOutputFilePath)) continue;
                    fileFrom = projectService.getInputStream(this.project.getId(), stdOutputFilePath);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileFrom));
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        printWriter.println(line);
                        line = bufferedReader.readLine();
                    }
                    printWriter.flush();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Erro na grava\u00e7\u00e3o do arquivo " + stdOutputFile.getPath() + " em " + cpf.getStringPath(), e);
                }
                catch (Exception e) {
                    Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do inputstream do arquivo " + stdOutputFile.getPath(), e);
                }
                finally {
                    try {
                        if (fileFrom == null) continue;
                        fileFrom.close();
                    }
                    catch (IOException e) {
                        Server.logSevereMessage("Erro no fechamento do inputStream do arquivo " + stdOutputFile.getPath(), e);
                    }
                }
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do outputsream do arquivo de sa\u00edda " + cpf.getStringPath(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileTo != null) {
                try {
                    fileTo.close();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Erro no fechamento do outputsream do arquivo de sa\u00edda " + cpf.getStringPath(), e);
                }
            }
        }
        return true;
    }

    public void terminateJob(String jobName) throws AuthorizationException, InvalidJobException, DrmCommunicationException {
        Object projectId;
        CommandPersistenceService commandPersistenceService = CommandPersistenceService.getInstance();
        CommandInfo commandInfo = commandPersistenceService.getCommandInfo(projectId = this.project.getId(), jobName);
        if (commandInfo.getStatus().equals((Object)CommandStatus.SYSTEM_FAILURE)) {
            throw new InvalidJobException("N\u00e3o foi encontrado informa\u00e7\u00e3o sobre o job com identificador " + jobName);
        }
        if (commandInfo.getStatus().equals((Object)CommandStatus.FINISHED)) {
            Server.logInfoMessage("O comando " + jobName + " j\u00e1 terminou e n\u00e3o pode mais ser cancelado");
        }
        SchedulerService schedulerService = SchedulerService.getInstance();
        try {
            if (schedulerService.removeCommand(jobName)) {
                return;
            }
            while (true) {
                if ((commandInfo = commandPersistenceService.getCommandInfo(projectId, jobName)).getStatus().equals((Object)CommandStatus.FINISHED)) {
                    return;
                }
                if (commandInfo.getStatus().equals((Object)CommandStatus.EXECUTING)) {
                    SGAService sgaService = SGAService.getInstance();
                    if (sgaService.killCommand(jobName)) {
                        return;
                    }
                    if (!sgaService.getSGASet(commandInfo.getSGAName()).getAlive()) {
                        throw new DrmCommunicationException("O servidor perdeu a conex\u00e3o com o SGA " + commandInfo.getSGAName());
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException sgaService) {}
            }
        }
        catch (PermissionException e) {
            throw new AuthorizationException("O usu\u00e1rio " + Service.getUser().getId() + " n\u00e3o possui permiss\u00e3o para cancelar o job " + jobName);
        }
    }
}

