/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice;

import csbase.server.Server;
import csbase.server.services.sgaservice.SGA;
import java.io.IOException;
import java.util.StringTokenizer;
import tecgraf.javautils.core.externalcommand.ExternalCommand;

public class FindTransferRate
extends Thread {
    private String iperfCommand;
    private long transferRate;
    private SGA sga;

    public FindTransferRate(SGA sga, int netBenchDuration) {
        this.sga = sga;
        this.iperfCommand = "../sgad/bin/" + sga.getPlatformId() + "/iperf -t " + netBenchDuration + " -f K -c " + sga.getName();
    }

    @Override
    public void run() {
        try {
            ExternalCommand command = new ExternalCommand(this.iperfCommand);
            command.waitFor(true, false);
            String line = command.getStandardOutput(6);
            StringTokenizer st = new StringTokenizer(line, " ");
            while (st.hasMoreElements()) {
                String rate = st.nextToken();
                if (!rate.equals("KBytes")) continue;
                rate = st.nextToken();
                this.transferRate = Long.parseLong(rate);
                break;
            }
        }
        catch (NumberFormatException e) {
            Server.logSevereMessage("Falha na coleta da taxa de transfer\u00eancia de dados na rede.", e);
            this.transferRate = -1L;
        }
        catch (IOException e) {
            Server.logSevereMessage("Falha na coleta da taxa de transfer\u00eancia de dados na rede.", e);
            this.transferRate = -1L;
        }
        catch (InterruptedException e) {
            Server.logSevereMessage("Coleta da taxa de transfer\u00eancia de dados na rede foi interrompida", e);
            this.transferRate = -1L;
        }
        this.sga.setTransferRate(this.transferRate);
    }
}

