/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.algorithmservice;

import csbase.exception.OperationFailureException;
import csbase.exception.ServiceFailureException;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.Utilities;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmOutline;
import csbase.logic.algorithms.AlgorithmProperty;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.server.FileSystem;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.algorithmservice.ModifiableAlgorithmInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import tecgraf.javautils.core.io.FileUtils;

class Algorithm {
    private static final String NAME_FILE_NAME = "name.txt";
    private static final String SORT_ORDER_PROPERTY = "ordem";
    private final ModifiableAlgorithmInfo info;
    private static List<AlgorithmProperty> algorithmProperties;
    private static List<AlgorithmProperty> versionProperties;

    public AlgorithmInfo getInfo() {
        return this.info.toAlgorithmInfo();
    }

    public AlgorithmOutline getOutline() {
        return this.info.getOutline();
    }

    public static Algorithm includeAlgorithm(String dir) throws ServerException {
        String algoDirPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + dir;
        String name = Algorithm.readName(algoDirPath);
        Hashtable<String, String> propertyValues = Algorithm.loadAlgorithmPropertyValues(algoDirPath);
        Algorithm algo = new Algorithm(name, dir, propertyValues);
        algo.readVersions();
        return algo;
    }

    private static String readName(String dirPath) throws ServerException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(dirPath + File.separator + NAME_FILE_NAME));
            String string = br.readLine();
            return string;
        }
        catch (IOException e) {
            throw new ServerException("Falha na obten\u00e7\u00e3o de nome de algoritmo/vers\u00e3o no arquivo " + dirPath + File.separator + NAME_FILE_NAME, e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ieo) {
                    ieo.printStackTrace();
                }
            }
        }
    }

    protected void rename(String newName) throws ServerException {
        String algoDirPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + this.getInfo().getDirectory();
        String aNameFile = algoDirPath + File.separator + NAME_FILE_NAME;
        Algorithm.writeSingleLineFile(aNameFile, newName);
        this.info.rename(newName);
    }

    private static void writeName(String dirPath, String name) throws ServerException {
        String aNameFile = dirPath + File.separator + NAME_FILE_NAME;
        Algorithm.writeSingleLineFile(aNameFile, name);
    }

    private void readVersions() throws ServerException {
        String versionsDirectoryPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + this.info.getDirectory() + File.separator + "versions";
        File versionsDirectoryFile = new File(versionsDirectoryPath);
        if (!versionsDirectoryFile.exists()) {
            String message = MessageFormat.format("O diret\u00f3rio {0} n\u00e3o existe.", versionsDirectoryFile.getAbsolutePath());
            throw new ServerException(message);
        }
        if (!versionsDirectoryFile.isDirectory()) {
            String message = MessageFormat.format("O arquivo {0} deveria ser um diret\u00f3rio.", versionsDirectoryFile.getAbsolutePath());
            throw new ServerException(message);
        }
        File[] versionDirs = versionsDirectoryFile.listFiles();
        if (versionDirs.length <= 0) {
            String message = MessageFormat.format("O algoritmo {0} n\u00e3o possui vers\u00f5es.\nDiret\u00f3rio de vers\u00f5es: {1}.", this.info.getName(), versionsDirectoryFile.getAbsoluteFile());
            Server.logWarningMessage(message);
            return;
        }
        for (File versionDir : versionDirs) {
            try {
                this.readVersion(versionsDirectoryPath, versionDir);
            }
            catch (ServerException exception) {
                String message = MessageFormat.format("Erro ao tentar ler informa\u00e7\u00f5es sobre o algoritmo {0} diret\u00f3rio de vers\u00e3o {1}.", new Object[]{this.info, versionDir.getAbsolutePath()});
                Server.logSevereMessage(message, exception);
            }
        }
    }

    void readVersion(String versionsDirectoryPath, File versionDirectoryFile) throws ServerException {
        if (!versionDirectoryFile.isDirectory()) {
            String message = MessageFormat.format("O arquivo {0} deveria ser um diret\u00f3rio.", versionDirectoryFile.getAbsolutePath());
            throw new ServerException(message);
        }
        String versionDirectoryName = versionDirectoryFile.getName().trim();
        if (!versionDirectoryName.equalsIgnoreCase(".svn")) {
            String versionDirectoryPath = versionsDirectoryPath + File.separator + versionDirectoryName;
            List<FileInfo> configurators = this.getConfigurators(versionDirectoryPath);
            AlgorithmConfigurator.ConfiguratorType type = AlgorithmConfigurator.ConfiguratorType.SIMPLE;
            for (FileInfo file : configurators) {
                if (!file.getName().equals("config.flx")) continue;
                type = AlgorithmConfigurator.ConfiguratorType.FLOW;
                break;
            }
            List<FileInfo> documentation = this.getDocumentation(versionDirectoryPath);
            FileInfo releaseNotes = this.getReleaseNotes(versionDirectoryPath);
            Hashtable<String, String> versionPropertyValues = this.loadVersionPropertyValues(versionDirectoryPath);
            Map<Object, Object> supportedPlatforms = type == AlgorithmConfigurator.ConfiguratorType.FLOW ? Collections.emptyMap() : this.getSupportedPlatforms(versionDirectoryPath);
            AlgorithmVersionInfo versionInfo = new AlgorithmVersionInfo(this.getInfo(), versionDirectoryName, supportedPlatforms, versionPropertyValues, type);
            versionInfo.setDocumentation(documentation);
            versionInfo.setConfigurators(configurators);
            versionInfo.setReleaseNotes(releaseNotes);
            this.info.includeVersion(versionInfo.getId(), versionInfo);
        }
    }

    private List<FileInfo> getConfigurators(String versionDirectoryPath) throws ServerException {
        File directory = new File(versionDirectoryPath + File.separator + "configurator");
        if (!directory.exists()) {
            String message = MessageFormat.format("O diret\u00f3rio {0} n\u00e3o existe.", directory.getAbsolutePath());
            throw new ServerException(message);
        }
        if (!directory.isDirectory()) {
            String message = MessageFormat.format("O arquivo {0} deveria ser um diret\u00f3rio.", directory.getAbsolutePath());
            throw new ServerException(message);
        }
        return FileInfo.createFilesInfo((File)directory);
    }

    private List<FileInfo> getDocumentation(String versionDirectoryPath) throws ServerException {
        File directory = new File(versionDirectoryPath + File.separator + "html");
        if (!directory.exists()) {
            String message = MessageFormat.format("O diret\u00f3rio {0} n\u00e3o existe.", directory.getAbsolutePath());
            throw new ServerException(message);
        }
        if (!directory.isDirectory()) {
            String message = MessageFormat.format("O arquivo {0} deveria ser um diret\u00f3rio.", directory.getAbsolutePath());
            throw new ServerException(message);
        }
        return FileInfo.createFilesInfo((File)directory);
    }

    private FileInfo getReleaseNotes(String versionDirectoryPath) throws ServerException {
        File directory = new File(versionDirectoryPath + File.separator + "notes");
        if (!directory.exists()) {
            return null;
        }
        if (!directory.isDirectory()) {
            String message = MessageFormat.format("O arquivo {0} deveria ser um diret\u00f3rio.", directory.getAbsolutePath());
            throw new ServerException(message);
        }
        return this.getReleaseNotes(FileInfo.createFilesInfo((File)directory));
    }

    private Map<String, List<FileInfo>> getSupportedPlatforms(String vDirPath) throws ServerException {
        HashMap<String, List<FileInfo>> supportedPlatforms = new HashMap<String, List<FileInfo>>();
        String path = vDirPath + File.separator + AlgorithmVersionInfo.BIN_DIR;
        File binDir = new File(path);
        if (!binDir.exists()) {
            String message = MessageFormat.format("O diret\u00f3rio - {0} - que armazena as plataformas n\u00e3o existe.", binDir.getAbsolutePath());
            Server.logWarningMessage(message);
            return supportedPlatforms;
        }
        if (!binDir.isDirectory()) {
            throw new ServerException(MessageFormat.format("O arquivo {0} deveria ser um diret\u00f3rio.", binDir.getAbsolutePath()));
        }
        File[] platformsDir = binDir.listFiles();
        if (platformsDir.length == 0) {
            String message = MessageFormat.format("O diret\u00f3rio - {0} - que armazena as plataformas est\u00e1 vazio.", binDir.getAbsolutePath());
            Server.logWarningMessage(message);
            return supportedPlatforms;
        }
        for (File platform : platformsDir) {
            if (!platform.isDirectory() || !FileInfo.isNameValid((String)platform.getName())) continue;
            List executablesInfo = FileInfo.createFilesInfo((File)platform);
            supportedPlatforms.put(platform.getName(), executablesInfo);
        }
        return supportedPlatforms;
    }

    public static Algorithm createAlgorithm(String name, Hashtable<String, String> propertyValues) throws ServerException {
        return Algorithm.createAlgorithm(null, name, propertyValues);
    }

    public static Algorithm createAlgorithm(String algoId, String name, Hashtable<String, String> propertyValues) throws ServerException {
        return Algorithm.createAlgorithmStructure(algoId, name, propertyValues);
    }

    private static Algorithm createAlgorithmStructure(String algoId, String name, Hashtable<String, String> propertyValues) throws ServerException {
        String algoDirName = Algorithm.defineAlgoDirName(algoId, name);
        String algoDirPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + algoDirName;
        try {
            Algorithm.createAlgoRootDir(algoDirPath);
            Algorithm.createAlgoSubDirectories(algoDirPath);
            Algorithm.writeName(algoDirPath, name);
            String pathToPropFile = algoDirPath + File.separator + "algorithm.properties";
            Algorithm.saveOwnerPropertyValue(Service.getUser().getLogin(), propertyValues);
            Algorithm.savePropertyValues(pathToPropFile, propertyValues);
            return new Algorithm(name, algoDirName, propertyValues);
        }
        catch (ServerException se) {
            try {
                FileSystem.removeFile(new File(algoDirPath), true);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha na remo\u00e7\u00e3o de arquivo/diret\u00f3rio \n\tExce\u00e7\u00e3o: " + e);
            }
            throw se;
        }
    }

    private static String defineAlgoDirName(String id, String name) {
        String baseName = id;
        if (baseName == null || baseName.isEmpty()) {
            baseName = name;
        }
        String algoDirName = FileUtils.fixDirectoryName((String)baseName);
        while (Algorithm.getService().algorithmIdRegistered(algoDirName)) {
            algoDirName = algoDirName + "_";
        }
        return algoDirName;
    }

    private static void createAlgoRootDir(String algoDirPath) throws ServerException {
        File algoDir = new File(algoDirPath);
        if (algoDir.exists()) {
            throw new ServerException("Diret\u00f3rio " + algoDirPath + " j\u00e1 existe!");
        }
        if (!algoDir.mkdir()) {
            throw new ServerException("Falha na cria\u00e7\u00e3o do diret\u00f3rio " + algoDirPath);
        }
    }

    private static void createAlgoSubDirectories(String algoDirPath) throws ServerException {
        String verDirPath = algoDirPath + File.separator + "versions";
        File verDir = new File(verDirPath);
        if (!verDir.mkdir()) {
            throw new ServerException("Falha na cria\u00e7\u00e3o do diret\u00f3rio de vers\u00f5es " + verDirPath);
        }
    }

    public void remove() throws ServerException {
        String algoDirPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + this.info.getDirectory();
        File algoFile = new File(algoDirPath);
        try {
            FileSystem.removeFile(algoFile, true);
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage(), e);
        }
    }

    private static String getAlgorithmRepositoryPath() {
        return Algorithm.getService().getAlgorithmRepositoryPath();
    }

    public void reload() throws ServerException {
        this.readVersions();
    }

    public void removeVersion(Object versionId) throws ServerException {
        AlgorithmVersionInfo versionInfo = this.info.getVersionInfo(versionId);
        String versionDirPath = versionInfo.getDirPath();
        File versionFile = new File(versionDirPath);
        try {
            FileSystem.removeFile(versionFile, true);
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage(), e);
        }
        this.info.deleteVersion(versionId);
    }

    public Object createVersion(int major, int minor, int patch, Map<String, String> propertyValues) throws ServerException {
        String algoDir = this.info.getDirectory();
        String algoDirPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + algoDir;
        String versionDir = AlgorithmVersionInfo.getDirectoryFor((int)major, (int)minor, (int)patch);
        String versionDirPath = algoDirPath + File.separator + "versions" + File.separator + versionDir;
        this.createVersionRootDir(versionDirPath);
        try {
            this.createVersionSubDirectories(versionDirPath);
        }
        catch (ServerException se) {
            try {
                FileSystem.removeFile(new File(versionDirPath), true);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha na remo\u00e7\u00e3o de arquivo/diret\u00f3rio.", e);
            }
            throw se;
        }
        Hashtable supportedPlatforms = new Hashtable();
        String pathToPropFile = versionDirPath + File.separator + "version.properties";
        Algorithm.saveOwnerPropertyValue(this.getOwner(), propertyValues);
        Algorithm.savePropertyValues(pathToPropFile, propertyValues);
        AlgorithmVersionInfo versionInfo = new AlgorithmVersionInfo(this.getInfo(), new AlgorithmVersionId(major, minor, patch), supportedPlatforms, propertyValues, null);
        AlgorithmVersionId versionId = versionInfo.getId();
        this.info.includeVersion(versionId, versionInfo);
        return versionId;
    }

    public void createVersionStructure(AlgorithmVersionId versionId, Map<String, String> propertyValues) throws ServerException {
        int major = versionId.getMajor();
        int minor = versionId.getMinor();
        int patch = versionId.getPatch();
        String algoDir = this.info.getDirectory();
        String algoDirPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + algoDir;
        String versionDir = AlgorithmVersionInfo.getDirectoryFor((int)major, (int)minor, (int)patch);
        String versionDirPath = algoDirPath + File.separator + "versions" + File.separator + versionDir;
        this.createVersionRootDir(versionDirPath);
        try {
            this.createVersionSubDirectories(versionDirPath);
        }
        catch (ServerException se) {
            try {
                FileSystem.removeFile(new File(versionDirPath), true);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha na remo\u00e7\u00e3o de arquivo/diret\u00f3rio.", e);
            }
            throw se;
        }
        Hashtable supportedPlatforms = new Hashtable();
        String pathToPropFile = versionDirPath + File.separator + "version.properties";
        Algorithm.saveOwnerPropertyValue(this.getOwner(), propertyValues);
        Algorithm.savePropertyValues(pathToPropFile, propertyValues);
        AlgorithmVersionInfo versionInfo = new AlgorithmVersionInfo(this.getInfo(), versionId, supportedPlatforms, propertyValues, null);
        this.info.includeVersion(versionId, versionInfo);
    }

    private void createVersionRootDir(String versionDirPath) throws ServerException {
        File versionDir = new File(versionDirPath);
        if (versionDir.exists()) {
            throw new ServerException("Diret\u00f3rio " + versionDirPath + " j\u00e1 existe!");
        }
        if (!versionDir.mkdir()) {
            throw new ServerException("Falha na cria\u00e7\u00e3o do diret\u00f3rio " + versionDirPath);
        }
    }

    private void createVersionSubDirectories(String versionDirPath) throws ServerException {
        String confDirPath = versionDirPath + File.separator + "configurator";
        File confDir = new File(confDirPath);
        if (!confDir.mkdir()) {
            throw new ServerException("Falha na cria\u00e7\u00e3o do diret\u00f3rio do configurador " + confDirPath);
        }
        String binDirPath = versionDirPath + File.separator + AlgorithmVersionInfo.BIN_DIR;
        File binDir = new File(binDirPath);
        if (!binDir.mkdir()) {
            throw new ServerException("Falha na cria\u00e7\u00e3o do diretorio de execut\u00e1veis: " + binDirPath);
        }
        String docDirPath = versionDirPath + File.separator + "html";
        File docDir = new File(docDirPath);
        if (!docDir.mkdir()) {
            throw new ServerException("Falha na cria\u00e7\u00e3o do diretorio de arquivos de documenta\u00e7\u00e3o: " + docDirPath);
        }
        String notesDirPath = versionDirPath + File.separator + "notes";
        File notesDir = new File(notesDirPath);
        if (!notesDir.mkdir()) {
            throw new ServerException("Falha na cria\u00e7\u00e3o do diretorio de arquivos de release notes: " + notesDirPath);
        }
    }

    protected void updateConfigurations(Object versionId) throws OperationFailureException {
        AlgorithmVersionInfo versionInfo = this.info.getVersionInfo(versionId);
        File configDir = new File(versionInfo.getConfiguratorDirPath());
        if (!configDir.exists()) {
            String msg = AlgorithmService.getInstance().getString("server.algoservice.error.config_version_not_found");
            Object[] args = new Object[]{this.info.getId(), versionId};
            msg = MessageFormat.format(msg, args);
            throw new OperationFailureException(msg);
        }
        String versionsDirectoryPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + this.info.getDirectory() + File.separator + "versions";
        String algoVersionPath = versionInfo.getDirPath();
        File versionDirectory = new File(algoVersionPath);
        try {
            this.readVersion(versionsDirectoryPath, versionDirectory);
        }
        catch (ServerException exception) {
            String message = MessageFormat.format("Erro ao tentar ler informa\u00e7\u00f5es sobre o algoritmo {0} diret\u00f3rio de vers\u00e3o {1}.", new Object[]{this.info, versionDirectory.getAbsolutePath()});
            Server.logSevereMessage(message, exception);
        }
    }

    protected void updateDocumentations(Object versionId) throws OperationFailureException {
        AlgorithmVersionInfo versionInfo = this.info.getVersionInfo(versionId);
        File docDir = new File(versionInfo.getDocDirPath());
        if (!docDir.exists()) {
            String msg = AlgorithmService.getInstance().getString("server.algoservice.error.doc_version_not_found");
            Object[] args = new Object[]{this.info.getId(), versionId};
            msg = MessageFormat.format(msg, args);
            throw new OperationFailureException(msg);
        }
        List documentation = FileInfo.createFilesInfo((File)docDir);
        versionInfo.setDocumentation(documentation);
    }

    protected void updateReleaseNotes(Object versionId, String fileName) throws OperationFailureException {
        AlgorithmVersionInfo versionInfo = this.info.getVersionInfo(versionId);
        File textDir = new File(versionInfo.getReleaseNotesDirPath());
        if (!textDir.exists()) {
            String msg = AlgorithmService.getInstance().getString("server.algoservice.error.release_notes_version_not_found");
            Object[] args = new Object[]{this.info.getId(), versionId};
            msg = MessageFormat.format(msg, args);
            throw new OperationFailureException(msg);
        }
        List files = FileInfo.createFilesInfo((File)textDir);
        versionInfo.setReleaseNotes(this.getReleaseNotes(files));
    }

    private FileInfo getReleaseNotes(List<FileInfo> files) {
        for (FileInfo file : files) {
            if (!file.getPath().equals("releasenotes.txt")) continue;
            return file;
        }
        return null;
    }

    protected void updateExecutables(Object versionId, String platform) throws OperationFailureException {
        AlgorithmVersionInfo versionInfo = this.info.getVersionInfo(versionId);
        String platDirPath = versionInfo.getPlatformPath(platform);
        File platDir = new File(platDirPath);
        if (!platDir.exists()) {
            String msg = AlgorithmService.getInstance().getString("server.algoservice.error.plat_version_not_found");
            Object[] args = new Object[]{this.info.getId(), versionId, platform};
            msg = MessageFormat.format(msg, args);
            throw new OperationFailureException(msg);
        }
        List executables = FileInfo.createFilesInfo((File)platDir);
        for (FileInfo file : executables) {
            if (file.isDirectory()) continue;
            try {
                String path = new File(platDir, file.getPath()).getAbsolutePath();
                FileSystem.enableExecutionPermission(path);
            }
            catch (ServerException e) {
                throw new OperationFailureException((Throwable)e);
            }
        }
        versionInfo.setPlatformExecutables(platform, executables);
    }

    private boolean deleteFile(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (this.deleteFile(child)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public void removeExecutableFiles(AlgorithmVersionInfo version, String platform, FileInfo[] files) throws Exception {
        for (FileInfo file : files) {
            String path = version.getExecFilePath(platform, file.getPath());
            File serverFile = new File(path);
            try {
                if (this.deleteFile(serverFile)) continue;
                String msg = AlgorithmService.getInstance().getString("server.algoservice.error.copy_server");
                throw new Exception(msg);
            }
            catch (Exception e) {
                String msg = AlgorithmService.getInstance().getString("server.algoservice.error.remove_exe");
                Object[] args = new Object[]{serverFile.getName(), this.info.getId(), version.getId(), platform};
                msg = MessageFormat.format(msg, args);
                throw new Exception(msg + e.getMessage(), e);
            }
        }
        this.reload();
    }

    public void removeConfigurationFiles(AlgorithmVersionInfo version, FileInfo[] files) throws Exception {
        for (FileInfo file : files) {
            String path = version.getConfiguratorDirPath() + File.separator + file.getPath();
            File serverFile = new File(path);
            try {
                if (this.deleteFile(serverFile)) continue;
                String msg = AlgorithmService.getInstance().getString("server.algoservice.error.copy_server");
                throw new Exception(msg);
            }
            catch (Exception e) {
                String msg = AlgorithmService.getInstance().getString("server.algoservice.error.remove_config");
                Object[] args = new Object[]{this.info.getId(), version.getId()};
                msg = MessageFormat.format(msg, args);
                throw new Exception(msg + e.getMessage(), e);
            }
        }
        this.reload();
    }

    public void removeDocumentationFiles(AlgorithmVersionInfo version, FileInfo[] files) throws Exception {
        for (FileInfo file : files) {
            String path = version.getDocDirPath() + File.separator + file.getPath();
            File serverFile = new File(path);
            try {
                if (this.deleteFile(serverFile)) continue;
                String msg = AlgorithmService.getInstance().getString("server.algoservice.error.copy_server");
                throw new Exception(msg);
            }
            catch (Exception e) {
                String msg = AlgorithmService.getInstance().getString("server.algoservice.error.remove_doc");
                Object[] args = new Object[]{serverFile.getName(), this.info.getId(), version.getId()};
                msg = MessageFormat.format(msg, args);
                throw new Exception(msg + e.getMessage(), e);
            }
        }
        this.reload();
    }

    public void removeReleaseNotesFiles(AlgorithmVersionInfo version, FileInfo[] files) throws Exception {
        for (FileInfo file : files) {
            String path = version.getReleaseNotesDirPath() + File.separator + file.getPath();
            File serverFile = new File(path);
            try {
                if (this.deleteFile(serverFile)) continue;
                String msg = AlgorithmService.getInstance().getString("server.algoservice.error.copy_server");
                throw new Exception(msg);
            }
            catch (Exception e) {
                String msg = AlgorithmService.getInstance().getString("server.algoservice.error.remove_notes");
                Object[] args = new Object[]{serverFile.getName(), this.info.getId(), version.getId()};
                msg = MessageFormat.format(msg, args);
                throw new Exception(msg + e.getMessage(), e);
            }
        }
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean copyFile(String fromPath, String toPath, boolean setExecutable) throws Exception {
        try {
            boolean bl = this.copyFileWithoutReloading(fromPath, toPath, setExecutable);
            return bl;
        }
        finally {
            this.reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFiles(List<FileInfo> files, IPathFactory sourcePathFactory, FileInfo targetDir, IPathFactory targetPathFactory, boolean setExecutables, List<ICopyRecord> records) throws Exception {
        try {
            this.copyFilesWithoutReloading(files, sourcePathFactory, targetDir, targetPathFactory, setExecutables, records);
        }
        finally {
            this.reload();
        }
    }

    void copyFilesWithoutReloading(List<FileInfo> files, IPathFactory sourcePathFactory, FileInfo targetDir, IPathFactory targetPathFactory, boolean setExecutables, List<ICopyRecord> records) throws Exception {
        for (FileInfo file : files) {
            FileInfo targetFileInfo;
            if (null != targetDir) {
                String[] newDirPath = Utilities.splitProjectPath((String)targetDir.getPath());
                targetFileInfo = new FileInfo(newDirPath, file.getName(), file.isDirectory());
            } else {
                targetFileInfo = new FileInfo(file.getName(), file.isDirectory());
            }
            String targetPath = targetPathFactory.getPath(targetFileInfo);
            if (file.isDirectory()) {
                File targetFile = new File(targetPath);
                if (!targetFile.exists()) {
                    targetFile.mkdir();
                    if (null != records) {
                        records.add(new CopyDirectoryRecord(targetFileInfo));
                    }
                }
                this.copyFilesWithoutReloading(file.getChildren(), sourcePathFactory, targetFileInfo, targetPathFactory, setExecutables, records);
                continue;
            }
            String sourcePath = sourcePathFactory.getPath(file);
            boolean created = this.copyFileWithoutReloading(sourcePath, targetPath, setExecutables);
            if (null == records) continue;
            records.add(new CopyFileRecord(file, targetFileInfo, created));
        }
    }

    boolean copyFileWithoutReloading(String fromPath, String toPath, boolean setExecutable) throws Exception {
        if (fromPath.equals(toPath)) {
            return false;
        }
        boolean copyCreated = false;
        File from = new File(fromPath);
        File serverTo = new File(toPath);
        if (!serverTo.exists()) {
            serverTo.createNewFile();
            copyCreated = true;
        }
        if (FileSystem.copyFile(from, serverTo)) {
            if (setExecutable) {
                FileSystem.enableExecutionPermission(toPath);
            }
        } else {
            String msg = AlgorithmService.getInstance().getString("server.algoservice.error.copy_server");
            throw new Exception(msg);
        }
        return copyCreated;
    }

    public void includePlatform(Object versionId, String platform) throws ServerException {
        AlgorithmVersionInfo versionInfo = this.info.getVersionInfo(versionId);
        String platDirPath = versionInfo.getPlatformPath(platform);
        File platDir = new File(platDirPath);
        if (!platDir.mkdirs()) {
            throw new ServerException("Falha na cria\u00e7\u00e3o do diretorio de plataforma: " + platDirPath);
        }
        versionInfo.setPlatform(platform);
    }

    public void removePlatform(Object versionId, String platform) throws ServerException {
        AlgorithmVersionInfo versionInfo = this.info.getVersionInfo(versionId);
        String platDirPath = versionInfo.getPlatformPath(platform);
        File platDir = new File(platDirPath);
        try {
            FileSystem.removeFile(platDir, true);
            Map supportedPlatforms = versionInfo.getPlatforms();
            supportedPlatforms.remove(platform);
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage(), e);
        }
    }

    private static void writeSingleLineFile(String fileName, String content) throws ServerException {
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write(content);
            fw.close();
        }
        catch (IOException e) {
            throw new ServerException("Falha na escrita do arquivo " + fileName, e);
        }
    }

    private static AlgorithmService getService() {
        return AlgorithmService.getInstance();
    }

    private Algorithm(String name, String dir, Hashtable<String, String> attributes) {
        String id = dir;
        this.info = new ModifiableAlgorithmInfo(id, name, dir, Algorithm.getAlgorithmRepositoryPath(), attributes);
    }

    public static List<AlgorithmProperty> getAlgorithmProperties() {
        if (algorithmProperties == null) {
            AlgorithmService algoService = AlgorithmService.getInstance();
            String algPropertiesPath = algoService.getAlgorithmPropertyNamesPath();
            algorithmProperties = Algorithm.getProperties(algPropertiesPath);
            Algorithm.validateAlgorithmProperties();
        }
        return algorithmProperties;
    }

    private static void validateAlgorithmProperties() {
        for (AlgorithmProperty algoProperty : algorithmProperties) {
            if (!algoProperty.getKey().equals("criador")) continue;
            String fmt = "Uma propriedade de algoritmo reservada foi detectada: %s";
            String msg = String.format("Uma propriedade de algoritmo reservada foi detectada: %s", algoProperty);
            throw new ServiceFailureException(msg);
        }
    }

    public static List<AlgorithmProperty> getVersionProperties() {
        if (versionProperties == null) {
            AlgorithmService algoService = AlgorithmService.getInstance();
            String versionPropertiesPath = algoService.getVersionPropertyNamesPath();
            versionProperties = Algorithm.getProperties(versionPropertiesPath);
        }
        return versionProperties;
    }

    private static List<AlgorithmProperty> getProperties(String propertyPath) {
        Properties properties = Algorithm.readPropertiesFile(propertyPath);
        ArrayList<String> keys = new ArrayList<String>();
        String sortedProperties = properties.getProperty(SORT_ORDER_PROPERTY);
        ArrayList<AlgorithmProperty> propertyLabels = new ArrayList<AlgorithmProperty>();
        if (sortedProperties != null) {
            String[] sortedPropertiesArray;
            for (String element : sortedPropertiesArray = sortedProperties.split(",")) {
                keys.add(element.trim());
            }
            String propertyKey = null;
            String propertyLabel = null;
            for (int i = 0; i < keys.size(); ++i) {
                propertyKey = (String)keys.get(i);
                propertyLabel = properties.getProperty(propertyKey);
                String type = properties.getProperty(propertyKey + ".tipo");
                if (propertyLabel == null) continue;
                if (type == null) {
                    propertyLabels.add(new AlgorithmProperty(propertyKey, propertyLabel));
                    continue;
                }
                AlgorithmProperty.PropertyType propertyType = AlgorithmProperty.PropertyType.valueOf((String)type.toUpperCase());
                propertyLabels.add(new AlgorithmProperty(propertyKey, propertyLabel, propertyType));
            }
        } else {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String propertyKey = (String)e.nextElement();
                if (propertyKey.endsWith(".tipo")) continue;
                String propertyLabel = properties.getProperty(propertyKey);
                String type = properties.getProperty(propertyKey + ".tipo");
                if (propertyLabel == null) continue;
                if (type == null) {
                    propertyLabels.add(new AlgorithmProperty(propertyKey, propertyLabel));
                    continue;
                }
                AlgorithmProperty.PropertyType propertyType = AlgorithmProperty.PropertyType.valueOf((String)type.toUpperCase());
                propertyLabels.add(new AlgorithmProperty(propertyKey, propertyLabel, propertyType));
            }
        }
        return propertyLabels;
    }

    private static Hashtable<String, String> loadAlgorithmPropertyValues(String algoDirPath) {
        String pathToPropFile = algoDirPath + File.separator + "algorithm.properties";
        List<AlgorithmProperty> algProperties = Algorithm.getAlgorithmProperties();
        return Algorithm.loadPropertiesValues(pathToPropFile, algProperties);
    }

    private static Hashtable<String, String> loadPropertiesValues(String propPath, List<AlgorithmProperty> propertiesList) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Properties properties = Algorithm.readPropertiesFile(propPath);
        for (AlgorithmProperty property : propertiesList) {
            String propValue;
            String propKey = property.getKey();
            AlgorithmProperty.PropertyType type = property.getType();
            if (propKey == null || (propValue = properties.getProperty(propKey)) == null || propValue.length() <= 0) continue;
            if (type == AlgorithmProperty.PropertyType.DOUBLE) {
                try {
                    new Double(propValue);
                }
                catch (NumberFormatException e) {
                    Server.logSevereMessage("Falha na leitura do valor " + propValue + " da vari\u00e1vel " + propKey + " em: " + propPath);
                    continue;
                }
            }
            result.put(propKey, propValue);
        }
        Algorithm.readHideAlgorithmProperty(properties, result);
        Algorithm.readOwnerAlgorithmProperty(properties, result);
        return result;
    }

    private static void readHideAlgorithmProperty(Properties properties, Hashtable<String, String> algoPropertiesTable) {
        String propValue = properties.getProperty("ocultar");
        if (propValue != null && propValue.trim().equals("sim")) {
            algoPropertiesTable.put("ocultar", "sim");
        }
    }

    private static void readOwnerAlgorithmProperty(Properties properties, Hashtable<String, String> algoPropertiesTable) {
        String propValue = properties.getProperty("criador");
        if (propValue != null) {
            algoPropertiesTable.put("criador", propValue);
        }
    }

    private Hashtable<String, String> loadVersionPropertyValues(String versionDirectoryPath) {
        String pathToPropFile = versionDirectoryPath + File.separator + "version.properties";
        List<AlgorithmProperty> vp = Algorithm.getVersionProperties();
        return Algorithm.loadPropertiesValues(pathToPropFile, vp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readPropertiesFile(String path) {
        FileInputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = new FileInputStream(path);
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            Server.logFineMessage("Arquivo de propriedades " + path + " n\u00e3o foi encontrado.");
        }
        catch (IOException e) {
            Server.logSevereMessage("Erro ao ler arquivo de propriedades " + path, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ioe) {
                    Server.logSevereMessage("Erro ao fechar arquivo de propriedades " + path, ioe);
                }
            }
        }
        return properties;
    }

    public void setAlgorithmFieldValuesList(Hashtable<String, String> newValues) {
        String algoDirPath = Algorithm.getAlgorithmRepositoryPath() + File.separator + this.info.getDirectory();
        String pathToPropFile = algoDirPath + File.separator + "algorithm.properties";
        Algorithm.saveOwnerPropertyValue(this.getOwner(), newValues);
        Algorithm.savePropertyValues(pathToPropFile, newValues);
        this.info.setPropertyValues(newValues);
    }

    public void setVersionFieldValuesList(AlgorithmVersionId id, Hashtable<String, String> newValues) {
        AlgorithmVersionInfo version = this.getInfo().getVersionInfo((Object)id);
        String versionDirPath = version.getDirPath();
        String pathToPropFile = versionDirPath + File.separator + "version.properties";
        Algorithm.saveOwnerPropertyValue(this.getOwner(), newValues);
        Algorithm.savePropertyValues(pathToPropFile, newValues);
        version.setPropertyValues(newValues);
    }

    private static void savePropertyValues(String pathToPropFile, Map<String, String> propertyValues) {
        Properties properties = new Properties();
        for (String attributeKey : propertyValues.keySet()) {
            String attributeValue = propertyValues.get(attributeKey);
            properties.put(attributeKey, attributeValue);
        }
        try {
            Algorithm.writePropertiesFile(pathToPropFile, properties);
        }
        catch (ServerException e) {
            Server.logInfoMessage(e.getMessage());
        }
    }

    private static void saveOwnerPropertyValue(String owner, Map<String, String> propertyValues) {
        if (owner != null) {
            propertyValues.put("criador", owner);
        }
    }

    private String getOwner() {
        return this.getInfo().getOwner();
    }

    private static void writePropertiesFile(String pathToPropFile, Properties properties) throws ServerException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(pathToPropFile);
        }
        catch (FileNotFoundException e) {
            String message = "Erro ao escrever arquivo de propriedades " + pathToPropFile;
            throw new ServerException(message, e);
        }
        finally {
            try {
                properties.store(out, "Arquivo de propriedades do algoritmo");
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                String message = "Erro ao escrever arquivo de propriedades " + pathToPropFile;
                throw new ServerException(message, e);
            }
        }
    }

    public static class CopyFileRecord
    implements ICopyRecord {
        private final FileInfo sourceFile;
        private final FileInfo targetFile;
        private final boolean created;

        private CopyFileRecord(FileInfo sourceFile, FileInfo targetFile, boolean created) {
            this.sourceFile = sourceFile;
            this.targetFile = targetFile;
            this.created = created;
        }

        public FileInfo getSourceFile() {
            return this.sourceFile;
        }

        public FileInfo getTargetFile() {
            return this.targetFile;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean wasCreated() {
            return this.created;
        }
    }

    public static class CopyDirectoryRecord
    implements ICopyRecord {
        private final FileInfo path;

        private CopyDirectoryRecord(FileInfo path) {
            this.path = path;
        }

        public FileInfo getDirectory() {
            return this.path;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean wasCreated() {
            return true;
        }
    }

    public static interface ICopyRecord {
        public boolean isDirectory();

        public boolean wasCreated();
    }
}

