/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.openbus;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.openbusservice.OpenBusService;
import java.util.Locale;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import scs.core.IComponentHelper;

public class BusVersionValidation
implements Validation {
    public static final String NAME = "BusVersionValidation";
    private String host;
    private int port;

    public BusVersionValidation(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public ValidationStatus check(Locale locale) {
        OpenBusService service = OpenBusService.getInstance();
        ORB orb = service.getORB();
        if (orb == null) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.openbusmonitor.version.error", locale));
        }
        String str = String.format("corbaloc::1.0@%s:%d/%s", this.host, this.port, "OpenBus_2_0");
        Object obj = orb.string_to_object(str);
        try {
            if (obj == null || obj._non_existent()) {
                return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.openbusmonitor.version.1.5.check", locale));
            }
        }
        catch (OBJECT_NOT_EXIST e) {
            return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.openbusmonitor.version.1.5.check", locale));
        }
        if (obj._is_a(IComponentHelper.id())) {
            return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.openbusmonitor.version.2.0.check", locale));
        }
        return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.openbusmonitor.version.1.5.check", locale));
    }

    @Override
    public String id() {
        return NAME;
    }

    @Override
    public String[] requires() {
        return new String[]{"RegistryServiceValidation"};
    }
}

