/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.openbusservice;

import csbase.exception.OperationFailureException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.logic.BusInfo;
import csbase.logic.ExternalUser;
import csbase.logic.User;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.OpenBusServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusServiceFacet;
import csbase.server.services.openbusservice.OpenBusServiceOffer;
import csbase.server.services.openbusservice.OpenbusStatus;
import csbase.server.services.openbusservice.ReloginAllocator;
import csbase.server.services.openbusservice.ReloginTask;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.interfaces.RSAPrivateKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.IComponent;
import scs.core.exception.SCSException;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.SharedAuthSecret;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.offer_registry.InvalidProperties;
import tecgraf.openbus.core.v2_0.services.offer_registry.InvalidService;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOffer;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_0.services.offer_registry.UnauthorizedFacets;
import tecgraf.openbus.exception.AlreadyLoggedIn;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.exception.InvalidEncodedStream;
import tecgraf.openbus.exception.InvalidLoginProcess;
import tecgraf.openbus.exception.InvalidPropertyValue;
import tecgraf.openbus.security.Cryptography;

public final class OpenBusService
extends Service
implements OpenBusServiceInterface {
    private static final String OPENBUS_OFFER_ID_KEY = "openbus.offer.id";
    private final long TOKEN_EXPIRATION_TIME = 180000L;
    private static OpenBusService instance;
    private final Set<ComponentEntry> components = new HashSet<ComponentEntry>();
    private final Set<ComponentEntry> failedComponents = Collections.synchronizedSet(new HashSet());
    private final Hashtable<String, OpenBusServiceFacet> facets = new Hashtable();
    private ORBThread orbThread;
    private BusInfo busInfo;
    private String entityName;
    private RSAPrivateKey privateKey;
    private boolean acsInitFailed;
    private OpenBusContext context;
    private Properties connectionProps;
    private String lastLogMessage;
    private int numLastLogMessage;
    private static OpenbusStatus openbusStatus;

    private OpenBusService() throws ServerException {
        super("OpenBusService");
        this.setEnabled(this.getBooleanProperty("enabled"));
        if (this.isEnabled()) {
            openbusStatus = new OpenbusStatus(OpenbusStatus.ConnectionState.NOT_INITIALIZED, new Date());
            this.configureOpenbusLogger();
            this.entityName = this.getEntityName();
            String accessControlServiceHost = this.getStringProperty("ACS.hostAddr");
            int accessControlServicePort = this.getIntProperty("ACS.port");
            Properties orbProps = this.getExternalPropertyFile("ORB.file");
            Properties clientORBProps = null;
            if (this.hasProperty("Client.ORB.file")) {
                clientORBProps = this.getExternalPropertyFile("Client.ORB.file");
            }
            this.busInfo = new BusInfo(accessControlServiceHost, accessControlServicePort, orbProps, clientORBProps);
            String privateKeyFilePath = this.getPrivateKeyFilePath();
            try {
                this.privateKey = Cryptography.getInstance().readKeyFromFile(privateKeyFilePath);
            }
            catch (GeneralSecurityException e) {
                throw new ServerException(e);
            }
            catch (IOException e) {
                throw new ServerException(e);
            }
            catch (CryptographyException e) {
                throw new ServerException(e);
            }
            Properties props = (Properties)this.busInfo.getOrbProperties().clone();
            if (!this.isPropertyNull("ORB.port")) {
                int port = this.getIntProperty("ORB.port");
                String portStr = Integer.toString(port);
                props.setProperty("OAPort", portStr);
                String fmt = "Porta para o ORB: %s";
                String message = String.format("Porta para o ORB: %s", portStr);
                Server.logInfoMessage(message);
            }
            if (!this.isPropertyNull("ORB.hostAddr")) {
                String addr = this.getStringProperty("ORB.hostAddr");
                props.setProperty("OAIAddr", addr);
                String fmt = "IP para o ORB: %s";
                String message = String.format("IP para o ORB: %s", addr);
                Server.logInfoMessage(message);
            }
            props.setProperty("jacorb.connection.client.disconnect_after_systemexception", "false");
            this.orbThread = new ORBThread(ORBInitializer.initORB(null, (Properties)props));
            this.orbThread.start();
            try {
                this.context = (OpenBusContext)this.orbThread.orb.resolve_initial_references("OpenBusContext");
            }
            catch (InvalidName e) {
                throw new ServerException("Falha ao obter o OpenBusContext.");
            }
            this.connectionProps = new Properties();
            this.connectionProps.put("legacy.disable", "false");
            this.connectionProps.put("legacy.delegate", "originator");
            Connection conn = null;
            try {
                conn = this.context.createConnection(this.busInfo.getHost(), this.busInfo.getPort(), this.connectionProps);
            }
            catch (InvalidPropertyValue e) {
                throw new ServerException(e);
            }
            this.context.setDefaultConnection(conn);
            conn.onInvalidLoginCallback((InvalidLoginCallback)new OnInvalidLogin());
            String openBusMessage = String.format("Par\u00e2metros de conex\u00e3o com o Openbus:\n1 - Endere\u00e7o: %s.\n2 - Porta: %s\n3 - Nome da entidade: %s\n4 - Chave privada: %s", this.busInfo.getHost(), this.busInfo.getPort(), this.entityName, privateKeyFilePath);
            Server.logInfoMessage(openBusMessage);
        }
    }

    public ORB getORB() {
        return this.orbThread.orb;
    }

    public POA getRootPOA() throws OperationFailureException {
        try {
            POA poa = POAHelper.narrow((Object)this.getORB().resolve_initial_references("RootPOA"));
            if (!poa.the_POAManager().get_state().equals(State.ACTIVE)) {
                poa.the_POAManager().activate();
            }
            return poa;
        }
        catch (InvalidName e) {
            String msg = "Erro ao obter o POA.";
            Server.logSevereMessage(msg);
            throw new OperationFailureException(msg);
        }
        catch (AdapterInactive e) {
            String msg = "Erro ao obter o POA.";
            Server.logSevereMessage(msg);
            throw new OperationFailureException(msg);
        }
    }

    public void joinChain() {
        this.context.joinChain();
    }

    public void joinChain(byte[] chain) throws OperationFailureException {
        try {
            CallerChain callerChain = this.context.decodeChain(chain);
            this.context.joinChain(callerChain);
        }
        catch (InvalidEncodedStream e) {
            String msg = "Erro ao unir-se \u00e0 cadeia de chamadas.";
            Server.logSevereMessage(msg, e);
            throw new OperationFailureException(msg);
        }
    }

    public void exitChain() {
        this.context.exitChain();
    }

    private void configureOpenbusLogger() {
        Logger thisLogger = Logger.getLogger(((java.lang.Object)((java.lang.Object)this)).getClass().getName());
        Logger SDKLogger = Logger.getLogger("tecgraf.openbus");
        SDKLogger.setParent(thisLogger);
        SDKLogger.setUseParentHandlers(true);
        SDKLogger.setLevel(Level.parse(this.getStringProperty("log.level")));
        Logger jacorbLogger = Logger.getLogger("jacorb");
        SDKLogger.setParent(thisLogger);
        SDKLogger.setUseParentHandlers(true);
        jacorbLogger.setLevel(Level.parse(this.getStringProperty("log.level")));
    }

    public static OpenBusService getInstance() {
        return instance;
    }

    public static void createService() throws ServerException {
        instance = new OpenBusService();
    }

    @Override
    public void initService() {
        this.initComponents();
        final Connection conn = this.context.getDefaultConnection();
        Thread t = new Thread(){

            @Override
            public void run() {
                conn.onInvalidLoginCallback().invalidLogin(conn, null);
            }
        };
        t.start();
    }

    private List<OpenBusServiceOffer> getFacetOffers(String componentName, List<String> facetsFactories) {
        ArrayList<OpenBusServiceOffer> facetOffers = new ArrayList<OpenBusServiceOffer>();
        for (int i = 0; i < facetsFactories.size(); ++i) {
            String facetFactoryClass = facetsFactories.get(i);
            try {
                Class<?> facetsFactory = Class.forName(facetFactoryClass);
                OpenBusServiceOffer factory = (OpenBusServiceOffer)OpenBusServiceOffer.class.cast(facetsFactory.newInstance());
                facetOffers.add(factory);
                continue;
            }
            catch (ClassNotFoundException e) {
                Server.logSevereMessage("N\u00e3o existe uma classe para cria\u00e7\u00e3o das facetas do componente " + componentName, e);
                continue;
            }
            catch (ClassCastException e) {
                Server.logSevereMessage("Classe configurada para o componente " + componentName + " n\u00e3o implementa a interface " + OpenBusServiceOffer.class.getName(), e);
                continue;
            }
            catch (InstantiationException e) {
                Server.logSevereMessage("Erro na cria\u00e7\u00e3o do objeto que cria as facetas do componente " + componentName, e);
                continue;
            }
            catch (IllegalAccessException e) {
                Server.logSevereMessage("Acesso ilegal a classe que cria as facetas do componente " + componentName, e);
            }
        }
        return facetOffers;
    }

    private void initComponents() {
        List<String> componentsNames = this.getStringListProperty("component.name");
        List<String> componentsVersions = this.getStringListProperty("component.version");
        for (int i = 0; i < componentsNames.size(); ++i) {
            String componentName = componentsNames.get(i);
            String componentVersion = componentsVersions.get(i);
            if (componentVersion == null) {
                Server.logWarningMessage("O componente " + componentName + " n\u00e3o foi adicionado na lista para registro porque n\u00e3o possui uma vers\u00e3o configurada.");
                continue;
            }
            ComponentId componentId = this.makeComponentId(componentName, componentVersion);
            List<OpenBusServiceOffer> factories = this.getFacetOffers(componentName, this.getStringListProperty("component." + (i + 1) + ".facets"));
            if (factories.size() == 0) {
                Server.logWarningMessage("N\u00e3o existem facetas configuradas para o componente " + componentName);
                continue;
            }
            ArrayList<String> facetList = new ArrayList<String>();
            HashMap<String, ServiceProperty> propertyMap = new HashMap<String, ServiceProperty>();
            for (OpenBusServiceOffer factory : factories) {
                for (OpenBusServiceFacet facet : factory.getFacets()) {
                    if (this.facets.containsKey(facet.interfaceName)) {
                        Server.logWarningMessage("A faceta  " + facet.interfaceName + " est\u00e1 configurada para ser publicada mais de uma vez.");
                    }
                    this.facets.put(facet.interfaceName, facet);
                    facetList.add(facet.interfaceName);
                }
                factory.registerFactories();
                Properties props = factory.getProperties();
                if (props == null || props.isEmpty()) continue;
                for (java.lang.Object key : props.keySet()) {
                    if (propertyMap.containsKey(key)) continue;
                    propertyMap.put((String)key, new ServiceProperty((String)key, (String)props.get(key)));
                }
            }
            List<String> propNames = this.getStringListProperty("component." + (i + 1) + ".property.name");
            int sizePropNames = propNames.size();
            if (sizePropNames > 0) {
                List<String> propValues = this.getStringListProperty("component." + (i + 1) + ".property.value");
                int sizePropValues = propValues.size();
                if (sizePropNames != sizePropValues) {
                    Server.logSevereMessage("Quantidade de nomes de propriedades e de valores de propriedades do compomente " + componentName + " n\u00e3o correspondem.");
                    continue;
                }
                for (int j = 0; j < propNames.size(); ++j) {
                    String name = propNames.get(j);
                    String value = propValues.get(j);
                    ServiceProperty property = new ServiceProperty(name, value);
                    if (propertyMap.containsKey(property.name)) continue;
                    propertyMap.put(property.name, property);
                }
            }
            this.components.add(new ComponentEntry(componentId, facetList, propertyMap.size() == 0 ? new ServiceProperty[]{} : propertyMap.values().toArray(new ServiceProperty[0])));
        }
    }

    private ComponentId makeComponentId(String componentName, String componentVersion) {
        String[] tmp = componentVersion.split("[\\.]");
        byte major = Byte.parseByte(tmp[0]);
        byte minor = tmp.length >= 2 ? Byte.parseByte(tmp[1]) : (byte)0;
        byte patch = tmp.length >= 3 ? Byte.parseByte(tmp[2]) : (byte)0;
        return new ComponentId(componentName, major, minor, patch, "Java");
    }

    private IComponent makeComponent(ComponentId componentId, List<String> facetList) throws OperationFailureException {
        try {
            ORB orb = this.getORB();
            POA poa = this.getRootPOA();
            ComponentContext context = new ComponentContext(orb, poa, componentId);
            for (String facetId : facetList) {
                OpenBusServiceFacet facet = this.facets.get(facetId);
                if (facet == null) {
                    throw new OperationFailureException("O componente {0} n\u00e3o adicionou a faceta {1} porque essa faceta n\u00e3o foi instanciada.", new java.lang.Object[]{componentId.name, facetId});
                }
                if (facet.context == null) {
                    context.addFacet(facet.name, facet.interfaceName, facet.servant);
                    facet.setComponentContext(context);
                    continue;
                }
                Server.logWarningMessage(MessageFormat.format("O componente {0} n\u00e3o adicionou a faceta {1} porque essa faceta j\u00e1 est\u00e1 publicada no componente {2}.", this.getComponentIdAsString(componentId), facetId, this.getComponentIdAsString(context.getComponentId())));
            }
            return context.getIComponent();
        }
        catch (SCSException e) {
            Server.logSevereMessage("Erro na cria\u00e7\u00e3o do componente SCS", e);
            throw new OperationFailureException("Erro na cria\u00e7\u00e3o do componente {0}", new java.lang.Object[]{componentId.name});
        }
    }

    public IComponent findService(Properties properties) throws OperationFailureException {
        IComponent[] services = this.findServiceListByFilter(properties, FIND.FIRST);
        if (services.length > 0) {
            return services[0];
        }
        return null;
    }

    public IComponent[] findServiceList(Properties properties) throws OperationFailureException {
        return this.findServiceListByFilter(properties, FIND.ALL);
    }

    private IComponent[] findServiceListByFilter(Properties properties, FIND filter) throws OperationFailureException {
        ServiceOfferDesc[] services;
        ServiceProperty[] serviceProps = new ServiceProperty[properties.size()];
        int i = 0;
        for (String key : properties.stringPropertyNames()) {
            serviceProps[i] = new ServiceProperty(key, properties.getProperty(key));
            ++i;
        }
        try {
            services = this.context.getOfferRegistry().findServices(serviceProps);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha ao buscar servi\u00e7os com as seguintes propriedades: \n" + properties.toString(), e);
            throw new OperationFailureException("Falha na busca de servi\u00e7os.", (Throwable)e);
        }
        ArrayList<IComponent> components = new ArrayList<IComponent>();
        for (int j = 0; j < services.length; ++j) {
            String offerId = "";
            for (ServiceProperty prop : services[j].properties) {
                if (!prop.name.equals(OPENBUS_OFFER_ID_KEY)) continue;
                offerId = prop.value;
                break;
            }
            try {
                IComponent service = services[j].service_ref;
                if (service._non_existent()) continue;
                components.add(service);
                if (!filter.equals((java.lang.Object)FIND.FIRST)) continue;
                break;
            }
            catch (TRANSIENT e) {
                Server.logWarningMessage("Oferta de servi\u00e7o encontrada (" + offerId + ") mas servi\u00e7o est\u00e1 inalcan\u00e7\u00e1vel.");
                continue;
            }
            catch (COMM_FAILURE e) {
                Server.logWarningMessage("Oferta de servi\u00e7o encontrada (" + offerId + ") mas houve falha na comunica\u00e7\u00e3o com servi\u00e7o encontrado.");
                continue;
            }
            catch (Exception e) {
                Server.logSevereMessage("Oferta de servi\u00e7o encontrada (" + offerId + ") mas houve falha ao testar a comunica\u00e7\u00e3o.", e);
            }
        }
        return components.toArray(new IComponent[components.size()]);
    }

    public IComponent findServiceById(String id) throws OperationFailureException {
        Properties props = new Properties();
        props.put(OPENBUS_OFFER_ID_KEY, id);
        return this.findService(props);
    }

    public String getRequesterUserId() {
        String entity;
        CallerChain chain = this.context.getCallerChain();
        if (chain == null) {
            return null;
        }
        if (chain.originators().length == 0) {
            if (chain.caller().entity.equals(User.getAdminId())) {
                throw new ServiceFailureException("N\u00e3o \u00e9 permitido na credencial delegar para um usu\u00e1rio 'admin'.");
            }
            entity = chain.caller().entity;
        } else {
            entity = chain.originators()[0].entity;
        }
        try {
            return User.getUserByLogin((String)entity).getLogin();
        }
        catch (Exception e) {
            throw new ServiceFailureException("N\u00e3o foi poss\u00edvel obter o identificador do usu\u00e1rio '" + entity + "'.");
        }
    }

    public String getRequesterSystemId() {
        CallerChain chain = this.context.getCallerChain();
        if (chain == null) {
            return null;
        }
        return chain.caller().entity;
    }

    public String initCSBaseAccess() {
        String userId = this.getRequesterUserId();
        String systemId = this.getRequesterSystemId();
        Service.setUserId(new ExternalUser(userId, ExternalUser.ExternalAuthMechanism.OPENBUS));
        Service.setSystemId(systemId);
        return userId;
    }

    public void finishCSBaseAccess() {
        Service.setUserId(null);
        Service.setSystemId(null);
    }

    private String getComponentIdAsString(ComponentId componentId) {
        StringBuffer stringComponentId = new StringBuffer(componentId.name);
        stringComponentId.append(':');
        stringComponentId.append(componentId.major_version);
        stringComponentId.append(".");
        stringComponentId.append(componentId.minor_version);
        stringComponentId.append(".");
        stringComponentId.append(componentId.patch_version);
        return stringComponentId.toString();
    }

    private void acsInitFailed(boolean failed) {
        this.acsInitFailed = failed;
    }

    @Override
    public void shutdownService() {
        this.unregisterComponents();
        try {
            this.context.getDefaultConnection().logout();
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro no barramento.", e);
        }
    }

    @Override
    public boolean isActive() {
        if (!super.isActive()) {
            Server.logFineMessage("OpenbusService n\u00e3o est\u00e1 ativo porque a propriedade enabled do servi\u00e7o est\u00e1 false.");
        } else if (this.acsInitFailed) {
            Server.logFineMessage("OpenbusService n\u00e3o est\u00e1 ativo porque a flag acsInitFailed est\u00e1 true.");
        }
        return super.isActive() && !this.acsInitFailed;
    }

    private boolean unregisterComponents() {
        boolean status = true;
        for (ComponentEntry entry : this.components) {
            try {
                if (entry.serviceOffer == null) continue;
                entry.serviceOffer.remove();
                Server.logInfoMessage("O componente " + entry.component.getComponentId().name + " teve sua oferta " + entry.offerId + " removida do barramento.");
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro ao remover a oferta " + entry.offerId, e);
                status = false;
            }
        }
        return status;
    }

    protected boolean has2Update(java.lang.Object arg, java.lang.Object event) {
        return false;
    }

    public void addFacet(String name, String interfaceName, Servant servant) {
        this.facets.put(interfaceName, new OpenBusServiceFacet(name, interfaceName, servant));
    }

    public BusInfo getBusInfo() {
        LoginInfo loginInfo = this.context.getCurrentConnection().login();
        if (loginInfo != null) {
            this.busInfo.setLoginId(loginInfo.id);
        }
        return this.busInfo;
    }

    public OpenbusStatus getOpenbusStatus() {
        return openbusStatus;
    }

    public boolean isConnected() {
        Connection conn = this.context.getDefaultConnection();
        if (conn == null) {
            return false;
        }
        return conn.login() != null;
    }

    public boolean isRegistryServerActive() {
        try {
            return !this.context.getOfferRegistry()._non_existent();
        }
        catch (TRANSIENT e) {
            return false;
        }
    }

    public String getEntityName() {
        return this.getStringProperty("entity.name");
    }

    public String getPrivateKeyFilePath() {
        return this.getStringProperty("private.key.file");
    }

    public Set<ComponentId> getRegisteredComponents() {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        try {
            HashSet<ComponentId> result = new HashSet<ComponentId>();
            for (ComponentEntry entry : this.components) {
                result.add(entry.componentId);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getRegisteredComponentFacets(ComponentId id) {
        for (ComponentEntry component : this.components) {
            if (!this.compareComponentId(component.componentId, id)) continue;
            return component.facets.toArray(new String[0]);
        }
        return null;
    }

    public Properties getRegisteredComponentProperties(ComponentId id) {
        Properties props = new Properties();
        for (ComponentEntry component : this.components) {
            if (!this.compareComponentId(component.componentId, id)) continue;
            for (ServiceProperty servProp : component.properties) {
                props.put(servProp.name, servProp.value);
            }
            return props;
        }
        return null;
    }

    public String getRegisteredComponentBusId(ComponentId id) {
        for (ComponentEntry component : this.components) {
            if (!this.compareComponentId(component.componentId, id)) continue;
            return component.offerId;
        }
        return null;
    }

    public Set<ComponentId> getFailedComponents() {
        try {
            HashSet<ComponentId> result = new HashSet<ComponentId>();
            for (ComponentEntry component : this.failedComponents) {
                result.add(component.componentId);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean compareComponentId(ComponentId id1, ComponentId id2) {
        return id1.major_version == id2.major_version && id1.minor_version == id2.minor_version && id1.name == id2.name && id1.patch_version == id2.patch_version && id1.platform_spec == id2.platform_spec;
    }

    public OpenBusLoginToken doTokenLogin(final OpenBusLoginToken token) {
        SharedAuthSecret newSecret;
        Connection tokenConn;
        Properties props = new Properties();
        props.put("legacy.disable", "false");
        props.put("legacy.delegate", "originator");
        try {
            tokenConn = this.context.createConnection(this.busInfo.getHost(), this.busInfo.getPort(), props);
        }
        catch (InvalidPropertyValue e) {
            Server.logSevereMessage("Erro ao criar OpenBusToken: falha na cria\u00e7\u00e3o de conex\u00e3o com o barramento.", e);
            return null;
        }
        try {
            SharedAuthSecret oldSecret = this.context.decodeSharedAuth(token.secret);
            tokenConn.loginBySharedAuth(oldSecret);
        }
        catch (InvalidEncodedStream e) {
            Server.logSevereMessage("Erro ao criar OpenBusToken: falha na decodifica\u00e7\u00e3o do segredo.", e);
            return null;
        }
        catch (AlreadyLoggedIn e) {
        }
        catch (InvalidLoginProcess e) {
            Server.logSevereMessage("Erro ao criar OpenBusToken: falha na autentica\u00e7\u00e3o de conex\u00e3o com o barramento.", e);
            return null;
        }
        catch (AccessDenied e) {
            Server.logSevereMessage("Erro ao criar OpenBusToken: falha na autentica\u00e7\u00e3o de conex\u00e3o com o barramento.", e);
            return null;
        }
        catch (ServiceFailure e) {
            Server.logSevereMessage("Erro ao criar OpenBusToken: falha na autentica\u00e7\u00e3o de conex\u00e3o com o barramento.", e);
            return null;
        }
        if (tokenConn.login() == null) {
            return null;
        }
        try {
            newSecret = tokenConn.startSharedAuth();
        }
        catch (ServiceFailure e) {
            Server.logSevereMessage("Erro ao criar OpenBusToken: falha na cria\u00e7\u00e3o da conex\u00e3o compartilhada.", e);
            return null;
        }
        Thread closeConnTask = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(180000L);
                    tokenConn.logout();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ServiceFailure e) {
                    Server.logSevereMessage("Falha ao fechar a conex\u00e3o usada para autentica\u00e7\u00e3o compartilhada do usu\u00e1rio " + token.user + ".", e);
                }
            }
        };
        closeConnTask.start();
        return new OpenBusLoginToken(token.user, this.context.encodeSharedAuth(newSecret));
    }

    public ComponentContext getComponentContext(String facetId) {
        return this.facets.get((java.lang.Object)facetId).context;
    }

    private boolean logOnce(String msg) {
        if (this.lastLogMessage == null || !this.lastLogMessage.equals(msg)) {
            if (this.numLastLogMessage > 1) {
                Server.logWarningMessage("A mensagem '" + this.lastLogMessage + "' foi repetida " + this.numLastLogMessage + " vezes");
            }
            this.lastLogMessage = msg;
            this.numLastLogMessage = 1;
            Server.logSevereMessage(msg);
            return true;
        }
        ++this.numLastLogMessage;
        return false;
    }

    private static class ORBThread
    extends Thread {
        private final ORB orb;

        ORBThread(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            this.orb.run();
        }
    }

    private class ComponentEntry {
        ComponentId componentId;
        List<String> facets;
        IComponent component;
        ServiceProperty[] properties;
        ServiceOffer serviceOffer;
        String offerId;
        ReloginTask offerRegisterTask;

        ComponentEntry(ComponentId id, List<String> facetList, ServiceProperty[] props) {
            this.componentId = id;
            this.facets = facetList;
            this.properties = props;
            this.offerRegisterTask = new ReloginTask(OpenBusService.this.context.getDefaultConnection(), new ReloginAllocator(){

                @Override
                public String reallocate(LoginInfo login) throws Exception {
                    OfferRegistry offerRegistry = OpenBusService.this.context.getOfferRegistry();
                    try {
                        ComponentEntry.this.component = OpenBusService.this.makeComponent(ComponentEntry.this.componentId, ComponentEntry.this.facets);
                    }
                    catch (OperationFailureException e) {
                        String log = MessageFormat.format("Erro ao criar o componente SCS {0}:{1}.{2}.{3}.", OpenBusService.this.entityName, ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version);
                        Server.logSevereMessage(log, e);
                    }
                    String loginId = null;
                    do {
                        String log;
                        ServiceOffer offer = null;
                        try {
                            offer = offerRegistry.registerService(ComponentEntry.this.component, ComponentEntry.this.properties);
                            ComponentEntry.this.setServiceOffer(offer);
                        }
                        catch (UnauthorizedFacets e) {
                            StringBuffer facetNames = new StringBuffer();
                            for (int i = 0; i < e.facets.length; ++i) {
                                if (i > 0) {
                                    facetNames.append(", ");
                                }
                                facetNames.append(e.facets[i]);
                            }
                            String log2 = MessageFormat.format("A entidade {0} n\u00e3o possui permiss\u00e3o para publicar as seguintes facetas do componente {1}:{2}.{3}.{4}: {5}", OpenBusService.this.entityName, ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version, facetNames.toString());
                            Server.logSevereMessage(log2, e);
                        }
                        catch (InvalidService e) {
                            log = MessageFormat.format("O componente {0}:{1}.{2}.{3} \u00e9 inv\u00e1lido e n\u00e3o ser\u00e1 publicado no barramento.", ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version);
                            Server.logSevereMessage(log, e);
                            OpenBusService.this.components.remove(ComponentEntry.this.getEntry());
                        }
                        catch (InvalidProperties e) {
                            log = MessageFormat.format("O componente {0}:{1}.{2}.{3} contem propriedades inv\u00e1lidas e n\u00e3o ser\u00e1 publicado no barramento.", ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version);
                            Server.logSevereMessage(log, e);
                            OpenBusService.this.components.remove(ComponentEntry.this.getEntry());
                        }
                        catch (ServiceFailure e) {
                            log = MessageFormat.format("Erro ao registrar o componente {0}:{1}.{2}.{3}.", OpenBusService.this.entityName, ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version);
                            Server.logSevereMessage(log, e);
                        }
                        catch (TRANSIENT e) {
                            log = MessageFormat.format("Erro ao publicar o componente SCS {0}:{1}.{2}.{3}.", OpenBusService.this.entityName, ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version);
                            Server.logSevereMessage(log, e);
                        }
                        catch (COMM_FAILURE e) {
                            log = MessageFormat.format("Erro ao publicar o componente SCS {0}:{1}.{2}.{3}.", OpenBusService.this.entityName, ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version);
                            Server.logSevereMessage(log, e);
                        }
                        catch (NO_PERMISSION e) {
                            log = MessageFormat.format("Erro ao publicar o componente SCS {0}:{1}.{2}.{3}.", OpenBusService.this.entityName, ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version);
                            Server.logSevereMessage(log, e);
                        }
                        catch (Throwable e) {
                            log = MessageFormat.format("Erro ao publicar o componente SCS {0}:{1}.{2}.{3}.", OpenBusService.this.entityName, ComponentEntry.this.componentId.name, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.major_version, ComponentEntry.this.componentId.patch_version);
                            Server.logSevereMessage(log, e);
                        }
                        try {
                            ServiceOfferDesc desc = offer.describe();
                            for (ServiceProperty prop : desc.properties) {
                                if (!prop.name.equals("openbus.offer.login")) continue;
                                loginId = prop.value;
                            }
                        }
                        catch (OBJECT_NOT_EXIST e) {
                            System.err.println("offer was removed");
                        }
                    } while (loginId == null);
                    Server.logInfoMessage("O componente " + ComponentEntry.this.componentId.name + " foi registrado com sucesso no Openbus e sua oferta tem o identificador " + ComponentEntry.this.offerId);
                    return loginId;
                }
            });
        }

        void setServiceOffer(ServiceOffer serviceOffer) {
            this.serviceOffer = serviceOffer;
            String id = "";
            for (ServiceProperty prop : serviceOffer.properties()) {
                if (!prop.name.equals(OpenBusService.OPENBUS_OFFER_ID_KEY)) continue;
                id = prop.value;
            }
            this.offerId = id;
        }

        ComponentEntry getEntry() {
            return this;
        }

        public void notifyRelogin() {
            this.offerRegisterTask.notifyRelogin();
        }
    }

    class OnInvalidLogin
    implements InvalidLoginCallback {
        OnInvalidLogin() {
        }

        public void invalidLogin(Connection conn, LoginInfo loginInfo) {
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                try {
                    conn.loginByCertificate(OpenBusService.this.entityName, OpenBusService.this.privateKey);
                    openbusStatus = new OpenbusStatus(OpenbusStatus.ConnectionState.CONNECTED, new Date());
                    break;
                }
                catch (AlreadyLoggedIn e) {
                    break;
                }
                catch (SystemException e) {
                    OpenBusService.this.logOnce("Erro inesperado ao acessar o barramento para realizar o login." + (java.lang.Object)((java.lang.Object)e));
                    OpenBusService.this.acsInitFailed(true);
                    openbusStatus = new OpenbusStatus(OpenbusStatus.ConnectionState.ACS_UNAVAILABLE, (Exception)((java.lang.Object)e), new Date());
                    try {
                        Thread.sleep(i * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                catch (Exception e) {
                    OpenBusService.this.logOnce("Erro ao fazer o login no barramento." + e);
                    OpenBusService.this.acsInitFailed(true);
                    openbusStatus = new OpenbusStatus(OpenbusStatus.ConnectionState.ACS_LOGIN_FAILURE, e, new Date());
                    break;
                }
            }
            OpenBusService.this.acsInitFailed(false);
            for (OpenBusServiceFacet facet : OpenBusService.this.facets.values()) {
                facet.setComponentContext(null);
            }
            for (ComponentEntry entry : OpenBusService.this.components) {
                entry.notifyRelogin();
            }
        }
    }

    private static enum FIND {
        ALL,
        FIRST;

    }
}

