/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_9;

import csbase.exception.PermissionException;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.opendreams.v1_9.JobInfoQueue;
import csbase.server.services.opendreamsservice.opendreams.v1_9.SessionManager;
import csbase.server.services.projectservice.ProjectService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import tecgraf.openbus.DRMAA.v1_9.AuthorizationException;
import tecgraf.openbus.DRMAA.v1_9.InternalException;
import tecgraf.openbus.DRMAA.v1_9.InvalidJobException;
import tecgraf.openbus.DRMAA.v1_9.JobInfo;
import tecgraf.openbus.DRMAA.v1_9.JobState;
import tecgraf.openbus.DRMAA.v1_9.Session;
import tecgraf.openbus.DRMAA.v1_9.SessionHelper;
import tecgraf.openbus.opendreams.v1_9.FinalizationType;
import tecgraf.openbus.opendreams.v1_9.IOpenDreamsPOA;
import tecgraf.openbus.opendreams.v1_9.OpenDreamsJobInfoImpl;
import tecgraf.openbus.opendreams.v1_9.ProgressData;
import tecgraf.openbus.opendreams.v1_9.ProjectNotFoundException;

public class OpenDreams
extends IOpenDreamsPOA {
    private Session session;
    private SessionManager sessionManagement = new SessionManager();
    public static final String UNDEFINED = "indefinido";

    public Session getSession(String projectName) throws AuthorizationException, InternalException, ProjectNotFoundException {
        String userId = UNDEFINED;
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreams: getSession (" + projectName + ")");
            OpenDreams.checkUser(userId);
            OpenDreams.checkProject(projectName, userId);
            POA poa = OpenBusService.getInstance().getRootPOA();
            Object obj = poa.servant_to_reference((Servant)this.sessionManagement.getSession(userId, projectName));
            this.session = SessionHelper.narrow((Object)obj);
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de obter uma sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (ProjectNotFoundException e) {
            String msg = "Falha na tentativa de obter uma sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro ao obter a sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
        return this.session;
    }

    public Session getSessionByProjUserId(String projectName, String userName) throws AuthorizationException, InternalException, ProjectNotFoundException {
        String userId = UNDEFINED;
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreams: getSessionByProjUserId (" + projectName + ", " + userName + ")");
            OpenDreams.checkUser(userId);
            OpenDreams.checkProject(projectName, userName);
            OpenDreams.checkProjectPermission(projectName, userName);
            POA poa = OpenBusService.getInstance().getRootPOA();
            Object obj = poa.servant_to_reference((Servant)this.sessionManagement.getSession(userName, projectName));
            this.session = SessionHelper.narrow((Object)obj);
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de obter uma sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (ProjectNotFoundException e) {
            String msg = "Falha na tentativa de obter uma sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro ao obter a sess\u00e3o do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
        return this.session;
    }

    public static String formatMessage(Throwable e, String msg) {
        StringBuffer message = new StringBuffer(msg);
        message.append(": " + e.getClass().getName() + ": " + e.getMessage());
        message.append("\nCaused by:\n");
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            message.append(stackTrace[i].toString() + "\n");
        }
        return message.toString();
    }

    public static void checkUser(String userId) throws AuthorizationException {
        if (AdministrationService.getInstance().getUser(userId) == null) {
            throw new AuthorizationException("O usu\u00e1rio " + userId + " n\u00e3o existe.");
        }
    }

    public static void checkProject(String projectName, String userId) throws ProjectNotFoundException {
        java.lang.Object projectId;
        if (AdministrationService.getInstance().getUser(userId) == null) {
            throw new ProjectNotFoundException("N\u00e3o existe um usu\u00e1rio com identificador " + userId);
        }
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsProject(projectId = projectService.getProjectId(userId, projectName))) {
            throw new ProjectNotFoundException("O usu\u00e1rio " + userId + " n\u00e3o possui um projeto com nome " + projectName);
        }
    }

    public static void checkProjectPermission(String projectName, String userId) throws AuthorizationException {
        ProjectService projectService = ProjectService.getInstance();
        java.lang.Object projectId = projectService.getProjectId(userId, projectName);
        try {
            projectService.checkWritePermission(projectId);
        }
        catch (PermissionException e) {
            throw new AuthorizationException("O usu\u00e1rio " + Service.getUser().getId() + " n\u00e3o possui acesso de escrita no projeto " + projectName + " do usu\u00e1rio " + userId);
        }
    }

    public static void logWarningException(String msg, UserException exception) {
        try {
            Field messageField = exception.getClass().getField("message");
            Server.logWarningMessage(msg + ": " + messageField.get(exception));
        }
        catch (Exception e) {
            Server.logSevereMessage(msg, e);
        }
    }

    public JobInfo[] allJobsByProject(String projectName, String userName) throws InternalException, ProjectNotFoundException, AuthorizationException {
        String userId = UNDEFINED;
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreams: getSessionByProjUserId (" + projectName + ", " + userName + ")");
            OpenDreams.checkUser(userId);
            OpenDreams.checkProject(projectName, userName);
            ProjectService projectService = ProjectService.getInstance();
            java.lang.Object projectId = projectService.getProjectId(userName, projectName);
            Set<CommandInfo> commandInfos = CommandPersistenceService.getInstance().getCommandInfos(projectId);
            ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
            for (CommandInfo commandInfo : commandInfos) {
                jobInfos.add(this.getJobInfoByCommandInfo(commandInfo.getId(), commandInfo));
            }
            return jobInfos.toArray(new JobInfo[0]);
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de obter os jobs do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (ProjectNotFoundException e) {
            String msg = "Falha na tentativa de obter o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro ao obter os jobs do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
    }

    public JobInfo getJobInfoByJobId(String projectName, String userName, String jobId) throws InvalidJobException, InternalException, AuthorizationException, ProjectNotFoundException {
        String userId = UNDEFINED;
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            Server.logFineMessage("OpenDreams: getSessionByProjUserId (" + projectName + ", " + userName + ")");
            OpenDreams.checkUser(userId);
            OpenDreams.checkProject(projectName, userName);
            ProjectService projectService = ProjectService.getInstance();
            java.lang.Object projectId = projectService.getProjectId(userName, projectName);
            CommandInfo commandInfo = CommandPersistenceService.getInstance().getCommandInfo(projectId, jobId);
            if (commandInfo == null) {
                throw new InvalidJobException("N\u00e3o foi encontrado um job com o nome: " + jobId);
            }
            return this.getJobInfoByCommandInfo(jobId, commandInfo);
        }
        catch (AuthorizationException e) {
            String msg = "Falha na tentativa de obter o job " + jobId + " do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (ProjectNotFoundException e) {
            String msg = "Falha na tentativa de obter o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidJobException e) {
            String msg = "Falha na tentativa de obter o job " + jobId + " do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro ao obter o job " + jobId + " do usu\u00e1rio " + userId + " para o projeto " + projectName + " do usu\u00e1rio " + userName;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
    }

    private JobInfo getJobInfoByCommandInfo(String jobId, CommandInfo commandInfo) {
        OpenDreamsJobInfoImpl jobInfo = new OpenDreamsJobInfoImpl();
        jobInfo.jobId = jobId;
        jobInfo.hasExited = false;
        jobInfo.wasAborted = false;
        jobInfo.finalizationType = FinalizationType.UNKNOWN;
        CommandStatus status = commandInfo.getStatus();
        if (status == CommandStatus.SCHEDULED) {
            jobInfo.status = JobState.QUEUED_ACTIVE;
        }
        if (status == CommandStatus.INIT || status == CommandStatus.UPLOADING || status == CommandStatus.EXECUTING || status == CommandStatus.DOWNLOADING) {
            jobInfo.status = JobState.RUNNING;
        }
        if (status == CommandStatus.FINISHED) {
            CommandFinalizationType finnalizationType = commandInfo.getFinalizationType();
            if (finnalizationType == CommandFinalizationType.UNKNOWN || finnalizationType == CommandFinalizationType.END || finnalizationType == CommandFinalizationType.SUCCESS) {
                jobInfo.status = JobState.DONE;
                jobInfo.hasExited = true;
            } else if (finnalizationType == CommandFinalizationType.EXECUTION_ERROR || finnalizationType == CommandFinalizationType.FAILED || finnalizationType == CommandFinalizationType.KILLED || finnalizationType == CommandFinalizationType.NO_EXIT_CODE) {
                jobInfo.status = JobState.FAILED;
                jobInfo.hasExited = true;
                if (finnalizationType == CommandFinalizationType.KILLED) {
                    jobInfo.wasAborted = true;
                }
            }
        }
        jobInfo.status = JobState.UNDETERMINED;
        if (jobInfo.hasExited) {
            CommandFinalizationInfo finalizationInfo;
            ArrayList<String[]> resourceUsage = new ArrayList<String[]>();
            if (commandInfo.getCpuTimeSec() != null) {
                resourceUsage.add(new String[]{"cpu_time", commandInfo.getCpuTimeSec().toString()});
            }
            if (commandInfo.getWallTimeSec() != null) {
                resourceUsage.add(new String[]{"elapsed_time", commandInfo.getWallTimeSec().toString()});
            }
            if (commandInfo.getUserTimeSec() != null) {
                resourceUsage.add(new String[]{"user_time", commandInfo.getUserTimeSec().toString()});
            }
            if ((finalizationInfo = commandInfo.getFinalizationInfo()) == null) {
                jobInfo.exitStatus = 256;
            } else {
                Integer exitCode;
                if (finalizationInfo.getInfoType() == CommandFinalizationInfo.FinalizationInfoType.EXTENDED && finalizationInfo instanceof ExtendedCommandFinalizationInfo) {
                    ExtendedCommandFinalizationInfo o = (ExtendedCommandFinalizationInfo)finalizationInfo;
                    jobInfo.guiltyNodeId = String.valueOf(o.getGuiltyNodeId());
                }
                jobInfo.exitStatus = (exitCode = finalizationInfo.getExitCode()) == null ? 256 : exitCode;
                jobInfo.finalizationType = JobInfoQueue.getFinalizationType(finalizationInfo.getFinalizationType(), finalizationInfo.getFailureCause());
                String string = jobInfo.description = finalizationInfo.getFailureCause() == null ? finalizationInfo.getFinalizationType().getDescription() : finalizationInfo.getFailureCause().getDescription();
            }
            if (resourceUsage.size() > 0) {
                jobInfo.resourceUsage = (String[][])resourceUsage.toArray((T[])new String[resourceUsage.size()][]);
            }
            jobInfo.exitStatus = finalizationInfo != null ? finalizationInfo.getExitCode() : 256;
            jobInfo.hasSignaled = false;
            jobInfo.terminatingSignal = "";
            jobInfo.hasCoreDump = false;
        }
        jobInfo.progressData = new ProgressData();
        return jobInfo;
    }
}

