/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.servermonitor.v1_0;

import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.sgaservice.SGAService;
import java.io.File;
import java.util.Vector;
import sgaidl.Pair;
import sgaidl.SGAProperties;
import tecgraf.openbus.servermonitor.v1_0.AuthorizationException;
import tecgraf.openbus.servermonitor.v1_0.IServerMonitorPOA;
import tecgraf.openbus.servermonitor.v1_0.InternalException;
import tecgraf.openbus.servermonitor.v1_0.ServerProperties;

public class ServerMonitor
extends IServerMonitorPOA {
    public SGAProperties[] getSGAProperties(String[] names) throws AuthorizationException, InternalException {
        SGAService sgaService = SGAService.getInstance();
        if (names.length == 0) {
            Vector<String> allSGANames = sgaService.getAllSGANames();
            names = new String[allSGANames.size()];
            names = allSGANames.toArray(new String[allSGANames.size()]);
        }
        SGAProperties[] sgaProperties = new SGAProperties[names.length];
        for (int k = 0; k < names.length; ++k) {
            String sgaName = names[k];
            SGASet sga = sgaService.getSGASet(sgaName);
            sgaProperties[k] = new SGAProperties();
            String[] sgaKeys = sga.getPropertiesKeys();
            sgaProperties[k].properties = new Pair[sgaKeys.length];
            for (int i = 0; i < sgaKeys.length; ++i) {
                String key = sgaKeys[i];
                sgaProperties[k].properties[i] = new Pair();
                sgaProperties[k].properties[i].key = key;
                String value = sga.getProperty(key);
                sgaProperties[k].properties[i].value = value == null ? "" : value;
                System.out.println(sgaProperties[k].properties[i].key + "=" + sgaProperties[k].properties[i].value);
            }
            SGAInfo[] sgaNodeInfo = sgaService.getAllInfo(sgaName);
            sgaProperties[k].nodesProperties = new Pair[sgaNodeInfo.length][];
            if (sgaNodeInfo == null || sgaNodeInfo.length <= 0) continue;
            for (int i = 0; i < sgaNodeInfo.length; ++i) {
                String[] nodeKeys = sgaNodeInfo[i].getPropertiesKeys();
                sgaProperties[k].nodesProperties[i] = new Pair[nodeKeys.length];
                for (int j = 0; j < nodeKeys.length; ++j) {
                    String key = nodeKeys[j];
                    sgaProperties[k].nodesProperties[i][j] = new Pair();
                    sgaProperties[k].nodesProperties[i][j].key = key;
                    String value = sgaNodeInfo[i].getProperty(key);
                    sgaProperties[k].nodesProperties[i][j].value = value == null ? "" : value;
                }
            }
        }
        return sgaProperties;
    }

    public ServerProperties getServerProperties() throws AuthorizationException, InternalException {
        ServerProperties props = new ServerProperties();
        props.algorithm_root_dir = AlgorithmService.getInstance().getAlgorithmRepositoryPath();
        props.project_root_dir = ProjectService.getInstance().getProjectRepositoryPath();
        props.file_separator = File.separator;
        return props;
    }
}

