/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket.messenger;

import com.google.common.collect.EvictingQueue;
import csbase.logic.UserNotification;
import csbase.logic.UserOutline;
import csbase.server.Server;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.restservice.websocket.CSBaseWebSocket;
import csbase.server.services.restservice.websocket.CSBaseWebSocketApplication;
import csbase.server.services.restservice.websocket.Message;
import csbase.server.services.restservice.websocket.Project;
import csbase.server.services.restservice.websocket.User;
import csbase.server.services.restservice.websocket.utils.PersistentObject;
import csbase.server.services.restservice.websocket.utils.WebSocketUtils;
import java.io.Serializable;
import java.util.ArrayList;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.WebSocket;
import org.json.JSONArray;
import org.json.JSONObject;

public class CSBaseMessenger
extends CSBaseWebSocketApplication {
    private static final int MESSENGER_HISTORY_MAX_SIZE = 100;
    private static final String MESSENGER_FILE = "wsmessenger.dat";
    private PersistentObject<EvictingQueue<String>> messages = new PersistentObject<EvictingQueue>(WebSocketUtils.generatePath("wsmessenger.dat"), EvictingQueue.create((int)100));

    @Override
    public void onConnect(WebSocket ws) {
        super.onConnect(ws);
        if (ws instanceof CSBaseWebSocket) {
            this.broadcastUserListUpdateMessage();
            ws.send(this.createMessengerHistoryMessage().toString());
        }
    }

    @Override
    public void onMessage(WebSocket websocket, String json) {
        try {
            CSBaseWebSocket ws = (CSBaseWebSocket)websocket;
            Message incomingMessage = new Message(json);
            incomingMessage.setUser(ws.getUser());
            if (incomingMessage.isProjectChange().booleanValue()) {
                Object content = incomingMessage.getContent();
                Project project = content != null ? new Project((JSONObject)content) : null;
                ws.setProject(project);
                this.connections.compute(ws.getUser().getLogin(), (user, userWebSockets) -> {
                    userWebSockets.removeIf(userWebSocket -> userWebSocket.getId().equals(ws.getId()));
                    userWebSockets.add(ws);
                    return userWebSockets;
                });
                Message projectChange = this.createProjectChangeMessage(ws.getUser(), ws.getProject());
                this.connections.forEach((userLogin, csBaseWebSockets) -> {
                    if (ws.getProject() == null) {
                        this.broadcaster.broadcast((Iterable)csBaseWebSockets, projectChange.toString());
                    } else if (ws.getProject().isVisible((String)userLogin).booleanValue()) {
                        this.broadcaster.broadcast((Iterable)csBaseWebSockets, projectChange.toString());
                    }
                });
            } else if (incomingMessage.isChat().booleanValue()) {
                UserOutline[] loggedUsers;
                this.messages.get().add((Object)incomingMessage.toString());
                this.broadcast(incomingMessage);
                UserNotification userNotification = new UserNotification(ws.getUser().getLogin(), incomingMessage.getContent().toString(), false, false);
                csbase.util.messages.Message csbaseMessage = new csbase.util.messages.Message((Serializable)userNotification);
                for (UserOutline loggedUser : loggedUsers = LoginService.getInstance().getLoggedUsers()) {
                    MessageService.getInstance().send(csbaseMessage, loggedUser.getLogin());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Server.logSevereMessage("Error processing message " + json + " sent by " + (Object)((Object)((CSBaseWebSocket)websocket).getUser()), e);
        }
    }

    @Override
    public void onClose(WebSocket socket, DataFrame frame) {
        super.onClose(socket, frame);
        if (socket instanceof CSBaseWebSocket) {
            this.broadcastUserListUpdateMessage();
            this.messages.save();
        }
    }

    private void broadcast(Message message) {
        ArrayList targets = new ArrayList();
        this.connections.values().forEach(targets::addAll);
        this.broadcaster.broadcast(targets, message.toString());
    }

    public void broadcastUserListUpdateMessage() {
        String NO_PROJECT = "";
        this.connections.forEach((targetUser, targetUserWebSockets) -> {
            Message usersOnline = new Message();
            usersOnline.setType("ulupd");
            JSONObject projects = new JSONObject();
            this.connections.forEach((user, userWebSockets) -> {
                JSONObject usersProject;
                String currentProjectId;
                long openedAt = 0L;
                Project currentProject = null;
                User currentUser = null;
                for (CSBaseWebSocket ws : userWebSockets) {
                    currentUser = ws.getUser();
                    if (ws.getProject() == null || ws.getModifiedAt() <= openedAt) continue;
                    currentProject = ws.getProject();
                    openedAt = ws.getModifiedAt();
                }
                String string = currentProjectId = currentProject != null ? currentProject.getId() : "";
                if (projects.has(currentProjectId)) {
                    JSONObject currentProjectUsers = projects.getJSONObject(currentProjectId);
                    currentProjectUsers.put("users", (Object)currentProjectUsers.getJSONArray("users").put((Object)currentUser));
                    projects.put(currentProjectId, (Object)currentProjectUsers);
                } else if (currentProject == null || !currentProject.isVisible((String)targetUser).booleanValue()) {
                    usersProject = new JSONObject();
                    usersProject.put("users", (Object)new JSONArray().put((Object)currentUser));
                    usersProject.put("project", (Object)"");
                    projects.put(currentProjectId, (Object)usersProject);
                } else {
                    usersProject = new JSONObject();
                    usersProject.put("users", (Object)new JSONArray().put((Object)currentUser));
                    usersProject.put("project", (Object)currentProject);
                    projects.put(currentProjectId, (Object)usersProject);
                }
            });
            usersOnline.setContent(projects);
            this.broadcaster.broadcast((Iterable)targetUserWebSockets, usersOnline.toString());
        });
    }

    public Message createProjectChangeMessage(User user, Project project) {
        Message projectChange = new Message();
        projectChange.setType("prchg");
        projectChange.setUser(user);
        projectChange.setContent((Object)project);
        return projectChange;
    }

    private Message createMessengerHistoryMessage() {
        JSONArray jsonArray = new JSONArray();
        this.messages.get().forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        Message history = new Message();
        history.setType("chist");
        history.setContent(jsonArray);
        return history;
    }
}

