/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.exception.CSBaseException;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.logic.SingleServerManager;
import csbase.server.Server;
import csbase.server.keystore.CSKeyStore;
import java.rmi.RemoteException;
import java.util.Locale;

public class LocalServerRemoteMonitor
extends SingleServerManager {
    private static final Locale LOCALE = new Locale("pt", "br");
    private static LocalServerRemoteMonitor instance;

    public static final LocalServerRemoteMonitor getInstance() {
        return instance;
    }

    protected final void error(Throwable t) {
        t.printStackTrace();
        Server.logSevereMessage(t.getMessage());
    }

    protected String lang(String key) {
        return Server.getInstance().getString(key);
    }

    protected final Session login() throws CSBaseException {
        byte[] signedLocalServerName;
        String monitoredVersion;
        try {
            monitoredVersion = this.getServer().getVersionName();
        }
        catch (RemoteException e1) {
            Server.logSevereMessage("Erro ao buscar vers\u00e3o do servidor monitorado.");
            return null;
        }
        String serverVersion = Server.getInstance().getVersion();
        if (!monitoredVersion.equals(serverVersion)) {
            Server.logSevereMessage("Vers\u00e3o do monitor \u00e9 diferente da vers\u00e3o do servidor monitorado.");
            return null;
        }
        CSKeyStore keyStore = CSKeyStore.getInstance();
        if (keyStore == null) {
            Server.logSevereMessage("O reposit\u00f3rio de chaves n\u00e3o foi criado.");
            return null;
        }
        String localServerName = Server.getInstance().getSystemName();
        if (localServerName == null) {
            Server.logSevereMessage("O nome do servidor n\u00e3o foi informado.");
            return null;
        }
        String privateKeyPassword = Server.getInstance().getPrivateKeyPassword();
        if (privateKeyPassword == null) {
            Server.logSevereMessage("A senha da chave privada do servidor n\u00e3o foi informada.");
            return null;
        }
        try {
            signedLocalServerName = keyStore.sign(localServerName, privateKeyPassword, localServerName);
            if (signedLocalServerName == null) {
                Server.logSevereMessage("O servidor n\u00e3o possui chave gerada no reposit\u00f3rio de chaves/certificados.");
                return null;
            }
        }
        catch (CSBaseException e) {
            Server.logSevereMessage("Erro ao assinar o nome do servidor local.", e);
            throw e;
        }
        try {
            Session session = this.getServer().login(localServerName, signedLocalServerName, LOCALE);
            if (session == null) {
                Server.logSevereMessage("O login no servidor central falhou.");
            }
            return session;
        }
        catch (RemoteException e) {
            throw new CSBaseException((Throwable)e);
        }
    }

    public final void start() {
        this.startMonitoring();
    }

    protected final void warning(String message) {
        Server.logWarningMessage(message);
    }

    public LocalServerRemoteMonitor(ServerURI serverURI, Class<?> locator) {
        this(serverURI, locator, 5);
        instance = this;
    }

    public LocalServerRemoteMonitor(ServerURI serverURI, Class<?> locator, int windowSize) {
        super(serverURI, locator, windowSize);
        instance = this;
    }
}

