/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.pluginservice;

import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import org.java.plugin.ObjectFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.StandardPluginLocation;
import org.java.plugin.util.ExtendedProperties;

public class PluginService
extends Service {
    public static final String SERVICE_NAME = "PluginService";
    private final String pluginRepositoryPath = this.getStringProperty("base.plugin.dir");
    private PluginManager pluginManager;
    private boolean availablePlugins;

    protected PluginService() throws ServerException {
        super(SERVICE_NAME);
    }

    public static void createService() throws ServerException {
        new PluginService();
    }

    public static PluginService getInstance() {
        return (PluginService)PluginService.getInstance(SERVICE_NAME);
    }

    @Override
    protected void initService() throws ServerException {
        this.availablePlugins = this.loadPlugins();
    }

    @Override
    protected void shutdownService() throws ServerException {
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    public Plugin getPlugin(String pluginId) throws ServerException {
        try {
            return this.pluginManager.getPlugin(pluginId);
        }
        catch (PluginLifecycleException e) {
            throw new ServerException("Erro ao recuperar o plugin " + pluginId, e);
        }
    }

    public Map<String, Class<?>> getPluginExtensionPoints(String pluginId, String extensionPointId) throws ServerException {
        if (!this.availablePlugins) {
            return null;
        }
        if (!this.pluginManager.getRegistry().isExtensionPointAvailable(pluginId, extensionPointId)) {
            return null;
        }
        HashMap extensionPoints = new HashMap();
        ExtensionPoint point = this.pluginManager.getRegistry().getExtensionPoint(pluginId, extensionPointId);
        for (Extension ext : point.getConnectedExtensions()) {
            PluginDescriptor descr = ext.getDeclaringPluginDescriptor();
            try {
                this.pluginManager.activatePlugin(descr.getId());
                PluginClassLoader classLoader = this.pluginManager.getPluginClassLoader(descr);
                Class<?> pluginCls = classLoader.loadClass(ext.getParameter("class").valueAsString());
                String pluginName = ext.getParameter("name").valueAsString();
                extensionPoints.put(pluginName, pluginCls);
            }
            catch (ClassNotFoundException | PluginLifecycleException e) {
                Server.logSevereMessage("Erro ao obter os pontos de extens\u00e3o", e);
                return null;
            }
        }
        return extensionPoints;
    }

    private boolean loadPlugins() throws ServerException {
        File pluginsDir = new File(this.pluginRepositoryPath);
        ExtendedProperties config = new ExtendedProperties();
        config.put((Object)"org.java.plugin.PathResolver", (Object)"org.java.plugin.standard.ShadingPathResolver");
        config.put((Object)"org.java.plugin.standard.ShadingPathResolver.shadowFolder", (Object)(pluginsDir.getAbsolutePath() + "/temp/.jpf-shadow"));
        config.put((Object)"org.java.plugin.standard.ShadingPathResolver.unpackMode", (Object)"smart");
        this.pluginManager = ObjectFactory.newInstance((ExtendedProperties)config).createManager();
        File[] plugins = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".zip");
            }
        });
        if (plugins == null) {
            return false;
        }
        try {
            PluginManager.PluginLocation[] locations = new PluginManager.PluginLocation[plugins.length];
            for (int i = 0; i < plugins.length; ++i) {
                locations[i] = StandardPluginLocation.create((File)plugins[i]);
            }
            this.pluginManager.publishPlugins(locations);
            return true;
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }
}

