/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_00;

import csbase.exception.ServiceFailureException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.ServerProject;
import csbase.server.services.projectservice.UpdatableFileInfo;
import csbase.server.services.projectservice.v1_00.FindService;
import csbase.server.services.projectservice.v1_00.OpenBusProjectFileUpdater;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import scs.core.ComponentContext;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.FileLockedException;
import tecgraf.ftc.common.exception.MaxClientsReachedException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.RemoteFileChannel;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.openbus.data_service.DataAccessDenied;
import tecgraf.openbus.data_service.DataDescription;
import tecgraf.openbus.data_service.DataKey;
import tecgraf.openbus.data_service.DataNotFound;
import tecgraf.openbus.data_service.DataView;
import tecgraf.openbus.data_service.IHierarchicalDataServiceHelper;
import tecgraf.openbus.data_service.IHierarchicalDataServiceOperations;
import tecgraf.openbus.data_service.IHierarchicalNavigationDataService;
import tecgraf.openbus.data_service.InvalidDataKey;
import tecgraf.openbus.data_service.Metadata;
import tecgraf.openbus.data_service.ServiceFailure;
import tecgraf.openbus.data_service.UnknownViewInterface;
import tecgraf.openbus.data_service.UnknownViews;
import tecgraf.openbus.data_service.UnstructuredData;
import tecgraf.openbus.data_service.UnstructuredDataHelper;
import tecgraf.openbus.data_service.UnstructuredDataImpl;
import tecgraf.openbus.data_service.project.ProjectItemDescriptionImpl;
import tecgraf.openbus.project.ProjectItemDescription;

public class ProjectDataService
implements IHierarchicalDataServiceOperations {
    private static final String LNG_PREFIX = "ProjectDataService.";
    private static final DataDescription[] EMPTY_DATA_DESCRIPTION_ARRAY = new DataDescription[0];
    private static final String ABSOLUTE_PATH_METADATUM_NAME = "ABSOLUTE_PATH";
    private static ProjectDataService instance;

    private ProjectDataService() {
    }

    public static ProjectDataService getInstance() {
        if (instance == null) {
            instance = new ProjectDataService();
        }
        return instance;
    }

    public DataDescription[] getRoots() throws ServiceFailure {
        User user = Service.getUser();
        if (user == null) {
            Server.logSevereMessage(MessageFormat.format("Usu\u00e1rio {0} n\u00e3o existe.", user));
            throw new ServiceFailure();
        }
        java.lang.Object userId = user.getId();
        ProjectService projectService = ProjectService.getInstance();
        ArrayList<UserProjectInfo> projects = new ArrayList<UserProjectInfo>();
        try {
            projects.addAll(projectService.getProjectsFromUser(userId));
            projects.addAll(projectService.getProjectsSharedWithUser(userId));
        }
        catch (ServiceFailureException e) {
            Server.logSevereMessage(MessageFormat.format("Ocorreu um erro ao obter os nomes dos projetos do usu\u00e1rio {0}", userId), e);
            throw new ServiceFailure();
        }
        if (projects.size() == 0) {
            return EMPTY_DATA_DESCRIPTION_ARRAY;
        }
        ArrayList<ProjectItemDescriptionImpl> roots = new ArrayList<ProjectItemDescriptionImpl>(projects.size());
        for (UserProjectInfo projectInfo : projects) {
            String projectName = projectInfo.getProjectName();
            try {
                CommonClientProject project = projectService.openProject(projectInfo.getProjectId(), false);
                ClientProjectFile rootFile = project.getRoot();
                try {
                    roots.add(this.createDataDescription(rootFile));
                }
                catch (InvalidDataKey e) {
                    Server.logSevereMessage(MessageFormat.format("Erro ao criar descri\u00e7\u00e3o para o arquivo {0}.", rootFile.getStringPath()), e);
                    throw new ServiceFailure();
                }
            }
            catch (ServiceFailureException e) {
                Server.logSevereMessage(MessageFormat.format("Ocorreu um erro ao abrir o projeto {0} do usu\u00e1rio {1}.", projectName, userId), e);
                throw new ServiceFailure();
            }
        }
        return roots.toArray(EMPTY_DATA_DESCRIPTION_ARRAY);
    }

    public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure, InvalidDataKey, DataNotFound {
        DataKey dataKey = new DataKey(fKey);
        ClientProjectFile parent = ProjectDataService.getProjectFile(dataKey);
        if (!parent.isDirectory()) {
            throw new ServiceFailure();
        }
        ClientProjectFile[] children = null;
        try {
            children = parent.getChildren();
        }
        catch (RemoteException e) {
            throw new ServiceFailure();
        }
        if (children == null) {
            return EMPTY_DATA_DESCRIPTION_ARRAY;
        }
        ArrayList<ProjectItemDescriptionImpl> nodes = new ArrayList<ProjectItemDescriptionImpl>(children.length);
        for (int i = 0; i < children.length; ++i) {
            nodes.add(this.createDataDescription(children[i]));
        }
        return nodes.toArray(EMPTY_DATA_DESCRIPTION_ARRAY);
    }

    public DataDescription getParent(byte[] fKey) throws ServiceFailure, InvalidDataKey, DataNotFound {
        DataKey dataKey = new DataKey(fKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        if (file == null) {
            throw new InvalidDataKey(fKey);
        }
        ClientProjectFile parent = file.getParent();
        if (parent == null) {
            return null;
        }
        return this.createDataDescription(parent);
    }

    public DataDescription getDataDescription(byte[] fKey) throws ServiceFailure, InvalidDataKey, DataNotFound {
        DataKey dataKey = new DataKey(fKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        if (file == null) {
            throw new InvalidDataKey(dataKey.getKey());
        }
        return this.createDataDescription(file);
    }

    public DataView getDataView(byte[] fKey, String fViewInterface) throws ServiceFailure, UnknownViewInterface, InvalidDataKey, DataNotFound {
        DataKey dataKey = new DataKey(fKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        if (file == null) {
            throw new InvalidDataKey(dataKey.getKey());
        }
        return this.createDataView(file, fViewInterface);
    }

    public DataView[] getDataViewSeq(byte[][] fKeys, String fViewInterface) throws ServiceFailure, UnknownViewInterface, InvalidDataKey, DataNotFound {
        DataView[] viewSeq = new DataView[fKeys.length];
        for (int i = 0; i < fKeys.length; ++i) {
            viewSeq[i] = this.getDataView(fKeys[i], fViewInterface);
        }
        return viewSeq;
    }

    public byte[] createData(byte[] fParentKey, DataDescription fPrototype) throws ServiceFailure, InvalidDataKey, DataNotFound {
        DataKey key1;
        DataKey parentKey = new DataKey(fParentKey);
        ClientProjectFile parent = ProjectDataService.getProjectFile(parentKey);
        if (parent == null) {
            throw new InvalidDataKey(parentKey.getKey());
        }
        if (!parent.isDirectory()) {
            throw new ServiceFailure();
        }
        ProjectItemDescription prototype = (ProjectItemDescription)fPrototype;
        try {
            if (prototype.fIsContainer) {
                parent.createFile(prototype.fName, "DIRECTORY_TYPE");
            } else {
                parent.createFile(prototype.fName, prototype.fType);
            }
        }
        catch (RemoteException e) {
            throw new ServiceFailure();
        }
        catch (ServiceFailureException e) {
            String userLogin = Service.getUser().getLogin();
            String projectName = ServerProject.getProjectName(parent.getProjectId());
            Server.logSevereMessage(MessageFormat.format("Ocorreu um erro ao criar o dado {0} no projeto {1} pertencente ao usu\u00e1rio {2}.", prototype.fName, projectName, userLogin), e);
            throw new ServiceFailure();
        }
        String dataId = ProjectDataService.generateDataId(parent, prototype.fName);
        DataKey key = key1 = this.generateDataKey(dataId);
        return key.getKey();
    }

    public byte[] copyData(byte[] fParentKey, byte[] fSourceKey) throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey, DataAccessDenied {
        DataKey parentKey = new DataKey(fParentKey);
        ClientProjectFile parent = ProjectDataService.getProjectFile(parentKey);
        DataKey sourceKey = new DataKey(fSourceKey);
        ClientProjectFile source = ProjectDataService.getProjectFile(sourceKey);
        try {
            source.copy(parent);
        }
        catch (RemoteException e) {
            throw new ServiceFailure();
        }
        String dataId = ProjectDataService.generateDataId(parent, source.getName());
        DataKey dataKey = this.generateDataKey(dataId);
        return dataKey.getKey();
    }

    public void moveData(byte[] fKey, byte[] fNewParentKey) throws ServiceFailure, UnknownViews, InvalidDataKey, DataNotFound {
        DataKey dataKey = new DataKey(fKey);
        DataKey newParentKey = new DataKey(fNewParentKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        ClientProjectFile newParent = ProjectDataService.getProjectFile(newParentKey);
        try {
            file.move(newParent);
        }
        catch (RemoteException e) {
            throw new ServiceFailure();
        }
    }

    public void updateData(byte[] fKey, byte[] fSourceKey) throws ServiceFailure, UnknownViews, InvalidDataKey, DataNotFound {
        DataKey dataKey = new DataKey(fKey);
        DataKey sourceKey = new DataKey(fSourceKey);
        ClientProjectFile destFile = ProjectDataService.getProjectFile(dataKey);
        ClientProjectFile sourceFile = ProjectDataService.getProjectFile(sourceKey);
        if (sourceFile.equals((java.lang.Object)destFile)) {
            Server.logSevereMessage("Ocorreu uma tentativa de copiar o arquivo " + sourceFile.getStringPath() + " sobre ele mesmo.");
            throw new ServiceFailure();
        }
        java.lang.Object projectId = destFile.getProjectId();
        String[] path = destFile.getPath();
        try (BufferedOutputStream out = new BufferedOutputStream(ProjectService.getInstance().getOutputStream(projectId, path));){
            sourceFile.download((OutputStream)out, 8192L, null);
        }
        catch (csbase.exception.project.FileLockedException e) {
            Server.logSevereMessage(MessageFormat.format("N\u00e3o foi poss\u00edvel atualizar o arquivo {0}, pois o mesmo est\u00e1 bloqueado.", destFile.getStringPath()), e);
            throw new ServiceFailure();
        }
        catch (IOException e) {
            Server.logSevereMessage(MessageFormat.format("Erro ao atualizar o arquivo {0}.", destFile.getStringPath()), e);
            throw new ServiceFailure();
        }
    }

    public void deleteData(byte[] fKey) throws ServiceFailure, InvalidDataKey, DataNotFound {
        DataKey dataKey = new DataKey(fKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        if (file == null) {
            throw new InvalidDataKey(fKey);
        }
        if (file.getParent() == null) {
            ProjectService.getInstance().removeProject(file.getProjectId());
        } else {
            try {
                file.remove();
            }
            catch (RemoteException e) {
                String userLogin = Service.getUser().getLogin();
                String projectName = ServerProject.getProjectName(file.getProjectId());
                Server.logSevereMessage(MessageFormat.format("Ocorreu um erro ao remover o arquivo {0} no projeto {1} pertencente ao usu\u00e1rio {2}.", file.getName(), projectName, userLogin), e);
                throw new ServiceFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] copyDataFrom(byte[] fParentKey, byte[] fSourceKey) throws ServiceFailure, InvalidDataKey, UnknownViews, DataAccessDenied, DataNotFound {
        OpenBusService.getInstance().joinChain();
        try {
            ProjectItemDescription parentDescription = (ProjectItemDescription)this.getDataDescription(fParentKey);
            String parentAbsolutePath = null;
            for (int i = 0; i < parentDescription.fMetadata.length; ++i) {
                if (!parentDescription.fMetadata[i].fName.equals(ABSOLUTE_PATH_METADATUM_NAME)) continue;
                Any any = parentDescription.fMetadata[i].fValue;
                parentAbsolutePath = any.extract_string();
            }
            DataKey sourceDataKey = new DataKey(fSourceKey);
            IHierarchicalNavigationDataService sourceDataService = FindService.find(sourceDataKey);
            if (sourceDataService == null) {
                Server.logSevereMessage("Fonte de dados n\u00e3o foi encontrada.");
                throw new ServiceFailure();
            }
            ProjectItemDescription sourceDescription = (ProjectItemDescription)sourceDataService.getDataDescription(fSourceKey);
            String path = parentDescription.fPath + "/" + sourceDescription.fName;
            String absolutePath = parentAbsolutePath + "/" + sourceDescription.fName;
            List<Metadata> metadata = ProjectDataService.createMetadataList(absolutePath);
            long date = System.currentTimeMillis();
            String userLogin = Service.getUser().getLogin();
            ProjectItemDescriptionImpl prototype = new ProjectItemDescriptionImpl(sourceDescription.fName, ProjectDataService.createViewSet(sourceDescription.fIsContainer), metadata, userLogin, sourceDescription.fDescription, path, sourceDescription.fType, 0L, sourceDescription.fIsContainer, sourceDescription.fCanRead, sourceDescription.fCanWrite, date, date);
            byte[] key = this.createData(fParentKey, (DataDescription)prototype);
            this.updateDataFrom(key, fSourceKey);
            byte[] byArray = key;
            return byArray;
        }
        finally {
            OpenBusService.getInstance().exitChain();
        }
    }

    private static Set<String> createViewSet(boolean container) {
        HashSet<String> views = new HashSet<String>();
        if (!container) {
            views.add(UnstructuredDataHelper.id());
        }
        return views;
    }

    private static List<Metadata> createMetadataList(String absolutePath) {
        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
        ORB orb = OpenBusService.getInstance().getORB();
        if (absolutePath != null) {
            Any any = orb.create_any();
            any.insert_string(absolutePath);
            metadataList.add(new Metadata(ABSOLUTE_PATH_METADATUM_NAME, any));
        }
        return metadataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateDataFrom(byte[] fKey, byte[] fSourceKey) throws ServiceFailure, InvalidDataKey, UnknownViews, DataNotFound, DataAccessDenied {
        SyncRemoteFileChannel sourceChannel;
        SyncRemoteFileChannel channel;
        UnstructuredData view;
        UnstructuredData sourceView;
        DataKey dataKey = new DataKey(fKey);
        ClientProjectFile file = ProjectDataService.getProjectFile(dataKey);
        DataKey sourceDataKey = new DataKey(fSourceKey);
        IHierarchicalNavigationDataService sourceDataService = FindService.find(sourceDataKey);
        if (sourceDataService == null) {
            Server.logSevereMessage("Fonte de dados n\u00e3o foi encontrada.");
            throw new ServiceFailure();
        }
        ProjectItemDescription sourceDescription = (ProjectItemDescription)sourceDataService.getDataDescription(sourceDataKey.getKey());
        try {
            sourceView = (UnstructuredData)sourceDataService.getDataView(sourceDataKey.getKey(), UnstructuredDataHelper.id());
        }
        catch (UnknownViewInterface e1) {
            throw new UnknownViews();
        }
        try {
            view = (UnstructuredData)this.createDataView(file, UnstructuredDataHelper.id());
        }
        catch (UnknownViewInterface e) {
            throw new UnknownViews();
        }
        try {
            channel = new SyncRemoteFileChannel(dataKey.getDataId().getBytes("UTF8"), view.fWritable, view.fHost, view.fPort, view.fAccessKey);
        }
        catch (UnsupportedEncodingException e) {
            Server.logSevereMessage(MessageFormat.format("Erro ao converter o identificador do dado de destino ({0}) para bytes.", dataKey.getDataId()), e);
            throw new ServiceFailure();
        }
        try {
            sourceChannel = new SyncRemoteFileChannel(sourceDataKey.getDataId().getBytes("UTF8"), sourceView.fWritable, sourceView.fHost, sourceView.fPort, sourceView.fAccessKey);
        }
        catch (UnsupportedEncodingException e) {
            Server.logSevereMessage(MessageFormat.format("Erro ao converter o identificador do dado de origem ({0}) para bytes.", sourceDataKey.getDataId()), e);
            throw new ServiceFailure();
        }
        try {
            channel.open(false);
            sourceChannel.open(true);
        }
        catch (PermissionException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new DataAccessDenied();
        }
        catch (FileNotFoundException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        catch (FailureException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        catch (MaxClientsReachedException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        try {
            channel.syncTransferFrom((RemoteFileChannel)sourceChannel, 0L, sourceDescription.fSize);
        }
        catch (PermissionException e) {
            Server.logSevereMessage("Sem permiss\u00e3o para escrever no arquivo.", e);
            throw new ServiceFailure();
        }
        catch (FailureException e) {
            Server.logSevereMessage("Falha na transfer\u00eancia do arquivo.", e);
            throw new ServiceFailure();
        }
        catch (FileLockedException e) {
            Server.logSevereMessage("Tentativa de escrita em arquivo.", e);
            throw new ServiceFailure();
        }
        finally {
            block43: {
                channel.close();
                try {
                    sourceChannel.close();
                }
                catch (FailureException failureException) {}
                break block43;
                catch (FailureException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            sourceChannel.close();
                        }
                        catch (FailureException failureException) {}
                        throw throwable;
                    }
                    try {
                        sourceChannel.close();
                    }
                    catch (FailureException failureException) {}
                }
            }
        }
        if (!ProjectService.getInstance().setUpdatableFileInfo(file, new UpdatableFileInfo(OpenBusProjectFileUpdater.class, (Serializable)sourceDataKey.getKey()))) {
            Server.logWarningMessage(MessageFormat.format("A informa\u00e7\u00e3o sobre atualiza\u00e7\u00e3o do arquivo {0} n\u00e3o foi definida", file.getStringPath()));
        }
    }

    public void updateDataFrom(java.lang.Object projectId, String[] pathArray, byte[] fSourceKey) throws ServiceFailure, InvalidDataKey, UnknownViews, DataNotFound, DataAccessDenied {
        String dataId = ProjectDataService.generateDataId(projectId, pathArray);
        DataKey dataKey = this.generateDataKey(dataId);
        this.updateDataFrom(dataKey.getKey(), fSourceKey);
    }

    private static ClientProjectFile getProjectFile(DataKey dataKey) throws InvalidDataKey, ServiceFailure, DataNotFound {
        CommonClientProject project;
        String dataId = dataKey.getDataId();
        String[] splittedKey = dataId.split("@/@");
        if (splittedKey.length < 1) {
            throw new InvalidDataKey(dataKey.getKey());
        }
        String projectId = splittedKey[0];
        ServerProject serverProject = ServerProject.getProject(projectId);
        java.lang.Object userId = ServerProject.getOwnerId(projectId);
        try {
            project = ProjectService.getInstance().openProject(projectId, false);
        }
        catch (ServiceFailureException e) {
            Server.logSevereMessage(MessageFormat.format(ProjectService.getInstance().getString("ProjectDataService.error_openning_project"), serverProject.getName(), userId), e);
            throw new ServiceFailure();
        }
        if (splittedKey.length == 1) {
            ClientProjectFile file = project.getRoot();
            if (file == null) {
                throw new DataNotFound((byte[][])new byte[][]{dataKey.getKey()});
            }
            return file;
        }
        String[] filePath = new String[splittedKey.length - 1];
        for (int i = 0; i < filePath.length; ++i) {
            filePath[i] = splittedKey[i + 1];
        }
        try {
            ClientProjectFile file = project.getFile(filePath);
            if (file == null) {
                throw new DataNotFound((byte[][])new byte[][]{dataKey.getKey()});
            }
            return file;
        }
        catch (RemoteException e) {
            throw new ServiceFailure();
        }
    }

    private static String generateDataId(ClientProjectFile file) {
        return ProjectDataService.generateDataId(file.getProjectId(), file.getPath());
    }

    private static String generateDataId(java.lang.Object projectId, String[] pathArray) {
        String dataId = (String)projectId;
        for (String path : pathArray) {
            dataId = dataId + "@/@" + path;
        }
        return dataId;
    }

    private static String generateDataId(ClientProjectFile parent, String childName) {
        String dataId = ProjectDataService.generateDataId(parent);
        dataId = dataId + "@/@" + childName;
        return dataId;
    }

    private DataKey generateDataKey(String dataId) throws InvalidDataKey {
        ORB orb = OpenBusService.getInstance().getORB();
        ComponentContext context = OpenBusService.getInstance().getComponentContext(IHierarchicalDataServiceHelper.id());
        String iComponentIOR = orb.object_to_string((Object)context.getIComponent());
        return new DataKey(dataId, IHierarchicalDataServiceHelper.id(), context.getComponentId(), null, iComponentIOR);
    }

    private ProjectItemDescriptionImpl createDataDescription(ClientProjectFile file) throws InvalidDataKey {
        String dataId = ProjectDataService.generateDataId(file);
        DataKey dataKey = this.generateDataKey(dataId);
        String description = null;
        try {
            description = file.getDescription();
        }
        catch (RemoteException e) {
            Server.logWarningMessage(MessageFormat.format("Erro ao obter a descri\u00e7\u00e3o do arquivo {0}.", file.getStringPath()));
        }
        catch (ServiceFailureException e) {
            Server.logWarningMessage(MessageFormat.format("Erro ao obter a descri\u00e7\u00e3o do arquivo {0}.", file.getStringPath()));
        }
        String[] pathArray = file.getPath();
        String path = "";
        for (int i = 0; i < pathArray.length; ++i) {
            path = path + "/" + pathArray[i];
        }
        return new ProjectItemDescriptionImpl(dataKey.getKey(), file.getName(), ProjectDataService.createViewSet(file.isDirectory()), ProjectDataService.createMetadataList(file.getStringPath()), (String)file.whoCreated(), description, path, file.getType(), file.size(), file.isDirectory(), true, !file.isDirectory(), file.getCreationDate(), file.getModificationDate());
    }

    private DataView createDataView(ClientProjectFile file, String viewInterface) throws UnknownViewInterface, ServiceFailure, InvalidDataKey {
        if (viewInterface.equals(UnstructuredDataHelper.id())) {
            return this.createUnstructuredData(file);
        }
        throw new UnknownViewInterface();
    }

    private UnstructuredData createUnstructuredData(ClientProjectFile file) throws UnknownViewInterface, ServiceFailure, InvalidDataKey {
        if (file.isDirectory()) {
            throw new UnknownViewInterface();
        }
        String dataIdString = ProjectDataService.generateDataId(file);
        DataKey dataKey = this.generateDataKey(dataIdString);
        ProjectService prjSrv = ProjectService.getInstance();
        try {
            RemoteFileChannelInfo accessInfo = prjSrv.createFileChannelInfo(file);
            return new UnstructuredDataImpl(dataKey.getKey(), accessInfo.getHost(), accessInfo.getPort(), accessInfo.getKey(), true);
        }
        catch (Exception e) {
            String errorMessage = MessageFormat.format("Ocorreu um erro durante a cria\u00e7\u00e3o da vis\u00e3o n\u00e3o estruturada do arquivo {0}", file.getStringPath());
            Server.logSevereMessage(errorMessage, e);
            throw new ServiceFailure();
        }
    }
}

