/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CapacityType;
import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.BalancedCommandDistribution;
import csbase.server.services.schedulerservice.SGASetCPUAndIOComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.filter.SGAFilterByCommandRequirements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CPUIOCapacityPolicy
implements SchedulerPolicyInterface {
    private long minWritingCap;
    private long maxWritingCap;
    private long minSendCap;
    private long maxSendCap;
    private double minProcCap;
    private double maxProcCap;

    private void initializeExtremes(List<SGASet> servers) {
        long transferCap;
        long cpuCap;
        long writeCap;
        if (servers.size() > 0) {
            SGASet sga = servers.get(0);
            writeCap = sga.getCapacity(CapacityType.DISK_WRITE);
            if (writeCap == -1L) {
                writeCap = 1L;
            }
            this.minWritingCap = writeCap;
            this.maxWritingCap = writeCap;
            cpuCap = sga.getCapacity(CapacityType.CPU);
            if (cpuCap == -1L) {
                cpuCap = 1L;
            }
            this.minProcCap = 1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap;
            this.maxProcCap = 1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap;
            transferCap = sga.getCapacity(CapacityType.NET);
            if (transferCap == -1L) {
                transferCap = 1L;
            } else if (transferCap == -2L) {
                transferCap = Long.MAX_VALUE;
            }
            this.minSendCap = transferCap;
            this.maxSendCap = transferCap;
        }
        for (int i = 1; i < servers.size(); ++i) {
            SGASet sga = servers.get(i);
            writeCap = sga.getCapacity(CapacityType.DISK_WRITE);
            if (writeCap == -1L) {
                writeCap = 1L;
            }
            if (writeCap < this.minWritingCap) {
                this.minWritingCap = writeCap;
            } else if (writeCap > this.maxWritingCap) {
                this.maxWritingCap = writeCap;
            }
            cpuCap = sga.getCapacity(CapacityType.CPU);
            if (cpuCap == -1L) {
                cpuCap = 1L;
            }
            if (1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap < this.minProcCap) {
                this.minProcCap = 1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap;
            } else if (1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap > this.maxProcCap) {
                this.maxProcCap = 1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap;
            }
            transferCap = sga.getCapacity(CapacityType.NET);
            if (transferCap == -1L) {
                transferCap = 1L;
            } else if (transferCap == -2L) {
                transferCap = Long.MAX_VALUE;
            }
            if (transferCap < this.minSendCap) {
                this.minSendCap = transferCap;
                continue;
            }
            if (transferCap <= this.maxSendCap) continue;
            this.maxSendCap = transferCap;
        }
    }

    @Override
    public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> servers) {
        BalancedCommandDistribution bdc = new BalancedCommandDistribution(servers);
        HashMap<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
        for (CommandInfo cmd : commands) {
            List<SGASet> filteresSGAs = SGAFilterByCommandRequirements.filter(cmd, servers);
            if (filteresSGAs == null) continue;
            this.initializeExtremes(filteresSGAs);
            List<SGASet> sgas = this.getSortedSGAByCPUAndIOCapacity(filteresSGAs);
            if (sgas.size() == 0) continue;
            SGASet choosedServer = bdc.chooseLightest(sgas);
            allocation.put(cmd, choosedServer);
        }
        return null;
    }

    private List<SGASet> getSortedSGAByCPUAndIOCapacity(List<SGASet> servers) {
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        sgasSets.addAll(servers);
        Collections.sort(sgasSets, new SGASetCPUAndIOComparator(this.minWritingCap, this.maxWritingCap, this.minProcCap, this.maxProcCap, this.minSendCap, this.maxSendCap));
        return sgasSets;
    }
}

