/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.filter;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.sga.filter.SGACriteria;
import csbase.logic.sga.filter.SGACriteriaAnd;
import csbase.logic.sga.filter.SGACriteriaByAvailability;
import csbase.logic.sga.filter.SGACriteriaByMinCPUs;
import csbase.logic.sga.filter.SGACriteriaByMinFreeRAMMem;
import csbase.logic.sga.filter.SGACriteriaByName;
import csbase.logic.sga.filter.SGACriteriaByPlatform;
import csbase.logic.sga.filter.SGACriteriaByRequirements;
import csbase.logic.sga.filter.SGACriteriaOr;
import csbase.logic.sga.filter.SGAFilter;
import csbase.server.services.schedulerservice.filter.SGACriteriaByUserPermission;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SGAFilterByCommandRequirements {
    public static List<SGASet> filter(CommandInfo cmd, List<SGASet> servers) {
        try {
            float minMem;
            float minCPU;
            SGACriteriaByPlatform platformsCriteria;
            String platformRestriction;
            String name;
            SGACriteriaByName nameCriteria = null;
            SGACriteriaByRequirements binariesCriteria = null;
            SGACriteriaByMinCPUs minCPUsCriteria = null;
            SGACriteriaByMinFreeRAMMem minMemCriteria = null;
            AlgorithmConfigurator conf = cmd.getConfigurator();
            String string = name = cmd.isAutomatic() ? null : cmd.getSGAName();
            if (name != null) {
                nameCriteria = new SGACriteriaByName(name);
            }
            if ((platformRestriction = cmd.getPlatformFilter()) != null) {
                platformsCriteria = new SGACriteriaByPlatform(platformRestriction);
            } else {
                Set platformsSet = conf.getPlatforms();
                LinkedList<SGACriteriaByPlatform> criterias = new LinkedList<SGACriteriaByPlatform>();
                for (String platform : platformsSet) {
                    criterias.add(new SGACriteriaByPlatform(platform));
                }
                platformsCriteria = new SGACriteriaOr(criterias);
            }
            SGACriteriaByAvailability availabilityCriteria = new SGACriteriaByAvailability();
            Set reqs = conf.getRequirements();
            if (!reqs.isEmpty()) {
                binariesCriteria = new SGACriteriaByRequirements(reqs);
            }
            if ((minCPU = conf.getCpuAmount()) != 0.0f) {
                minCPUsCriteria = new SGACriteriaByMinCPUs(minCPU);
            }
            if ((minMem = conf.getMemoryAmount()) != 0.0f) {
                minMemCriteria = new SGACriteriaByMinFreeRAMMem((double)minMem);
            }
            SGACriteriaByUserPermission userPermission = new SGACriteriaByUserPermission(cmd.getUserId());
            LinkedList<Object> criteriasToMeet = new LinkedList<Object>();
            if (nameCriteria != null) {
                criteriasToMeet.add(nameCriteria);
            }
            criteriasToMeet.add(platformsCriteria);
            criteriasToMeet.add(availabilityCriteria);
            if (binariesCriteria != null) {
                criteriasToMeet.add(binariesCriteria);
            }
            if (minCPUsCriteria != null) {
                criteriasToMeet.add(minCPUsCriteria);
            }
            if (minMemCriteria != null) {
                criteriasToMeet.add(minMemCriteria);
            }
            criteriasToMeet.add(userPermission);
            SGACriteriaAnd finalCriteria = new SGACriteriaAnd(criteriasToMeet);
            return new SGAFilter((SGACriteria)finalCriteria).filter(servers);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }
}

