/*
 * Decompiled with CFR 0.152.
 */
package csbase.servlet;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import csbase.exception.HttpServiceException;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.HttpServiceInterface;
import csbase.remote.ServerEntryPoint;
import csbase.servlet.AbstractServlet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.Naming;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tecgraf.javautils.core.lng.LNG;

public class UploadServlet
extends AbstractServlet {
    private int fileSize;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.fileSize = Integer.parseInt(config.getInitParameter("fileSize"));
        }
        catch (NumberFormatException e) {
            this.fileSize = 102400;
        }
    }

    private HttpServiceInterface getHttpService() {
        try {
            String addr = this.getRMIpath() + "Server";
            ClientRemoteLocator.server = (ServerEntryPoint)Naming.lookup(addr);
            ClientRemoteLocator.httpService = ClientRemoteLocator.server.fetchHttpService();
            return ClientRemoteLocator.httpService;
        }
        catch (Exception e) {
            System.out.println(LNG.get((String)"UploadServlet.httpservice.error", (Object[])new String[]{new Date().toString(), e.getLocalizedMessage()}));
            e.printStackTrace();
            return null;
        }
    }

    private String getAccessCode(HttpServletRequest request) {
        String reqParameters = request.getPathInfo();
        if (reqParameters == null) {
            return null;
        }
        String[] params = reqParameters.split("/", 3);
        if (params == null) {
            return null;
        }
        return params[1];
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!this.hasPropertiesFile() && !this.loadPropertiesFile()) {
            this.messageError(response, LNG.get((String)"UploadServlet.system.properties.notfound"));
            return;
        }
        try {
            String line;
            String accessCode = this.getAccessCode(request);
            if (accessCode == null) {
                this.messageError(response, LNG.get((String)"UploadServlet.accesscode.null"));
                return;
            }
            HttpServiceInterface httpService = this.getHttpService();
            if (httpService == null) {
                this.messageError(response, LNG.get((String)"UploadServlet.httpservice.null"));
                return;
            }
            if (httpService.getFilePath(accessCode) == null) {
                this.messageError(response, LNG.get((String)"UploadServlet.access.denied"));
                return;
            }
            String presentationPath = httpService.getPresentationPath(accessCode);
            if (presentationPath == null) {
                this.messageError(response, LNG.get((String)"UploadServlet.uploadpage.reading.failure"));
                return;
            }
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            FileReader fr = new FileReader(presentationPath);
            BufferedReader bf = new BufferedReader(fr);
            while ((line = bf.readLine()) != null) {
                out.println(line);
            }
            out.close();
        }
        catch (IOException e) {
            this.messageError(response, LNG.get((String)"UploadServlet.form.build.error", (Object[])new String[]{e.getMessage()}));
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!this.hasPropertiesFile() && !this.loadPropertiesFile()) {
            this.messageError(response, LNG.get((String)"UploadServlet.system.properties.notfound"));
            return;
        }
        try {
            String accessCode = this.getAccessCode(request);
            if (accessCode == null) {
                this.messageError(response, LNG.get((String)"UploadServlet.accesscode.null"));
                return;
            }
            HttpServiceInterface httpService = this.getHttpService();
            if (httpService == null) {
                this.messageError(response, LNG.get((String)"UploadServlet.httpservice.null"));
                return;
            }
            String absolutePath = httpService.getFilePath(accessCode);
            if (absolutePath == null) {
                this.messageError(response, LNG.get((String)"UploadServlet.access.denied"));
                return;
            }
            String resultPath = httpService.getResultPath(accessCode);
            if (resultPath == null) {
                this.messageError(response, LNG.get((String)"UploadServlet.uploadpage.reading.failure"));
                return;
            }
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            if (this.sendFile(request, response, httpService, absolutePath, accessCode)) {
                String line;
                FileReader fr = new FileReader(resultPath);
                BufferedReader bf = new BufferedReader(fr);
                while ((line = bf.readLine()) != null) {
                    out.println(line);
                }
            } else {
                out.println(LNG.get((String)"UploadServlet.fileupload.samename"));
            }
            out.close();
        }
        catch (IOException e) {
            this.messageError(response, LNG.get((String)"UploadServlet.filetransfer.error", (Object[])new String[]{e.getMessage()}));
        }
    }

    private boolean sendFile(HttpServletRequest req, HttpServletResponse res, HttpServiceInterface httpService, String absolutePath, String accessCode) {
        String absPath = absolutePath;
        FilePart fp = null;
        File arq = null;
        boolean sendRedirect = false;
        boolean sendFile = false;
        String redirect = "";
        try {
            Part part;
            MultipartParser mp = new MultipartParser(req, this.fileSize);
            while ((part = mp.readNextPart()) != null) {
                if (part.isFile()) {
                    fp = (FilePart)part;
                    String fn = fp.getFileName();
                    if (httpService.isDirectory(accessCode)) {
                        if (!httpService.createFile(accessCode, fn)) {
                            return false;
                        }
                        absPath = absPath + File.separator + fn;
                    }
                    if (fn == null) continue;
                    arq = new File(absPath);
                    fp.writeTo(arq);
                    if (httpService.finishUpload(accessCode, fn)) {
                        sendFile = true;
                    }
                    System.out.println(LNG.get((String)"UploadServlet.url.upload", (Object[])new String[]{new Date().toString(), req.getRequestURI(), arq.getAbsolutePath()}));
                    continue;
                }
                if (!part.isParam()) continue;
                ParamPart param = (ParamPart)part;
                String paramName = param.getName();
                String stringValue = param.getStringValue();
                if (paramName == null || !paramName.equals("sendRedirect") || stringValue == null || stringValue.trim().isEmpty()) continue;
                sendRedirect = true;
                redirect = stringValue;
            }
            if (sendFile && sendRedirect) {
                res.sendRedirect(redirect);
            }
        }
        catch (IOException e) {
            StringBuffer messageBuilder = new StringBuffer();
            String exceptionMessage = e.getLocalizedMessage();
            exceptionMessage.replace("\\n", "<br>");
            messageBuilder.append(LNG.get((String)"UploadServlet.io.exception", (Object[])new String[]{Integer.toString(this.fileSize / 1024), exceptionMessage}));
            String message = messageBuilder.toString();
            this.messageError(res, message);
            this.log(message, e);
            if (arq != null) {
                arq.delete();
            }
            return false;
        }
        catch (HttpServiceException e) {
            StringBuffer messageBuilder = new StringBuffer();
            String exceptionMessage = e.getLocalizedMessage();
            exceptionMessage.replace("\\n", "<br>");
            messageBuilder.append(LNG.get((String)"UploadServlet.httpservice.exception", (Object[])new String[]{exceptionMessage}));
            String message = messageBuilder.toString();
            this.messageError(res, message);
            this.log(message, e);
            if (arq != null) {
                arq.delete();
            }
            return false;
        }
        return sendFile;
    }

    private void messageError(HttpServletResponse response, String message) {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(LNG.get((String)"UploadServlet.error.message.tohtml", (Object[])new String[]{message}));
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

