/**
 * $Id: JobObserver.java 163602 2015-04-14 18:56:26Z fpina $
 */
package csbase.sga.executor;


/**
 * Observador de jobs. O {@link JobExecutor executor} notifica o trmino da
 * execuo de jobs atravs destes observadores.
 *
 * @author Tecgraf/PUC-Rio
 */
public interface JobObserver {

  /**
   * Callback de notificao de trmino de execuo de jobs.
   *
   * @param jobInfo as informaes sobre a execuo do job
   */
  public void onJobCompleted(JobInfo jobInfo);

  /**
   * Callback de notificao de perda de job. Jobs perdidos so aqueles que o
   * ambiente de execuo no consegue mais obter o estado.
   */
  public void onJobLost();
}
