/**
 * $Id: JobStorage.java 172594 2016-04-12 15:11:18Z fpina $
 */
package csbase.sga.ssh;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;

/**
 * @author Tecgraf
 */
public class JobStorage {
  private long jobInfoMaxAge = 60 * 1000;
  private long lastJobInfoUpdate = 0;
  private Map<JobData, JobInfo> jobInfoMap = new Hashtable<>();
  private Map<JobData, JobObserver> jobObserverMap = new Hashtable<>();

  public JobStorage() {
    new JobStorage(jobInfoMaxAge);
  }

  public JobStorage(long jobInfoMaxAge) {
    this.jobInfoMaxAge = jobInfoMaxAge;
  }

  public synchronized void addJob(JobData data, JobObserver observer) {
    jobObserverMap.put(data, observer);
    jobInfoMap.put(data, new JobInfo());
  }

  public synchronized boolean recoverJob(JobData data, JobObserver observer) {
    if (jobInfoMap.containsKey(data)) {
      jobObserverMap.put(data, observer);
      return true;
    } else {
      return false;
    }
  }

  public synchronized JobObserver getObserver(JobData data) {
    return jobObserverMap.get(data);
  }

  public synchronized void removeJob(JobData data) {
    jobInfoMap.remove(data);
    jobObserverMap.remove(data);
  }

  public synchronized JobInfo getJobInfo(JobData data) {
    if (jobInfoMap.containsKey(data)) {
      return jobInfoMap.get(data);
    } else {
      return null;
    }
  }

  public synchronized Set<JobData> getJobs() {
    Set jobs = new HashSet<>();
    jobs.addAll(jobObserverMap.keySet());
    jobs.addAll(jobInfoMap.keySet());
    return jobs;
  }

  public synchronized void updateJobs(Map<JobData, JobInfo> jobsInfo) {
    jobInfoMap.putAll(jobsInfo);
    lastJobInfoUpdate = System.currentTimeMillis();
  }

  public synchronized boolean needsUpdate() {
    return System.currentTimeMillis() - lastJobInfoUpdate > jobInfoMaxAge;
  }
}
