/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import org.junit.Assert;
import org.junit.Test;

public final class DoubleParameterTest {
    @Test
    public void testDoubleParameter1() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        DoubleParameter parameter = new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
        this.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum, parameter);
    }

    @Test
    public void testDoubleParameter2() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        DoubleParameter parameter = new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
        this.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum, parameter);
    }

    @Test
    public void testDoubleParameter3() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = false;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        DoubleParameter parameter = new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
        this.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum, parameter);
    }

    @Test
    public void testDoubleParameter4() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = false;
        DoubleParameter parameter = new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
        this.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum, parameter);
    }

    @Test
    public void testDoubleParameter5() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = null;
        boolean includeMaximum = false;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        DoubleParameter parameter = new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
        this.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum, parameter);
    }

    @Test
    public void testDoubleParameter6() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = null;
        boolean includeMinimum = false;
        DoubleParameter parameter = new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
        this.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleParameter7() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(1.1);
        boolean includeMaximum = false;
        Double minimum = new Double(10.01);
        boolean includeMinimum = true;
        new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleParameter8() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = false;
        Double minimum = new Double(1.01);
        boolean includeMinimum = true;
        new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleParameter9() {
        String name = "Nome do par\u00e2metro";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = false;
        Double minimum = new Double(1.01);
        boolean includeMinimum = true;
        new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleParameter10() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = false;
        Double minimum = new Double(1.01);
        boolean includeMinimum = true;
        new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
    }

    @Test
    public void testDoubleParameter11() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = null;
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        DoubleParameter parameter = new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
        this.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum, parameter);
    }

    @Test
    public void testSetMaximumWithValidValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean maximumIncluded = true;
        Double initialValue = 5.0;
        Double maximum = 10.0;
        DoubleParameter parameter = new DoubleParameter(name, label, description, initialValue, false, true, null, maximum, maximumIncluded.booleanValue(), Double.valueOf(0.0), true);
        DoubleParameterValidator parameterValidator = (DoubleParameterValidator)parameter.getParameterValidator();
        Double newMaximum = 6.0;
        boolean valueWasSet = parameter.setMaximum(newMaximum, maximumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)maximumIncluded, (Object)parameter.isMaximumIncluded());
        Assert.assertEquals((Object)newMaximum, (Object)parameterValidator.getMaximum());
        Assert.assertEquals((Object)maximumIncluded, (Object)parameterValidator.isMaximumIncluded());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMaximumWithInvalidValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean maximumIncluded = true;
        Double initialValue = 5.0;
        Double maximum = 10.0;
        DoubleParameter parameter = new DoubleParameter(name, label, description, initialValue, false, true, null, maximum, maximumIncluded.booleanValue(), Double.valueOf(0.0), true);
        DoubleParameterValidator parameterValidator = (DoubleParameterValidator)parameter.getParameterValidator();
        Double newMaximum = 4.0;
        boolean valueWasSet = parameter.setMaximum(newMaximum, maximumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)maximumIncluded, (Object)parameter.isMaximumIncluded());
        Assert.assertEquals((Object)maximumIncluded, (Object)parameterValidator.isMaximumIncluded());
        Assert.assertEquals((Object)newMaximum, (Object)parameterValidator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMaximWithNonIncludedMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean maximumIncluded = true;
        Double initialValue = 5.0;
        Double maximum = 10.0;
        DoubleParameter parameter = new DoubleParameter(name, label, description, initialValue, false, true, null, maximum, maximumIncluded.booleanValue(), Double.valueOf(0.0), true);
        DoubleParameterValidator parameterValidator = (DoubleParameterValidator)parameter.getParameterValidator();
        Double newMaximum = 5.0;
        Boolean newMinimumIncluded = false;
        boolean valueWasSet = parameter.setMaximum(newMaximum, newMinimumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)newMinimumIncluded, (Object)parameter.isMaximumIncluded());
        Assert.assertEquals((Object)newMinimumIncluded, (Object)parameterValidator.isMaximumIncluded());
        Assert.assertEquals((Object)newMaximum, (Object)parameterValidator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMinimumWithValidValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean minimumIncluded = true;
        Double initialValue = 5.0;
        Double minimum = 0.0;
        DoubleParameter parameter = new DoubleParameter(name, label, description, initialValue, false, true, null, Double.valueOf(10.0), true, minimum, minimumIncluded.booleanValue());
        DoubleParameterValidator parameterValidator = (DoubleParameterValidator)parameter.getParameterValidator();
        Double newMinimum = 4.0;
        boolean valueWasSet = parameter.setMinimum(newMinimum, minimumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)minimumIncluded, (Object)parameter.isMinimumIncluded());
        Assert.assertEquals((Object)minimumIncluded, (Object)parameterValidator.isMinimumIncluded());
        Assert.assertEquals((Object)newMinimum, (Object)parameterValidator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMinimumWithInvalidValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean minimumIncluded = true;
        Double initialValue = 5.0;
        Double minimum = 0.0;
        DoubleParameter parameter = new DoubleParameter(name, label, description, initialValue, false, true, null, Double.valueOf(10.0), true, minimum, minimumIncluded.booleanValue());
        DoubleParameterValidator parameterValidator = (DoubleParameterValidator)parameter.getParameterValidator();
        Double newMinimum = 6.0;
        boolean valueWasSet = parameter.setMinimum(newMinimum, minimumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)minimumIncluded, (Object)parameter.isMinimumIncluded());
        Assert.assertEquals((Object)minimumIncluded, (Object)parameterValidator.isMinimumIncluded());
        Assert.assertEquals((Object)newMinimum, (Object)parameterValidator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetMinimumWithNonIncludedMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Boolean minimumIncluded = true;
        Double initialValue = 5.0;
        Double minimum = 0.0;
        DoubleParameter parameter = new DoubleParameter(name, label, description, initialValue, false, true, null, Double.valueOf(10.0), true, minimum, minimumIncluded.booleanValue());
        DoubleParameterValidator parameterValidator = (DoubleParameterValidator)parameter.getParameterValidator();
        Boolean newMinimumIncluded = false;
        Double newMinimum = 5.0;
        boolean valueWasSet = parameter.setMinimum(newMinimum, newMinimumIncluded.booleanValue());
        Assert.assertTrue((boolean)valueWasSet);
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)newMinimumIncluded, (Object)parameter.isMinimumIncluded());
        Assert.assertEquals((Object)newMinimum, (Object)parameterValidator.getMinimum());
        Assert.assertEquals((Object)newMinimumIncluded, (Object)parameterValidator.isMinimumIncluded());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = parameter.validate(context);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testSetValueAsText() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        DoubleParameter parameter = new DoubleParameter(name, label, description, null, false, true, null, null, false, null, false);
        Double value = new Double(12000.0);
        parameter.setValueAsText(value.toString());
        Assert.assertEquals((Object)value.toString(), (Object)parameter.getValueAsText());
        Assert.assertEquals((Object)value, (Object)parameter.getValue());
    }

    @Test(expected=ParseException.class)
    public void testSetValueAsTextWithInvalidValue() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        DoubleParameter parameter = new DoubleParameter(name, label, description, null, false, true, null, null, false, null, false);
        parameter.setValueAsText("Valor inv\u00e1lido.");
    }

    @Test
    public void testSetValueAsTextWithNull() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        DoubleParameter parameter = new DoubleParameter(name, label, description, new Double(10.0), false, true, null, null, false, null, false);
        parameter.setValueAsText(null);
        Assert.assertNull((Object)parameter.getValue());
        Assert.assertNull((Object)parameter.getValueAsText());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double defaultValue = new Double(5.5);
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        DoubleParameter outputParameter = new DoubleParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, includeMaximum, minimum, includeMinimum);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        DoubleParameter inputParameter = (DoubleParameter)objectInput.readObject();
        this.assertEquals(outputParameter.getName(), outputParameter.getLabel(), outputParameter.getDescription(), (Double)outputParameter.getDefaultValue(), outputParameter.isOptional(), outputParameter.getCommandLinePattern(), outputParameter.getMaximum(), outputParameter.isMaximumIncluded(), outputParameter.getMinimum(), outputParameter.isMinimumIncluded(), inputParameter);
    }

    private void assertEquals(String name, String label, String description, Double defaultValue, boolean isOptional, String commandLinePattern, Double maximum, boolean includeMaximum, Double minimum, boolean includeMinimum, DoubleParameter parameter) {
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)defaultValue, (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)includeMaximum, (Object)parameter.isMaximumIncluded());
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)includeMinimum, (Object)parameter.isMinimumIncluded());
    }
}

