/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class EnumerationParameterTest {
    @Test
    public void testEnumerationParameter1() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String itemId = "ID do item";
        String itemName = "Nome do item";
        String itemValue = "Valor do item";
        String itemDescription = "Descri\u00e7\u00e3o do item";
        EnumerationItem defaultValue = new EnumerationItem(itemId, itemName, itemValue, itemDescription);
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(defaultValue);
        EnumerationParameter parameter = new EnumerationParameter(name, label, description, defaultValue, true, commandLinePattern, items, mustSortItems);
        this.assertEquals(name, label, description, defaultValue, commandLinePattern, items, mustSortItems, parameter);
    }

    @Test
    public void testEnumerationParameter2() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String itemId1 = "Identificador do item 1";
        String itemName1 = "Nome do item 1";
        String itemValue1 = "Valor do item 1";
        String itemDescription1 = "Descri\u00e7\u00e3o do item 1";
        EnumerationItem item1 = new EnumerationItem(itemId1, itemName1, itemValue1, itemDescription1);
        String itemId2 = "Identificador do item 2";
        String itemName2 = "Nome do item 2";
        String itemValue2 = "Valor do item 2";
        String itemDescription2 = "Descri\u00e7\u00e3o do item 2";
        EnumerationItem item2 = new EnumerationItem(itemId2, itemName2, itemValue2, itemDescription2);
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = false;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        EnumerationParameter parameter = new EnumerationParameter(name, label, description, item1, true, commandLinePattern, items, mustSortItems);
        this.assertEquals(name, label, description, item1, commandLinePattern, items, mustSortItems, parameter);
    }

    @Test
    public void testEnumerationParameter3() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String itemId1 = "Identificador do item 1";
        String itemName1 = "Nome do item 1";
        String itemValue1 = "Valor do item 1";
        String itemDescription1 = "Descri\u00e7\u00e3o do item 1";
        EnumerationItem item1 = new EnumerationItem(itemId1, itemName1, itemValue1, itemDescription1);
        String itemId2 = "Identificador do item 2";
        String itemName2 = "Nome do item 2";
        String itemValue2 = "Valor do item 2";
        String itemDescription2 = "Descri\u00e7\u00e3o do item 2";
        EnumerationItem item2 = new EnumerationItem(itemId2, itemName2, itemValue2, itemDescription2);
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        EnumerationParameter parameter = new EnumerationParameter(name, label, description, item1, true, commandLinePattern, items, mustSortItems);
        Collections.sort(items);
        this.assertEquals(name, label, description, item1, commandLinePattern, items, mustSortItems, parameter);
    }

    @Test
    public void testEnumerationParameter4() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String itemId1 = "Identificador do item 1";
        String itemName1 = "Nome do item 1";
        String itemValue1 = "Valor do item 1";
        String itemDescription1 = "Descri\u00e7\u00e3o do item 1";
        EnumerationItem item1 = new EnumerationItem(itemId1, itemName1, itemValue1, itemDescription1);
        String itemId2 = "Identificador do item 2";
        String itemName2 = "Nome do item 2";
        String itemValue2 = "Valor do item 2";
        String itemDescription2 = "Descri\u00e7\u00e3o do item 2";
        EnumerationItem item2 = new EnumerationItem(itemId2, itemName2, itemValue2, itemDescription2);
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        EnumerationParameter parameter = new EnumerationParameter(name, label, description, null, true, commandLinePattern, items, mustSortItems);
        Collections.sort(items);
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter);
    }

    @Test
    public void testEnumerationParameter5() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String itemId1 = "Identificador do item 1";
        String itemName1 = "Nome do item 1";
        String itemValue1 = "Valor do item 1";
        String itemDescription1 = "Descri\u00e7\u00e3o do item 1";
        EnumerationItem item1 = new EnumerationItem(itemId1, itemName1, itemValue1, itemDescription1);
        String itemId2 = "Identificador do item 2";
        String itemName2 = "Nome do item 2";
        String itemValue2 = "Valor do item 2";
        String itemDescription2 = "Descri\u00e7\u00e3o do item 2";
        EnumerationItem item2 = new EnumerationItem(itemId2, itemName2, itemValue2, itemDescription2);
        String commandLinePattern = null;
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item2);
        items.add(item1);
        EnumerationParameter parameter = new EnumerationParameter(name, label, description, null, true, commandLinePattern, items, mustSortItems);
        Collections.sort(items);
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter);
    }

    @Test
    public void testEnumerationParameter6() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        EnumerationParameter parameter = new EnumerationParameter(name, label, description, null, true, commandLinePattern, items, mustSortItems);
        this.assertEquals(name, label, description, null, commandLinePattern, items, mustSortItems, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumerationParameter7() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = true;
        LinkedList items = new LinkedList();
        new EnumerationParameter(name, label, description, null, true, commandLinePattern, items, mustSortItems);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumerationParameter8() {
        String name = "Nome do par\u00e2metro";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = true;
        LinkedList items = new LinkedList();
        new EnumerationParameter(name, label, description, null, true, commandLinePattern, items, mustSortItems);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumerationParameter9() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        String commandLinePattern = null;
        boolean mustSortItems = true;
        LinkedList items = new LinkedList();
        new EnumerationParameter(name, label, description, null, true, commandLinePattern, items, mustSortItems);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumerationParameter10() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean mustSortItems = true;
        List items = null;
        new EnumerationParameter(name, label, description, null, true, commandLinePattern, items, mustSortItems);
    }

    private void assertEquals(String name, String label, String description, EnumerationItem defaultValue, String commandLinePattern, List<EnumerationItem> items, boolean mustSortItems, EnumerationParameter parameter) {
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)defaultValue, (Object)parameter.getDefaultValue());
        Assert.assertFalse((boolean)parameter.isOptional());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals(items, (Object)parameter.getItems());
        Assert.assertEquals((Object)mustSortItems, (Object)parameter.mustSortItems());
    }
}

