/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileParameter;
import org.junit.Assert;
import org.junit.Test;

public final class InputFileParameterTest {
    @Test
    public void testInputFileParameterWithOptionalValue() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test
    public void testInputFileParameterWithNonOptionalValue() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test
    public void testInputFileParameterWithNullCommandLinePattern() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = null;
        boolean isVisible = true;
        boolean useFilter = false;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test
    public void testInputFileParameterWithNullFileType() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test
    public void testInputFileParameterWithDirectoryMode() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.DIRECTORY;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test
    public void testInputFileParameterWithPipeAcceptance() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.FALSE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test
    public void testInputFileParameterWithForcedExtension() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test
    public void testInputFileParameterWithFilter() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = true;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test
    public void testInputFileParameterNotVisible() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = false;
        boolean useFilter = true;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInputFileParameterWithNullName() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInputFileParameterWithNullLabel() {
        String name = "NOME_DO_PARAMETRO";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInputFileParameterWithNullDescription() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInputFileParameterWithNullMode() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = null;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
    }

    @Test
    public void testInputFileParameterWithDirectoryAndFileMode() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        InputFileParameter parameter = new InputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, useFilter, parameter);
    }

    private void assertEquals(String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String fileType, FileParameterMode mode, FileParameterPipeAcceptance canUsePipe, boolean useFilter, InputFileParameter parameter) {
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)isVisible, (Object)parameter.isVisible());
        Assert.assertEquals((Object)useFilter, (Object)parameter.usesFilter());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)fileType, (Object)parameter.getFileType());
        Assert.assertEquals((Object)mode, (Object)parameter.getMode());
        Assert.assertNull((Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)canUsePipe, (Object)parameter.usesPipe());
    }
}

