/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.CheckIntegerListParameterListener;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerListParameterListener;
import csbase.logic.algorithms.parameters.validators.IntegerParameterValidator;
import csbase.logic.algorithms.parameters.validators.ListParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public final class IntegerListParameterTest {
    @Test
    public void testIntegerListParameter1() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = new Integer(100);
        Integer minimum = new Integer(0);
        IntegerListParameter parameter = new IntegerListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, minimum);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertNull((Object)parameter.getDefaultValue());
    }

    @Test
    public void testIntegerListParameter2() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = new Integer(100);
        Integer minimum = new Integer(0);
        IntegerListParameter parameter = new IntegerListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, minimum);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertNull((Object)parameter.getDefaultValue());
    }

    @Test
    public void testIntegerListParameter3() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = new Integer(0);
        IntegerListParameter parameter = new IntegerListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, minimum);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertNull((Object)parameter.getMaximum());
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertNull((Object)parameter.getDefaultValue());
    }

    @Test
    public void testIntegerListParameter4() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = new Integer(100);
        Integer minimum = null;
        IntegerListParameter parameter = new IntegerListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, minimum);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertNull((Object)parameter.getMinimum());
        Assert.assertNull((Object)parameter.getDefaultValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntegerListParameter5() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        new IntegerListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, minimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntegerListParameter6() {
        String name = "Nome do par\u00e2metro";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        new IntegerListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, minimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntegerListParameter7() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        new IntegerListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, minimum);
    }

    @Test
    public void testSetMaximumWithDifferentMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(2000);
        value.add(500);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMaximum = 2000;
        Assert.assertTrue((boolean)integerListParameter.setMaximum(newMaximum));
        Assert.assertEquals((Object)newMaximum, (Object)integerListParameter.getMaximum());
        Assert.assertEquals((Object)newMaximum, (Object)validator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerListParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        Assert.assertEquals((long)1L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithNullInitialMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = null;
        Integer minimum = 0;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(2000);
        value.add(500);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMaximum = 2000;
        Assert.assertTrue((boolean)integerListParameter.setMaximum(newMaximum));
        Assert.assertEquals((Object)newMaximum, (Object)integerListParameter.getMaximum());
        Assert.assertEquals((Object)newMaximum, (Object)validator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerListParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        Assert.assertEquals((long)1L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithNullNewMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(500);
        value.add(Integer.MAX_VALUE);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        checkListener.allowMaximumWasChangedEvent();
        Integer newMaximum = null;
        Assert.assertTrue((boolean)integerListParameter.setMaximum(newMaximum));
        Assert.assertEquals(newMaximum, (Object)integerListParameter.getMaximum());
        Assert.assertEquals(newMaximum, (Object)validator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerListParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        Assert.assertEquals((long)1L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithSameMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(1000);
        value.add(500);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMaximum = maximum;
        Assert.assertFalse((boolean)integerListParameter.setMaximum(newMaximum));
        Assert.assertEquals((Object)newMaximum, (Object)integerListParameter.getMaximum());
        Assert.assertEquals((Object)newMaximum, (Object)validator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerListParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        Assert.assertEquals((long)0L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithNullInitialAndNewMaximumValues() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = null;
        Integer minimum = 0;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(2000);
        value.add(Integer.MAX_VALUE);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMaximum = maximum;
        Assert.assertFalse((boolean)integerListParameter.setMaximum(newMaximum));
        Assert.assertEquals(newMaximum, (Object)integerListParameter.getMaximum());
        Assert.assertEquals(newMaximum, (Object)validator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerListParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        Assert.assertEquals((long)0L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithInvalidMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(1000);
        value.add(500);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMaximum = 200;
        Assert.assertTrue((boolean)integerListParameter.setMaximum(newMaximum));
        Assert.assertEquals((Object)newMaximum, (Object)integerListParameter.getMaximum());
        Assert.assertEquals((Object)newMaximum, (Object)validator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerListParameter.validate(context);
        junit.framework.Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertEquals((long)1L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithDifferentMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = -1000;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(-1000);
        value.add(500);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMinimum = -2000;
        Assert.assertTrue((boolean)integerListParameter.setMinimum(newMinimum));
        Assert.assertEquals((Object)newMinimum, (Object)integerListParameter.getMinimum());
        Assert.assertEquals((Object)newMinimum, (Object)validator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerListParameter.validate(context);
        junit.framework.Assert.assertTrue((boolean)result.isWellSucceded());
        Assert.assertEquals((long)1L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithNullInitialMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = null;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(-1000);
        value.add(500);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMinimum = -2000;
        Assert.assertTrue((boolean)integerListParameter.setMinimum(newMinimum));
        Assert.assertEquals((Object)newMinimum, (Object)integerListParameter.getMinimum());
        Assert.assertEquals((Object)newMinimum, (Object)validator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerListParameter.validate(context);
        junit.framework.Assert.assertTrue((boolean)result.isWellSucceded());
        Assert.assertEquals((long)1L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithNullNewMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = -1000;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(-1000);
        value.add(-3520);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMinimum = null;
        Assert.assertTrue((boolean)integerListParameter.setMinimum(newMinimum));
        Assert.assertEquals(newMinimum, (Object)integerListParameter.getMinimum());
        Assert.assertEquals(newMinimum, (Object)validator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerListParameter.validate(context);
        junit.framework.Assert.assertTrue((boolean)result.isWellSucceded());
        Assert.assertEquals((long)1L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithSameMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(1000);
        value.add(0);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMinimum = minimum;
        Assert.assertFalse((boolean)integerListParameter.setMinimum(newMinimum));
        Assert.assertEquals((Object)newMinimum, (Object)integerListParameter.getMinimum());
        Assert.assertEquals((Object)newMinimum, (Object)validator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerListParameter.validate(context);
        junit.framework.Assert.assertTrue((boolean)result.isWellSucceded());
        Assert.assertEquals((long)0L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithNullInitialAndNewMinimumValues() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = null;
        Integer minimum = 0;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(1000);
        value.add(0);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMinimum = minimum;
        Assert.assertFalse((boolean)integerListParameter.setMinimum(newMinimum));
        Assert.assertEquals((Object)newMinimum, (Object)integerListParameter.getMinimum());
        Assert.assertEquals((Object)newMinimum, (Object)validator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerListParameter.validate(context);
        junit.framework.Assert.assertTrue((boolean)result.isWellSucceded());
        Assert.assertEquals((long)0L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithInvalidMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = 1000;
        Integer minimum = -1000;
        IntegerListParameter integerListParameter = new IntegerListParameter(name, label, description, null, false, true, null, maximum, minimum);
        ArrayList<Integer> value = new ArrayList<Integer>();
        value.add(1000);
        value.add(0);
        integerListParameter.setValue(value);
        CheckIntegerListParameterListener checkListener = new CheckIntegerListParameterListener();
        integerListParameter.addIntegerListParameterListener((IntegerListParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        ListParameterValidator listParameterValidator = (ListParameterValidator)integerListParameter.getParameterValidator();
        IntegerParameterValidator validator = (IntegerParameterValidator)listParameterValidator.getItemValidator();
        Integer newMinimum = 600;
        Assert.assertTrue((boolean)integerListParameter.setMinimum(newMinimum));
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)integerListParameter.getMinimum());
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)validator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerListParameter.validate(context);
        junit.framework.Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertEquals((long)1L, (long)checkListener.getEventCount());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = new Integer(100);
        Integer minimum = new Integer(0);
        IntegerListParameter outputParameter = new IntegerListParameter(name, label, description, null, isOptional, true, commandLinePattern, maximum, minimum);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        IntegerListParameter inputParameter = (IntegerListParameter)objectInput.readObject();
        Assert.assertEquals((Object)outputParameter.getName(), (Object)inputParameter.getName());
        Assert.assertEquals((Object)outputParameter.getLabel(), (Object)inputParameter.getLabel());
        Assert.assertEquals((Object)outputParameter.getDescription(), (Object)inputParameter.getDescription());
        Assert.assertEquals((Object)outputParameter.getDefaultValue(), (Object)inputParameter.getDefaultValue());
        Assert.assertEquals((Object)outputParameter.isOptional(), (Object)inputParameter.isOptional());
        Assert.assertEquals((Object)outputParameter.getCommandLinePattern(), (Object)inputParameter.getCommandLinePattern());
        Assert.assertEquals((Object)outputParameter.getMaximum(), (Object)inputParameter.getMaximum());
        Assert.assertEquals((Object)outputParameter.getMinimum(), (Object)inputParameter.getMinimum());
    }
}

