/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.CheckIntegerParameterListener;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.IntegerParameterListener;
import csbase.logic.algorithms.parameters.SimpleParameterListener;
import csbase.logic.algorithms.parameters.SimpleParameterTest;
import csbase.logic.algorithms.parameters.validators.IntegerParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class IntegerParameterTest {
    @Test
    public void testIntegerParameter1() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = null;
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        IntegerParameter parameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        IntegerParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, minimum, true, new LinkedList<SimpleParameterListener<Integer>>(), parameter);
    }

    @Test
    public void testIntegerParameter2() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = null;
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        IntegerParameter parameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        IntegerParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, minimum, true, new LinkedList<SimpleParameterListener<Integer>>(), parameter);
    }

    @Test
    public void testIntegerParameter3() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = null;
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = new Integer(1000);
        Integer minimum = null;
        IntegerParameter parameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        IntegerParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, minimum, true, new LinkedList<SimpleParameterListener<Integer>>(), parameter);
    }

    @Test
    public void testIntegerParameter4() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = null;
        boolean isOptional = true;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = new Integer(-1000);
        IntegerParameter parameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        IntegerParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, minimum, true, new LinkedList<SimpleParameterListener<Integer>>(), parameter);
    }

    @Test
    public void testIntegerParameter5() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = new Integer(10);
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        IntegerParameter parameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        IntegerParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, maximum, minimum, true, new LinkedList<SimpleParameterListener<Integer>>(), parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntegerParameter6() {
        new IntegerParameter(null, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "--{0} {1}", null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntegerParameter7() {
        new IntegerParameter("Nome do par\u00e2metro", null, "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "--{0} {1}", null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntegerParameter8() {
        new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", null, new Integer(10), false, true, "--{0} {1}", null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntegerParameter9() {
        new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "--{0} {1}", new Integer(-1000), new Integer(1000));
    }

    @Test
    public void testSetValueAsText1() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = null;
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        IntegerParameter parameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        Integer value = new Integer(10);
        parameter.setValueAsText(value.toString());
        junit.framework.Assert.assertEquals((String)value.toString(), (String)parameter.getValueAsText());
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsText2() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = new Integer(10);
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        IntegerParameter parameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        parameter.setValueAsText(null);
        Assert.assertNull((Object)parameter.getValueAsText());
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test(expected=ParseException.class)
    public void testSetValueAsText3() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = new Integer(10);
        boolean isOptional = false;
        String commandLinePattern = "--{0} {1}";
        Integer maximum = null;
        Integer minimum = null;
        IntegerParameter parameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        parameter.setValueAsText("Valor inv\u00e1lido.");
    }

    @Test
    public void testSetMaximumWithDifferentMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMaximum = 2000;
        Assert.assertTrue((boolean)integerParameter.setMaximum(newMaximum));
        junit.framework.Assert.assertEquals((Object)newMaximum, (Object)integerParameter.getMaximum());
        junit.framework.Assert.assertEquals((Object)newMaximum, (Object)parameterValidator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)1, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithNullInitialMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = null;
        Integer minimum = 0;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMaximum = 2000;
        Assert.assertTrue((boolean)integerParameter.setMaximum(newMaximum));
        junit.framework.Assert.assertEquals((Object)newMaximum, (Object)integerParameter.getMaximum());
        junit.framework.Assert.assertEquals((Object)newMaximum, (Object)parameterValidator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)1, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithNullNewMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMaximum = null;
        Assert.assertTrue((boolean)integerParameter.setMaximum(newMaximum));
        junit.framework.Assert.assertEquals(newMaximum, (Object)integerParameter.getMaximum());
        junit.framework.Assert.assertEquals(newMaximum, (Object)parameterValidator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)1, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithSameMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMaximum = maximum;
        Assert.assertFalse((boolean)integerParameter.setMaximum(newMaximum));
        junit.framework.Assert.assertEquals((Object)newMaximum, (Object)integerParameter.getMaximum());
        junit.framework.Assert.assertEquals((Object)newMaximum, (Object)parameterValidator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)0, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithNullInitialAndNewMaximumValues() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = null;
        Integer minimum = 0;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMaximum = maximum;
        Assert.assertFalse((boolean)integerParameter.setMaximum(newMaximum));
        junit.framework.Assert.assertEquals(newMaximum, (Object)integerParameter.getMaximum());
        junit.framework.Assert.assertEquals(newMaximum, (Object)parameterValidator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)0, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMaximumWithInvalidMaximumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMaximumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMaximum = 400;
        Assert.assertTrue((boolean)integerParameter.setMaximum(newMaximum));
        junit.framework.Assert.assertEquals((Object)newMaximum, (Object)integerParameter.getMaximum());
        junit.framework.Assert.assertEquals((Object)newMaximum, (Object)parameterValidator.getMaximum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerParameter.validate(context);
        junit.framework.Assert.assertFalse((boolean)result.isWellSucceded());
        junit.framework.Assert.assertEquals((int)1, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithDifferentMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = -1000;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMinimum = -2000;
        Assert.assertTrue((boolean)integerParameter.setMinimum(newMinimum));
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)integerParameter.getMinimum());
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)parameterValidator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)1, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithNullInitialMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = null;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMinimum = -2000;
        Assert.assertTrue((boolean)integerParameter.setMinimum(newMinimum));
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)integerParameter.getMinimum());
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)parameterValidator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)1, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithNullNewMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = -1000;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMinimum = null;
        Assert.assertTrue((boolean)integerParameter.setMinimum(newMinimum));
        junit.framework.Assert.assertEquals(newMinimum, (Object)integerParameter.getMinimum());
        junit.framework.Assert.assertEquals(newMinimum, (Object)parameterValidator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)1, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithSameMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = 0;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMinimum = minimum;
        Assert.assertFalse((boolean)integerParameter.setMinimum(newMinimum));
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)integerParameter.getMinimum());
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)parameterValidator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)0, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithNullInitialAndNewMinimumValues() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = null;
        Integer minimum = 0;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMinimum = minimum;
        Assert.assertFalse((boolean)integerParameter.setMinimum(newMinimum));
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)integerParameter.getMinimum());
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)parameterValidator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation validate = integerParameter.validate(context);
        Assert.assertTrue((boolean)validate.isWellSucceded());
        junit.framework.Assert.assertEquals((int)0, (int)checkListener.getEventCount());
    }

    @Test
    public void testSetMinimumWithInvalidMinimumValue() throws RemoteException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        int defaultValue = 500;
        Integer maximum = 1000;
        Integer minimum = -1000;
        IntegerParameter integerParameter = new IntegerParameter(name, label, description, Integer.valueOf(defaultValue), false, true, null, maximum, minimum);
        CheckIntegerParameterListener checkListener = new CheckIntegerParameterListener();
        integerParameter.addIntegerParameterListener((IntegerParameterListener)checkListener);
        checkListener.allowMinimumWasChangedEvent();
        IntegerParameterValidator parameterValidator = (IntegerParameterValidator)integerParameter.getParameterValidator();
        Integer newMinimum = 600;
        Assert.assertTrue((boolean)integerParameter.setMinimum(newMinimum));
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)integerParameter.getMinimum());
        junit.framework.Assert.assertEquals((Object)newMinimum, (Object)parameterValidator.getMinimum());
        ValidationContext context = new ValidationContext(ValidationMode.FULL, null, null);
        Validation result = integerParameter.validate(context);
        junit.framework.Assert.assertFalse((boolean)result.isWellSucceded());
        junit.framework.Assert.assertEquals((int)1, (int)checkListener.getEventCount());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = new Integer(5);
        boolean isOptional = false;
        Integer maximum = new Integer(10);
        Integer minimum = new Integer(0);
        String commandLinePattern = "--{0} {1}";
        IntegerParameter outputParameter = new IntegerParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maximum, minimum);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        IntegerParameter inputParameter = (IntegerParameter)objectInput.readObject();
        IntegerParameterTest.assertEquals(outputParameter, inputParameter);
    }

    private static void assertEquals(String name, String label, String description, Object defaultValue, boolean isOptional, String commandLinePattern, Integer maximum, Integer minimum, boolean isEnabled, List<SimpleParameterListener<Integer>> listeners, IntegerParameter parameter) {
        SimpleParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, isEnabled, listeners, parameter);
        junit.framework.Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        junit.framework.Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
    }

    private static void assertEquals(IntegerParameter expectedParameter, IntegerParameter foundParameter) {
        SimpleParameterTest.assertEquals(expectedParameter, foundParameter);
        junit.framework.Assert.assertEquals((Object)expectedParameter.getMaximum(), (Object)foundParameter.getMaximum());
        junit.framework.Assert.assertEquals((Object)expectedParameter.getMinimum(), (Object)foundParameter.getMinimum());
    }
}

