/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.exception.algorithms.FormulaEvaluationException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.ValidationExpression;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class ValidationExpressionTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testExpression1() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0} && {0}", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        Assert.assertEquals((Object)expressionText, (Object)expression.toString());
        Assert.assertEquals((Object)errorMessage, (Object)expression.getErrorMessage());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExpression2() throws FormulaCreationException, ParseException {
        String expressionText = "!Parametro";
        String errorMessage = "Mensagem de erro";
        new ValidationExpression(null, expressionText, errorMessage);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExpression3() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group.addParameter((Parameter)parameter);
        String errorMessage = "Mensagem de erro";
        new ValidationExpression(configurator, null, errorMessage);
    }

    @Test(expected=ParseException.class)
    public void testExpression4() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        BooleanParameter parameter = new BooleanParameter(parameterName, "Par\u00e2metro", "Par\u00e2metro", true, true, "{0}={1}", null, null);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("+++{0}", parameterName);
        String errorMessage = "Mensagem de erro";
        new ValidationExpression(configurator, expressionText, errorMessage);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExpression5() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0} && {0}", parameterName);
        new ValidationExpression(configurator, expressionText, null);
    }

    @Test
    public void testEquals1() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0} && {0}", parameterName);
        String errorMessage1 = "Mensagem de erro 1";
        String errorMessage2 = "Mensagem de erro 2";
        ValidationExpression expression1 = new ValidationExpression(configurator, expressionText, errorMessage1);
        ValidationExpression expression2 = new ValidationExpression(configurator, expressionText, errorMessage2);
        Assert.assertEquals((Object)expression1, (Object)expression2);
    }

    @Test
    public void testEquals2() throws FormulaCreationException, ParseException, FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator1 = this.createAlgorithmConfigurator("Algoritmo 1", 1, 1, 1);
        ParameterGroup group1 = new ParameterGroup("Nome do grupo");
        configurator1.addGroup(group1);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter1 = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group1.addParameter((Parameter)parameter1);
        SimpleAlgorithmConfigurator configurator2 = this.createAlgorithmConfigurator("Algoritmo 2", 2, 2, 2);
        ParameterGroup group2 = new ParameterGroup("Nome do grupo");
        configurator2.addGroup(group2);
        MockSimpleParameter parameter2 = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group2.addParameter((Parameter)parameter2);
        String expressionText = MessageFormat.format("{0} && {0}", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression1 = new ValidationExpression(configurator1, expressionText, errorMessage);
        ValidationExpression expression2 = new ValidationExpression(configurator2, expressionText, errorMessage);
        Assert.assertFalse((boolean)expression1.equals((Object)expression2));
    }

    @Test
    public void testEquals3() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group.addParameter((Parameter)parameter);
        String expressionText1 = MessageFormat.format("{0} && {0}", parameterName);
        String expressionText2 = MessageFormat.format("{0} || {0}", parameterName);
        String errorMessage1 = "Mensagem de erro 1";
        ValidationExpression expression1 = new ValidationExpression(configurator, expressionText1, errorMessage1);
        ValidationExpression expression2 = new ValidationExpression(configurator, expressionText2, errorMessage1);
        Assert.assertFalse((boolean)expression1.equals((Object)expression2));
    }

    @Test
    public void testEquals4() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0} && {0}", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        Assert.assertFalse((boolean)expression.equals(null));
    }

    @Test
    public void testEquals5() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0} && {0}", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        String objectOfAnotherClass = "Objeto de outra classe";
        Assert.assertFalse((boolean)expression.equals((Object)objectOfAnotherClass));
    }

    @Test
    public void testHashCode() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        MockSimpleParameter parameter = new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor_do_parametro", false, true, "{0}={1}");
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0} && {0}", parameterName);
        String errorMessage1 = "Mensagem de erro 1";
        String errorMessage2 = "Mensagem de erro 2";
        ValidationExpression expression1 = new ValidationExpression(configurator, expressionText, errorMessage1);
        ValidationExpression expression2 = new ValidationExpression(configurator, expressionText, errorMessage2);
        Assert.assertEquals((long)expression1.hashCode(), (long)expression2.hashCode());
    }

    @Test
    public void testEvaluate1() throws FormulaCreationException, ParseException, FormulaEvaluationException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        BooleanParameter parameter = new BooleanParameter(parameterName, "Par\u00e2metro", "Par\u00e2metro", false, true, "{0}={1}", null, null);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0}", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        Assert.assertFalse((boolean)expression.evaluate());
    }

    @Test
    public void testEvaluate2() throws FormulaCreationException, ParseException, FormulaEvaluationException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        BooleanParameter parameter = new BooleanParameter(parameterName, "Par\u00e2metro", "Par\u00e2metro", true, true, "{0}={1}", null, null);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0}", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        Assert.assertTrue((boolean)expression.evaluate());
    }

    @Test
    public void testEvaluate3() throws FormulaCreationException, ParseException, FormulaEvaluationException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName1 = "Nome_do_Parametro_1";
        int value1 = 2;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2mtro 1", Integer.valueOf(value1), false, true, "{0}={1}", null, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome_do_Parametro_2";
        int value2 = 4;
        IntegerParameter parameter2 = new IntegerParameter(parameterName2, "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2mtro 2", Integer.valueOf(value2), false, true, "{0}={1}", null, null);
        group.addParameter((Parameter)parameter2);
        String expressionText = MessageFormat.format("{0} < {1}", parameterName1, parameterName2);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        Assert.assertTrue((boolean)expression.evaluate());
    }

    @Test
    public void testEvaluate4() throws FormulaCreationException, ParseException, FormulaEvaluationException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        double value = 90.0;
        DoubleParameter parameter = new DoubleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2mtro", Double.valueOf(value), false, true, "{0}={1}", null, false, null, false);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("{0} < 180", parameterName, Double.toString(value));
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        Assert.assertTrue((boolean)expression.evaluate());
    }

    @Test
    public void testEvaluate5() throws FormulaCreationException, ParseException, FormulaEvaluationException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        double angle = 90.0;
        double sin = Math.sin(angle);
        DoubleParameter parameter = new DoubleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2mtro", Double.valueOf(angle), false, true, "{0}={1}", null, false, null, false);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("sin({0}) == {1}", parameterName, new Double(sin).toString());
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        Assert.assertTrue((boolean)expression.evaluate());
    }

    @Test
    public void testEvaluate6() throws FormulaCreationException, ParseException, FormulaEvaluationException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        DoubleParameter parameter = new DoubleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, true, true, "{0}={1}", null, false, null, false);
        group.addParameter((Parameter)parameter);
        String expressionText = parameterName;
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        configurator.addExpression(expression);
        Assert.assertFalse((boolean)expression.evaluate());
    }

    @Test(expected=FormulaEvaluationException.class)
    public void testEvaluate7() throws FormulaCreationException, ParseException, FormulaEvaluationException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        BooleanParameter parameter = new BooleanParameter(parameterName, "Par\u00e2metro", "Par\u00e2metro", true, true, "{0}={1}", null, null);
        group.addParameter((Parameter)parameter);
        String expressionText = "Outro_parametro && " + parameterName;
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        expression.evaluate();
    }

    @Test(expected=FormulaEvaluationException.class)
    public void testEvaluate8() throws FormulaCreationException, ParseException, FormulaEvaluationException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_Parametro";
        BooleanParameter parameter = new BooleanParameter(parameterName, "Par\u00e2metro", "Par\u00e2metro", true, true, "{0}={1}", null, null);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("funcao({0})", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        expression.evaluate();
    }

    @Test
    public void testEvaluate9() throws FormulaEvaluationException, FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "parametro";
        DoubleListParameter parameter = new DoubleListParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0}={1}", null, false, null, false);
        parameter.addElement((Object)3.0);
        parameter.addElement((Object)2.0);
        parameter.addElement((Object)1.0);
        parameter.addElement((Object)4.0);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("list_max({0}) == 4.0", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        Assert.assertTrue((boolean)expression.evaluate());
    }

    @Test
    public void testEvaluate10() throws FormulaEvaluationException, FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "parametro";
        DoubleListParameter parameter = new DoubleListParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0}={1}", null, false, null, false);
        parameter.addElement((Object)3.0);
        parameter.addElement((Object)2.0);
        parameter.addElement((Object)1.0);
        parameter.addElement((Object)4.0);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("list_min({0}) == 1.0", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        Assert.assertTrue((boolean)expression.evaluate());
    }

    @Test
    public void testEvaluate11() throws FormulaEvaluationException, FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_parametro";
        String columnName = "Nome_da_coluna";
        DoubleColumn doubleColumn = new DoubleColumn(columnName, columnName, null, false, true, null, false, null, false);
        TableParameter parameter = new TableParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "{0}={1}", Arrays.asList(doubleColumn), false, false, null, null, null, null);
        parameter.createRow();
        parameter.createRow();
        parameter.createRow();
        parameter.createRow();
        parameter.setItemValue((Object)2.0, 0, 0);
        parameter.setItemValue((Object)3.0, 1, 0);
        parameter.setItemValue((Object)4.0, 2, 0);
        parameter.setItemValue((Object)1.0, 3, 0);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("table_max({0}, 0) == 4.0", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        Assert.assertTrue((boolean)expression.evaluate());
    }

    @Test
    public void testEvaluate12() throws FormulaEvaluationException, FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String parameterName = "Nome_do_parametro";
        String columnName = "Nome_da_coluna";
        DoubleColumn doubleColumn = new DoubleColumn(columnName, columnName, null, false, true, null, false, null, false);
        TableParameter parameter = new TableParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "{0}={1}", Arrays.asList(doubleColumn), false, false, null, null, null, null);
        parameter.createRow();
        parameter.createRow();
        parameter.createRow();
        parameter.createRow();
        parameter.setItemValue((Object)2.0, 0, 0);
        parameter.setItemValue((Object)3.0, 1, 0);
        parameter.setItemValue((Object)4.0, 2, 0);
        parameter.setItemValue((Object)1.0, 3, 0);
        group.addParameter((Parameter)parameter);
        String expressionText = MessageFormat.format("table_min({0}, 0) == 1.0", parameterName);
        String errorMessage = "Mensagem de erro";
        ValidationExpression expression = new ValidationExpression(configurator, expressionText, errorMessage);
        Assert.assertTrue((boolean)expression.evaluate());
    }

    @Test
    public void testSerialize() throws FormulaCreationException, ParseException, IOException, ClassNotFoundException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        String expressionText = "parametro == 0";
        String errorMessage = "Mensagem de erro";
        ValidationExpression expectedExpression = new ValidationExpression(configurator, expressionText, errorMessage);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(expectedExpression);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        ValidationExpression loadedExpression = (ValidationExpression)objectInput.readObject();
        Assert.assertEquals((Object)expectedExpression.getErrorMessage(), (Object)loadedExpression.getErrorMessage());
        Assert.assertEquals((Object)expectedExpression.toString(), (Object)loadedExpression.toString());
        Assert.assertEquals((Object)expectedExpression.getConfigurator(), (Object)loadedExpression.getConfigurator());
    }

    private SimpleAlgorithmConfigurator createAlgorithmConfigurator() {
        String algorithmName = "Algoritmo";
        int major = 1;
        int minor = 2;
        int patch = 3;
        return this.createAlgorithmConfigurator(algorithmName, major, minor, patch);
    }

    private SimpleAlgorithmConfigurator createAlgorithmConfigurator(String algorithmName, int major, int minor, int patch) {
        AlgorithmInfo algorithm = new AlgorithmInfo("ID " + algorithmName, algorithmName, "DIR " + algorithmName, "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionInfo algorithmVersion = new AlgorithmVersionInfo(algorithm, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersion, "Descri\u00e7\u00e3o da vers\u00e3o", ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "comando", null, null, true, CMD_PATTERN);
    }
}

