package csbase.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;

import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectPermissions;

/**
 * Gerador de arquivo de controle de projeto a ser usado no caso do mesmo estar
 * corrompido em um sistema em produo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectInfoGenerator {

  /**
   * Aplicativo principal.
   * 
   * @param args argumentos:
   *        <ul>
   *        <li>Nome do projeto.
   *        <li>Id do usurio dono do projeto.
   *        <li>Nome do arquivo a ser gerado; que  usado para testes e costuma
   *        ser chamado conforme o padro CSBASE.
   *        </ul>
   */
  static public void main(String[] args) {
    if (args.length < 3) {
      System.out.println("Bad arguments: projectname, userid, filename");
      System.exit(-1);
    }
    final String projName = args[0];
    final String userId = args[1];
    final String fileName = args[2];
    generateFile(projName, userId, fileName);
  }

  /**
   * Funo paraq gerar um arquivo de controle de projetos CSBASE vazio com as
   * informaes bsicas de nomes de usurio e projeto.
   * 
   * @param projName nome do projeto
   * @param userId identificador do usurio
   * @param fileName arquivo a ser gravado (em geral usado conforme o padro
   *        CSBASE)
   */
  public static void generateFile(final String projName, final String userId,
    final String fileName) {
    final CommonProjectInfo info = new CommonProjectInfo();
    info.name = projName;
    info.userId = userId;
    ProjectPermissions.setSharingType(info, ProjectPermissions.SharingType.PRIVATE);
    try {
      final File file = new File(fileName);
      final FileOutputStream fout = new FileOutputStream(file);
      final ObjectOutputStream out = new ObjectOutputStream(fout);
      out.writeObject(info);
      out.close();
    }
    catch (Exception e) {
      System.out.println("Exception detected!");
      e.printStackTrace();
      System.exit(-2);
    }
  }
}
