/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import csbase.remote.ServerEntryPoint;
import csbase.tools.ExitCodes;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import tecgraf.javautils.core.lng.LNG;

public class DetectServer {
    private static int port = 0;
    static final String RMI_PROPERTY_NAME = "Server.registryPort";

    public static void main(String[] args) {
        DetectServer.loadProperties(args);
        DetectServer.tryCSBaseServerConnection();
        DetectServer.tryTCPConnection();
        DetectServer.exit(ExitCodes.PORT_AVAILABLE);
    }

    private static void loadProperties(String[] args) {
        if (args.length < 1) {
            DetectServer.terminate(ExitCodes.PROPS_FILE_MISSING);
        }
        try {
            Integer iPort;
            FileReader r = new FileReader(args[0]);
            System.getProperties().load(r);
            ((Reader)r).close();
            String sPort = System.getProperty(RMI_PROPERTY_NAME);
            if (sPort == null) {
                DetectServer.terminate(ExitCodes.PORT_SPEC_MISSING);
            }
            if ((iPort = Integer.getInteger(RMI_PROPERTY_NAME)) == null) {
                DetectServer.terminate(ExitCodes.PORT_NOT_INT);
            }
            port = iPort;
        }
        catch (Exception e) {
            DetectServer.terminate(ExitCodes.PROPS_FILE_ERROR, LNG.get((String)"DetectServer.error.propsfile", (Object[])new String[]{e.getMessage()}));
        }
    }

    private static void terminate(ExitCodes exitCode) {
        DetectServer.terminate(exitCode, exitCode.msg);
    }

    private static void terminate(ExitCodes exitCode, String msg) {
        System.err.println(msg);
        DetectServer.exit(exitCode);
    }

    private static void exit(ExitCodes code) {
        System.exit(code.exitCode);
    }

    private static void tryCSBaseServerConnection() {
        String url = "rmi://localhost:" + port;
        String serverURL = url + "/" + "Server";
        try {
            Naming.list(url);
        }
        catch (Exception e) {
            return;
        }
        Remote server = null;
        try {
            server = Naming.lookup(serverURL);
        }
        catch (Throwable e) {
            DetectServer.terminate(ExitCodes.UNKNOWN_SERVER, LNG.get((String)"DetectServer.error.unknownserver.rmilookup", (Object[])new String[]{e.getClass().getName(), e.getMessage()}));
        }
        try {
            ServerEntryPoint serverEntryPoint = (ServerEntryPoint)server;
            String versionName = serverEntryPoint.getVersionName();
            String msg = String.format(LNG.get((String)"DetectServer.serverok", (Object[])new String[]{versionName.isEmpty() ? "[???]" : versionName, Integer.toString(port)}), new Object[0]);
            DetectServer.terminate(ExitCodes.CSBASE_SERVER, msg);
        }
        catch (ServerException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnmarshalException) {
                DetectServer.terminate(ExitCodes.UNKNOWN_SERVER, LNG.get((String)"DetectServer.error.unknownserver.takenport", (Object[])new String[]{Integer.toString(port)}));
            } else {
                DetectServer.terminate(ExitCodes.UNKNOWN_SERVER, LNG.get((String)"DetectServer.error.unknownserver.reach", (Object[])new String[]{cause.getMessage()}));
            }
        }
        catch (Exception e) {
            DetectServer.terminate(ExitCodes.UNKNOWN_SERVER, LNG.get((String)"DetectServer.error.unknownserver.reach", (Object[])new String[]{e.getMessage()}));
        }
    }

    private static void tryTCPConnection() {
        ExitCodes result = DetectServer.tryTCPConnection("localhost", port, true);
        if (result != ExitCodes.PORT_AVAILABLE) {
            DetectServer.terminate(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ExitCodes tryTCPConnection(String serverName, int serverPort, boolean verbose) {
        InetSocketAddress addr = new InetSocketAddress(serverName, serverPort);
        ServerSocketChannel server = null;
        try {
            server = ServerSocketChannel.open();
        }
        catch (IOException e) {
            if (verbose) {
                System.err.println(e.getMessage());
            }
            return ExitCodes.IO_ERROR;
        }
        ServerSocket socket = server.socket();
        socket.bind(addr);
        try {
            socket.close();
        }
        catch (IOException e) {
            if (verbose) {
                System.err.println(LNG.get((String)"DetectServer.error.socketclose", (Object[])new String[]{e.getMessage()}));
            }
            return ExitCodes.IO_ERROR;
        }
        catch (IOException e) {
            ExitCodes exitCodes;
            try {
                exitCodes = ExitCodes.UNKNOWN_SERVER;
            }
            catch (Throwable throwable) {
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    if (verbose) {
                        System.err.println(LNG.get((String)"DetectServer.error.socketclose", (Object[])new String[]{e2.getMessage()}));
                    }
                    return ExitCodes.IO_ERROR;
                }
                throw throwable;
            }
            try {
                socket.close();
            }
            catch (IOException e3) {
                if (verbose) {
                    System.err.println(LNG.get((String)"DetectServer.error.socketclose", (Object[])new String[]{e3.getMessage()}));
                }
                return ExitCodes.IO_ERROR;
            }
            return exitCodes;
        }
        return ExitCodes.PORT_AVAILABLE;
    }
}

