/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectAttribute;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import tecgraf.javautils.core.lng.LNG;

public class IncorrectLockingAreaSizeIdentifier {
    public static void main(String[] args) {
        String secArg;
        String err;
        String firstArg;
        String err2;
        if (args.length < 1) {
            err2 = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.undefined");
            System.out.println(err2 + "\n\n");
            IncorrectLockingAreaSizeIdentifier.printHelp();
            System.exit(-1);
        }
        if (args.length > 2) {
            err2 = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.numargument");
            System.out.println(err2);
            System.out.println(err2 + "\n\n");
            IncorrectLockingAreaSizeIdentifier.printHelp();
            System.exit(-2);
        }
        if ((firstArg = args[0]) == null || firstArg.trim().isEmpty()) {
            String err3 = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.null");
            System.out.println(err3);
            System.exit(-3);
            return;
        }
        if (firstArg.trim().equalsIgnoreCase("--help")) {
            IncorrectLockingAreaSizeIdentifier.printHelp();
            return;
        }
        File file = new File(firstArg);
        String absPath = file.getAbsolutePath();
        if (!file.exists()) {
            err = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.inexistent", (Object[])new String[]{absPath});
            System.out.println(err);
            System.exit(-4);
        }
        if (file.isDirectory()) {
            err = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.isadir", (Object[])new String[]{absPath});
            System.out.println(err);
            System.exit(-5);
        }
        if (!file.canRead()) {
            err = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.nopermission", (Object[])new String[]{absPath});
            System.out.println(err);
            System.exit(-6);
        }
        if (file.length() <= 0L) {
            err = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.zerolength", (Object[])new String[]{absPath});
            System.out.println(err);
            System.exit(-7);
        }
        boolean forceCorrection = false;
        if (args.length == 2 && (secArg = args[1]).trim().equalsIgnoreCase("--fix")) {
            forceCorrection = true;
        }
        try {
            IncorrectLockingAreaSizeIdentifier.processProjectInfo(file, forceCorrection);
        }
        catch (StreamCorruptedException e) {
            String err4 = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.notobjectstream", (Object[])new String[]{absPath});
            System.out.println(err4);
            System.exit(-7);
        }
        catch (IOException e) {
            String err5 = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.io", (Object[])new String[]{e.getMessage()});
            System.out.println(err5);
            System.exit(-8);
        }
        catch (ClassNotFoundException e) {
            String msg = e.getMessage();
            String err6 = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.info.class.notfound", (Object[])new String[]{msg});
            System.out.println(err6);
            System.exit(-9);
        }
        catch (ClassCastException e) {
            String msg = e.getMessage();
            String err7 = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.configfile.notfromproject", (Object[])new String[]{absPath});
            System.out.println(err7 + " - " + msg);
            System.exit(-10);
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            String err8 = LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.internali1", (Object[])new String[]{msg});
            System.out.println(err8);
            t.printStackTrace();
            System.exit(-11);
        }
    }

    private static void printHelp() {
        System.out.println(LNG.get((String)"IncorrectLockingAreaSizeIdentifier.help"));
    }

    private static void processProjectInfo(File cfgFile, boolean forceCorrection) throws IOException, ClassNotFoundException {
        FileInputStream inFileStream = new FileInputStream(cfgFile);
        BufferedInputStream inBuffStream = new BufferedInputStream(inFileStream);
        DataInputStream inDataStream = new DataInputStream(inBuffStream);
        ObjectInputStream in = new ObjectInputStream(inDataStream);
        Object object = in.readObject();
        in.close();
        CommonProjectInfo info = (CommonProjectInfo)CommonProjectInfo.class.cast(object);
        ProjectAttribute prjAttr = ProjectAttribute.LOCKING_AREA_SIZE;
        String prjAttrKey = prjAttr.getAttributeKey();
        Object att = info.getAttribute(prjAttrKey);
        if (att instanceof Integer) {
            System.err.println(LNG.get((String)"IncorrectLockingAreaSizeIdentifier.error.lockingareasize.isinteger", (Object[])new String[]{info.name, info.userId.toString()}));
            if (forceCorrection) {
                Integer lockingAreaSizeInt = (Integer)att;
                Long lockingAreaSizeLong = lockingAreaSizeInt.longValue();
                info.setAttribute(prjAttrKey, (Object)lockingAreaSizeLong);
                FileOutputStream outFileStream = new FileOutputStream(cfgFile);
                BufferedOutputStream outBuffStream = new BufferedOutputStream(outFileStream);
                DataOutputStream outDataStream = new DataOutputStream(outBuffStream);
                ObjectOutputStream out = new ObjectOutputStream(outDataStream);
                out.writeObject(info);
                System.out.println(LNG.get((String)"IncorrectLockingAreaSizeIdentifier.file.corrected", (Object[])new String[]{cfgFile.getAbsolutePath()}));
                out.close();
            }
        }
    }
}

