package csbase.util.data.dispatcher;


/**
 * <p>
 * Responsvel por entregar dados a seus destinos.
 * </p>
 * <p>
 * Essa interface pode ser implementada possibilitando que dados sejam entregues
 * sncrona ou assncronamente.
 * </p>
 * 
 * @param <T> Tipo do destino.
 * @param <D> Tipo dos dados a serem despachados para o destino.
 * 
 * @author Tecgraf
 */
public interface IDispatcher<T, D> {

  /**
   * Entrega um conjunto de dados para um destino.
   * 
   * @param listener Ouvinte utilizado para retornar o resultado da entrega.
   * @param destination Destino dos dados.
   * @param data Dados a serem entregues.
   */
  public void dispatch(IDispatchListener<T, D> listener, T destination,
    D... data);
}