/*
 * Decompiled with CFR 0.152.
 */
package csbase.util;

import java.io.File;
import java.io.FileFilter;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.javautils.core.lng.LNG;

public class FileSystemUtils {
    static final String className = FileSystemUtils.class.getSimpleName();
    public static final String VERSION_CONTROL_DIR = ".svn";
    private static final boolean READ_ALLOWED = FileSystemUtils._canRead();

    public static final boolean canRead() {
        return READ_ALLOWED;
    }

    private static boolean _canRead() {
        try {
            new File(".").canRead();
            return true;
        }
        catch (AccessControlException ex) {
            return false;
        }
    }

    public static boolean fileExists(String path) {
        return FileSystemUtils.fileExists(new File(path));
    }

    public static boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    public static boolean dirExists(String path) {
        return FileSystemUtils.dirExists(new File(path));
    }

    public static boolean dirExists(File dir) {
        return dir.exists() && dir.isDirectory();
    }

    public static File[] getSubDirs(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(LNG.get((String)(className + ".illegalarg.dir.nonexistent"), (Object[])new String[]{dir.getAbsolutePath()}));
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(LNG.get((String)(className + ".illegalarg.dir.notadir"), (Object[])new String[]{dir.getAbsolutePath()}));
        }
        File[] subDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
        return subDirs;
    }

    public static boolean deleteRecursively(File file, Logger logger) {
        boolean removed;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                boolean success = FileSystemUtils.deleteRecursively(child, logger);
                if (success) continue;
                return false;
            }
        }
        if (!(removed = file.delete())) {
            String path = file.getAbsolutePath();
            String dirOrFileAux = file.isDirectory() ? LNG.get((String)(className + ".directory")) : LNG.get((String)(className + ".file"));
            String err = LNG.get((String)(className + ".removal.error"), (Object[])new String[]{dirOrFileAux, path});
            if (logger != null) {
                logger.log(Level.SEVERE, err);
            }
        }
        return removed;
    }

    public static boolean deleteRecursively(File file) {
        return FileSystemUtils.deleteRecursively(file, null);
    }
}

