/*
 * Decompiled with CFR 0.152.
 */
package validations;

import csbase.util.FileSystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import validations.ValidationException;
import validations.Validator;
import validations.util.ValidationsLogger;
import validations.util.ValidatorUtils;

public abstract class AbstractValidation {
    protected static final String RESOURCE_DIR_NAME = "/validations/resources";
    protected ValidationsLogger logger;
    private Status status;
    private Validator runValidator;
    private String backupDirPath;

    protected abstract boolean init();

    protected abstract String getStartMessage();

    protected abstract boolean runsOnlyOnce();

    protected abstract void getSpecificFailureMessage(Status var1, List<String> var2);

    protected abstract String getSuccessMessage(Status var1);

    protected abstract boolean validate() throws ValidationException;

    protected abstract boolean backupData();

    protected abstract boolean restoreBackup();

    protected abstract boolean applyPatch();

    protected abstract void finish();

    public Status getStatus() {
        return this.status;
    }

    private List<String> getFailureMessage() {
        ArrayList<String> errors = new ArrayList<String>();
        switch (this.status) {
            case BACKUP_EXISTS: {
                errors.add(LNG.get((String)"validations.FailUpdate"));
                errors.add(LNG.get((String)"validations.OverwriteBackupFail"));
                errors.add(LNG.get((String)"validations.BackupDir") + this.backupDirPath);
                break;
            }
            case BACKUP_FAILED: {
                errors.add(LNG.get((String)"validations.FailUpdate"));
                errors.add(LNG.get((String)"validations.BackupFail"));
                break;
            }
            case ROLLBACK_FAILED: {
                errors.add(LNG.get((String)"validations.FailUpdate"));
                errors.add(LNG.get((String)"validations.RollbackFail"));
                break;
            }
            case ROLLBACK_OK: {
                errors.add(LNG.get((String)"validations.FailUpdate"));
                errors.add(LNG.get((String)"validations.RollbackOk"));
                break;
            }
            case VALIDATION_ERROR: {
                errors.add(LNG.get((String)"validations.SysValidError"));
                errors.add(LNG.get((String)"validations.UnalteredData"));
                break;
            }
            default: {
                this.getSpecificFailureMessage(this.status, errors);
            }
        }
        return errors;
    }

    public final boolean run(Validator validator) {
        this.runValidator = validator;
        this.logger = validator.getLogger();
        this.backupDirPath = this.getTempDirPath() + File.separatorChar + this.getClass().getSimpleName();
        if (!this.init()) {
            this.status = Status.INIT_FAILED;
            return false;
        }
        this.logger.sectionSeparator(Level.FINE);
        String startMessage = this.getStartMessage();
        if (startMessage != null) {
            this.logger.fine(startMessage);
        }
        boolean validationOK = false;
        try {
            validationOK = this.validate();
        }
        catch (Exception e) {
            this.logger.exception(e);
            this.status = Status.VALIDATION_ERROR;
        }
        if (this.status != Status.VALIDATION_ERROR) {
            if (validationOK) {
                this.status = Status.VALIDATION_OK;
            } else if (this.isValidatingOnly()) {
                this.status = Status.VALIDATION_FAILED;
            } else {
                boolean backupOK;
                try {
                    if (!this.prepareBackupDir()) {
                        return false;
                    }
                    this.logger.fine(LNG.get((String)"validations.BackupLocation") + this.backupDirPath);
                    backupOK = this.backupData();
                }
                catch (Exception e) {
                    backupOK = false;
                }
                if (backupOK) {
                    try {
                        this.status = this.applyPatch() ? Status.PATCH_OK : Status.PATCH_FAILED;
                    }
                    catch (Exception e) {
                        this.status = Status.PATCH_FAILED;
                    }
                } else {
                    this.status = Status.BACKUP_FAILED;
                }
            }
        }
        this.finish();
        return this.status.isSuccess;
    }

    void reportStatus() {
        if (this.status.isSuccess) {
            this.logger.separator(Level.FINE);
            this.logger.fine(this.getSuccessMessage(this.status));
        } else {
            this.logger.separator(Level.SEVERE);
            for (String error : this.getFailureMessage()) {
                this.logger.severe(error);
            }
        }
    }

    private boolean prepareBackupDir() {
        if (FileSystemUtils.dirExists((String)this.backupDirPath)) {
            this.status = Status.BACKUP_EXISTS;
            return false;
        }
        if (!ValidatorUtils.mkDir(this.backupDirPath)) {
            this.status = Status.BACKUP_FAILED;
            return false;
        }
        return true;
    }

    public final boolean rollback() {
        if (!this.status.isReversibleOperation) {
            String fmt = "%s : status = %s";
            String className = this.getClass().getSimpleName();
            String msg = String.format("%s : status = %s", className, this.status.toString());
            this.logger.fine(msg);
            return false;
        }
        return this.restoreBackup();
    }

    protected final String getSystemProperty(String propName) {
        return this.runValidator.getSystemProperty(propName);
    }

    protected final String getMandatorySystemProperty(String propName) {
        return this.runValidator.getMandatorySystemProperty(propName);
    }

    public File getProjectDir() {
        return this.runValidator.getProjectDir();
    }

    public File getAlgorithmDir() {
        return this.runValidator.getAlgorithmDir();
    }

    protected final String getTempDirPath() {
        return this.runValidator.getTempDirPath();
    }

    protected final String getBackupDirPath() {
        return this.backupDirPath;
    }

    protected final boolean isValidatingOnly() {
        return this.runValidator.isValidatingOnly();
    }

    protected final boolean isVerbose() {
        return this.runValidator.isVerbose();
    }

    public boolean removeBackupDir() {
        if (this.isValidatingOnly() || this.status == Status.VALIDATION_OK) {
            return true;
        }
        return FileUtils.delete((File)new File(this.backupDirPath));
    }

    public static enum Status {
        INIT_FAILED(false, false),
        VALIDATION_OK(true, false),
        PATCH_OK(true, true),
        VALIDATION_FAILED(false, false),
        PATCH_FAILED(false, true),
        BACKUP_FAILED(false, false),
        BACKUP_EXISTS(false, false),
        ROLLBACK_OK(false, false),
        ROLLBACK_FAILED(false, false),
        VALIDATION_ERROR(false, false);

        private final boolean isSuccess;
        private final boolean isReversibleOperation;

        private Status(boolean isSuccess, boolean isReversibleOperation) {
            this.isSuccess = isSuccess;
            this.isReversibleOperation = isReversibleOperation;
        }
    }
}

