/*
 * Decompiled with CFR 0.152.
 */
package csbase.fogbow.client;

import csbase.fogbow.client.model.Instance;
import csbase.fogbow.client.model.Member;
import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.EntityBuilder;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.exception.EntityBuildingException;
import cz.cesnet.cloud.occi.api.http.HTTPClient;
import cz.cesnet.cloud.occi.api.http.HTTPHelper;
import cz.cesnet.cloud.occi.core.Entity;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcciClient
extends HTTPClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcciClient.class);
    public static final String USER_DATA_MIXIN_TERM = "user_data";
    public static final String PUBLIC_KEY_MIXIN_TERM = "public_key";
    public static final String IMAGE_MIXIN_RELATED_TERM = "os_tpl";
    public static final String FLAVOR_MIXIN_RELATED_TERM = "resource_tpl";
    public static final String FLAVOR_SMALL_TERM = "m1-small";
    public static final String FLAVOR_MEDIUM_TERM = "m1-medium";
    public static final String FLAVOR_LARGE_TERM = "m1-large";
    public static final String FOGBOW_FLAVOR_SMALL_TERM = "fogbow_small";
    public static final String FOGBOW_FLAVOR_MEDIUM_TERM = "fogbow_medium";
    public static final String FOGBOW_FLAVOR_LARGE_TERM = "fogbow_large";
    public static final String USER_DATA_ATTRIBUTE = "user_data";
    public static final String PUBLIC_KEY_DATA_ATTRIBUTE = "org.openstack.credentials.publickey.data";
    public static final String PUBLIC_KEY_NAME_ATTRIBUTE = "org.openstack.credentials.publickey.name";
    public static final String PUBLIC_KEY_NAME_ATTRIBUTE_VALUE = "fogbow";
    public static final String FLAVOR_TEMPLATE_SCHEME = "http://schemas.openstack.org/template/resource#";
    public static final String IMAGE_TEMPLATE_SCHEME = "http://schemas.openstack.org/template/os#";
    public static final String FOGBOW_FLAVOR_TEMPLATE_SCHEME = "http://schemas.fogbowcloud.org/template/resource#";
    public static final String FOGBOW_IMAGE_TEMPLATE_SCHEME = "http://schemas.fogbowcloud.org/template/os#";
    private Integer retryThreshold = 10000;
    private Integer maxRetries = 60;

    public OcciClient(URI endpoint, Authentication authentication) throws CommunicationException {
        super(endpoint, authentication, "text/occi", false);
        this.connect();
    }

    public OcciClient(URI endpoint, Authentication authentication, Integer maxRetries, Integer retryThreshold) throws CommunicationException {
        super(endpoint, authentication, "text/occi", false);
        this.maxRetries = maxRetries;
        this.retryThreshold = retryThreshold;
        this.connect();
    }

    public Member getMember(String memberId) throws CommunicationException {
        String quotas = this.getResponseBody((HttpRequest)HTTPHelper.prepareGet((String)("/member/" + memberId + "/quota"), (Header[])this.connection.getHeaders()), 200);
        return new Member(memberId, quotas);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResponseBody(HttpRequest request, int status) throws CommunicationException {
        try {
            System.out.println("Running request: " + request);
            System.out.println("Headers: ");
            try (CloseableHttpResponse response = HTTPHelper.runRequest((HttpRequest)request, (HttpHost)this.target, (CloseableHttpClient)this.connection.getClient(), (HttpContext)this.connection.getContext(), (int)status);){
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                System.out.println("Reponse code: " + status);
                for (Header header : response.getAllHeaders()) {
                    System.out.println(header.getName() + ": " + header.getValue() + "\t");
                }
                System.out.println("Response body: \n\t" + responseBody);
                String string = responseBody;
                return string;
            }
        }
        catch (IOException ex) {
            throw new CommunicationException((Throwable)ex);
        }
    }

    public Future<Instance> createInstance(Mixin flavor, Mixin image, byte[] userData, String publicKey, final onInstanceCreateListener callback) throws InvalidAttributeException, EntityBuildingException, CommunicationException, InvalidAttributeValueException, AmbiguousIdentifierException {
        for (int i = 0; i < 10; ++i) {
            System.out.println("\n");
        }
        EntityBuilder eb = new EntityBuilder(this.getModel());
        Resource compute = eb.getResource("compute");
        compute.addMixin(this.validateFlavor(this.findFlavor(flavor)));
        compute.addMixin(this.validateImage(this.findImage(image)));
        if (userData != null) {
            compute.addMixin(this.validateMixin("user_data"));
            compute.addAttribute("user_data", new String(Base64.encodeBase64((byte[])userData)));
        }
        if (publicKey != null) {
            compute.addMixin(this.validateMixin(PUBLIC_KEY_MIXIN_TERM));
            compute.addAttribute(PUBLIC_KEY_DATA_ATTRIBUTE, publicKey);
            compute.addAttribute(PUBLIC_KEY_NAME_ATTRIBUTE, PUBLIC_KEY_NAME_ATTRIBUTE_VALUE);
        }
        final URI location = this.create((Entity)compute);
        System.out.println("Created compute instance at location: '" + location + "'.");
        Callable<Instance> pollInstanceState = new Callable<Instance>(){

            @Override
            public Instance call() throws CommunicationException {
                System.out.println("Waiting for ssh address...");
                for (int i = 0; i < OcciClient.this.maxRetries; ++i) {
                    try {
                        Entity occiEntity = (Entity)OcciClient.this.describe(location, new String[]{"text/plain"}).get(0);
                        if (occiEntity.getValue("org.fogbowcloud.request.ssh-public-address") != null) {
                            Instance created = new Instance(location, occiEntity);
                            callback.onInstanceCreate(created);
                            return created;
                        }
                        System.out.println("Attempt " + i + " without success");
                        Thread.sleep(OcciClient.this.retryThreshold.intValue());
                        continue;
                    }
                    catch (CommunicationException e) {
                        System.out.println("Attempt " + i + " without success");
                        e.printStackTrace();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                throw new CommunicationException("Instance " + location + " exceeded creation timeout of " + OcciClient.this.retryThreshold * OcciClient.this.maxRetries + " seconds.");
            }
        };
        return Executors.newSingleThreadExecutor().submit(pollInstanceState);
    }

    public void deleteInstance(URI location) throws CommunicationException {
        System.out.println("Deleting compute " + location);
        boolean status = this.delete(location);
        if (status) {
            System.out.println("Deleted: OK");
        } else {
            System.out.println("Deleted: FAIL");
        }
    }

    public List<Mixin> listImages() throws AmbiguousIdentifierException {
        System.out.println("Listing available os template mixins...");
        List mixins = this.getModel().findRelatedMixins(IMAGE_MIXIN_RELATED_TERM);
        for (Mixin mixin : mixins) {
            System.out.println(mixin.toString());
        }
        return mixins;
    }

    public List<Mixin> listFlavors() throws AmbiguousIdentifierException {
        System.out.println("Listing available resource template mixins...");
        List mixins = this.getModel().findRelatedMixins(FLAVOR_MIXIN_RELATED_TERM);
        for (Mixin mixin : mixins) {
            System.out.println(mixin.toString());
        }
        return mixins;
    }

    public Mixin findImage(Mixin image) throws AmbiguousIdentifierException {
        List mixins = this.getModel().findRelatedMixins(IMAGE_MIXIN_RELATED_TERM);
        for (Mixin mixin : mixins) {
            if (!mixin.equals((Object)image)) continue;
            return mixin;
        }
        return null;
    }

    public Mixin findFlavor(Mixin flavor) throws AmbiguousIdentifierException {
        List mixins = this.getModel().findRelatedMixins(FLAVOR_MIXIN_RELATED_TERM);
        for (Mixin mixin : mixins) {
            if (!mixin.equals((Object)flavor)) continue;
            return mixin;
        }
        return null;
    }

    private Mixin validateImage(Mixin mixin) throws InvalidAttributeException {
        try {
            if (mixin == null) {
                throw new InvalidAttributeException("Image mixin " + mixin + " cannot be null");
            }
            Mixin image = this.findImage(mixin);
            if (image == null) {
                throw new InvalidAttributeException("Image mixin " + mixin + " not found");
            }
        }
        catch (AmbiguousIdentifierException e) {
            e.printStackTrace();
            throw new InvalidAttributeException("Error validating mixin " + mixin + ": " + e.getLocalizedMessage());
        }
        return mixin;
    }

    private Mixin validateFlavor(Mixin mixin) throws InvalidAttributeException {
        try {
            if (mixin == null) {
                throw new InvalidAttributeException("Flavor mixin " + mixin + " cannot be null");
            }
            Mixin image = this.findFlavor(mixin);
            if (image == null) {
                throw new InvalidAttributeException("Flavor mixin " + mixin + " not found");
            }
        }
        catch (AmbiguousIdentifierException e) {
            e.printStackTrace();
            throw new InvalidAttributeException("Error validating mixin " + mixin + ": " + e.getLocalizedMessage());
        }
        return mixin;
    }

    private Mixin validateMixin(String term) throws InvalidAttributeException {
        Mixin mixin = null;
        try {
            mixin = this.getModel().findMixin(term);
            if (mixin == null) {
                throw new InvalidAttributeException("Mixin " + term + " not found");
            }
        }
        catch (AmbiguousIdentifierException e) {
            e.printStackTrace();
            throw new InvalidAttributeException("Error validating mixin " + term + ": " + e.getLocalizedMessage());
        }
        return mixin;
    }

    public static interface onInstanceCreateListener {
        public void onInstanceCreate(Instance var1);
    }
}

