package Requests.Algorithms;

import java.util.Objects;

public class Requirement   {
	private String key = null;

	private String name = null;

	public enum TypeEnum {
		INTEGER("integer"),

		DOUBLE("double"),

		BOOLEAN("boolean"),

		STRING("string"),

		ENUMERATION("enumeration");

		private String value;

		TypeEnum(String value) {
			this.value = value;
		}

		@Override
		public String toString() {
			return String.valueOf(value);
		}
	}

	private TypeEnum type = null;

	private Boolean editable = null;

	private Object value = null;

	public Requirement key(String key) {
		this.key = key;
		return this;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Requirement name(String name) {
		this.name = name;
		return this;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Requirement type(TypeEnum type) {
		this.type = type;
		return this;
	}

	public TypeEnum getType() {
		return type;
	}

	public void setType(TypeEnum type) {
		this.type = type;
	}

	public Requirement editable(Boolean editable) {
		this.editable = editable;
		return this;
	}

	public Boolean getEditable() {
		return editable;
	}

	public void setEditable(Boolean editable) {
		this.editable = editable;
	}

	public Requirement value(Object value) {
		this.value = value;
		return this;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}


	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		Requirement requirement = (Requirement) o;
		return Objects.equals(this.key, requirement.key) &&
				Objects.equals(this.name, requirement.name) &&
				Objects.equals(this.type, requirement.type) &&
				Objects.equals(this.editable, requirement.editable) &&
				Objects.equals(this.value, requirement.value);
	}

	@Override
	public int hashCode() {
		return Objects.hash(key, name, type, editable, value);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class Requirement {\n");

		sb.append("    key: ").append(toIndentedString(key)).append("\n");
		sb.append("    name: ").append(toIndentedString(name)).append("\n");
		sb.append("    type: ").append(toIndentedString(type)).append("\n");
		sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
		sb.append("    value: ").append(toIndentedString(value)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}
