/*
 * Decompiled with CFR 0.152.
 */
package csfs.remote;

import csfs.remote.ClosedChannelException;
import csfs.remote.ClosedChannelExceptionHelper;
import csfs.remote.InvalidStateException;
import csfs.remote.InvalidStateExceptionHelper;
import csfs.remote.OctetSequenceHelper;
import csfs.remote.RemoteFileHelper;
import csfs.remote.ServerException;
import csfs.remote.ServerExceptionHelper;
import csfs.remote.WriteChannel;
import csfs.remote.WriteChannelHelper;
import csfs.remote.WriteChannelOperations;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class WriteChannelPOA
extends Servant
implements InvokeHandler,
WriteChannelOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:csfs/remote/WriteChannel:1.0", "IDL:csfs/remote/Channel:1.0"};

    public WriteChannel _this() {
        return WriteChannelHelper.narrow(this._this_object());
    }

    public WriteChannel _this(ORB oRB) {
        return WriteChannelHelper.narrow(this._this_object(oRB));
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                try {
                    outputStream = responseHandler.createReply();
                    RemoteFileHelper.write(outputStream, this.getFile());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 1: {
                try {
                    outputStream = responseHandler.createReply();
                    this.close();
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 2: {
                try {
                    int n2 = inputStream.read_ulong();
                    byte[] byArray = OctetSequenceHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    outputStream.write_long(this.write(n2, byArray));
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                catch (ClosedChannelException closedChannelException) {
                    outputStream = responseHandler.createExceptionReply();
                    ClosedChannelExceptionHelper.write(outputStream, closedChannelException);
                }
                break;
            }
            case 3: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.isOpen());
                    break;
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                    break;
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    static {
        m_opsHash.put("getFile", new Integer(0));
        m_opsHash.put("close", new Integer(1));
        m_opsHash.put("write", new Integer(2));
        m_opsHash.put("isOpen", new Integer(3));
    }
}

