-------------------------------------------------------------------------
-- $Author$
-- $Revision$  - $Date$
-------------------------------------------------------------------------

local verbose = require "sga.verbose"

-- Definio de modo verbose
verbose.level(1)
verbose.flag("top", false)


-------------------------------------------------------------------------
---------------------<:: CONFIGURAO AVANADA ::>-----------------------
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- Definio de intervalos de tempo no loop principal do SGA-Daemon
-- Os tempos comentados so os valores default.
-------------------------------------------------------------------------

-- Intervalo, em segundos, para buscar referencia do Servidor
SGAD_CONF.ssiref_time_seconds = SGAD_CONF.ssiref_time_seconds or 15

-- Intervalo, em segundos, para tentar registrar o SGA no Servidor
SGAD_CONF.sgaregistry_time_seconds = SGAD_CONF.sgaregistry_time_seconds or 30

-- Intervalo, em segundos, para leitura de uso de cpu/memria
SGAD_CONF.machine_time_seconds = SGAD_CONF.machine_time_seconds or 25

-- Intervalo, em segundos, para envio de informaes dinmicas ao servidor
SGAD_CONF.update_time_seconds = SGAD_CONF.update_time_seconds or 30

-- Intervalo, em segundos, para consulta de processos
SGAD_CONF.process_time_seconds = SGAD_CONF.process_time_seconds or 10

-- Intervalo, em segundos, para busca de comandos terminados
SGAD_CONF.completed_time_seconds = SGAD_CONF.completed_time_seconds or 10

-- Intervalo, em segundos, para dump de comandos em execuo (persistencia)
SGAD_CONF.dump_time_seconds = SGAD_CONF.dump_time_seconds or 60

-- Numero de vezes que uma consulta (cpu/memria) deve falhar para
-- que seja considerado um erro.
SGAD_CONF.disregard_times = SGAD_CONF.disregard_times or 3

-- Nmero de vezes que tenta fazer o registro no Servidor quando ocorre
-- falha de comunicao. (OPCIONAL -- default  no ter limite)
--SGAD_CONF.retries_number = 5

-- Nmero de vezes que tenta iniciar o daemon do CSFS (OPCIONAL)
SGAD_CONF.csfs_retries_number = 5

-------------------------------------------------------------------------
-- EVITE ALTERAR as propriedades abaixo, configure as variveis de 
-- ambiente no arquivo sga-daemon de acordo com o necessrio.
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- Nome da mquina onde ser executado o sgad
-------------------------------------------------------------------------
local HOSTNAME = os.getenv("HOSTNAME")
if HOSTNAME then
   SGAD_CONF.domain = string.gsub(HOSTNAME, "^[^%.]+","")
   SGAD_CONF.localhost = string.gsub(HOSTNAME, "^([^%.]+).*","%1")
end

local HOST = os.getenv("HOST")
if not HOST then
   verbose.error("\n\nEnvironment variable $HOST is undefined!!!\n\n")
   os.exit(0)
end

HOST = string.gsub(HOST,"%..*","")
SGAD_CONF.name = HOST

-------------------------------------------------------------------------
--------------------------<:::::::::::::::::::>--------------------------
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- Localizao do Servidor
-------------------------------------------------------------------------
SGAD_CONF.ssi_host = os.getenv("SSI_HOSTNAME") or "localhost"
SGAD_CONF.ssi_port = os.getenv("SSI_PORT") or "7778"
SGAD_CONF.ssi_printablename = SGAD_CONF.ssi_host..":"..SGAD_CONF.ssi_port
SGAD_CONF.sga_addr = os.getenv("SGA_ADDR")
SGAD_CONF.sandbox_root_directory = os.getenv("SGA_SANDBOX_DIR") or SGAD_CONF.sandbox_root_directory
SGAD_CONF.project_root_directory = os.getenv("SSI_PROJECT_DIR") or SGAD_CONF.project_root_directory
SGAD_CONF.algorithm_root_directory = os.getenv("SSI_ALGORITHM_DIR") or SGAD_CONF.algorithm_root_directory
SGAD_CONF.usrlibsdir = os.getenv("USR_LIBS_DIR")
SGAD_CONF.sgalibsdir = os.getenv("SGA_LIBS_DIR")
SGAD_CONF.path = os.getenv("PWD") or ""
SGAD_CONF.home = os.getenv("HOME") or ""

-- Para carregar a biblioteca apropriada...
  local sganame = string.upper( SGAD_CONF.name )
  local tab = SGAD_CONF.network[ sganame ] or SGAD_CONF.grid[ sganame ]
  if not tab then
     verbose.error( "\n\nNo configuration found for host: "..tostring(SGAD_CONF.name).."!!!\n\n")
     os.exit(0)
  end

  -- Se no for um grid, obtm a configurao de node[1].
  if not tab.grid then
    tab = tab[1]
  else
    -- O grid padro  o PBS (torque).
    tab.loadlib = tab.loadlib or "torquePBS"
  end
  local map = SGAD_CONF.platform_mapping
  SGAD_CONF.platform_os = tab.platform_os or (tab.platform_id and
    (map[tab.platform_id] or tab.platform_id))

  if not SGA_DAEMON:openLib() then
    print("No tem a lib definida.")
  end
  SGA_DAEMON:setNodes()
-- at aqui

SGAD_CONF.restarthour = tonumber(os.getenv("RESTARTHOUR") or "")
if not SGAD_CONF.restarthour  or
   SGAD_CONF.restarthour > 23 or
   SGAD_CONF.restarthour < 0  then
   SGAD_CONF.restarthour = nil
end

-- endereo de localizao do Servidor (via corbaloc)
SGAD_CONF.ssi_ior = "corbaloc::"..
   SGAD_CONF.ssi_host..":"..SGAD_CONF.ssi_port..
   "/SGAMgr"..
   "/SGAMgrPOA/"..
   "SGAManager"

-- Nome do arquivo para dump de comandos
SGAD_CONF.dump_file = "./commands/"..SGAD_CONF.name

-- Diretrio do binrio do SGA
local sgabindir = os.getenv("SGAD_DIR")
SGAD_CONF.sgabindir = sgabindir or
  string.format("%s/../bin/%s/", SGAD_CONF.path, SGAD_CONF.platform_os)

SGAD_CONF.ssibindir = SGAD_CONF.ssi_bin_directory and 
  (SGAD_CONF.ssi_bin_directory .. SGAD_CONF.platform_os)

CSFS.command = [[ cd ../csfs && ./startCSFS ]]
CSFS.process_id = "CSFS_PROCESS"
if SGAD_CONF.csfs then
  CSFS.properties = SGAD_CONF.csfs.properties or {}
  CSFS.launch_daemon = SGAD_CONF.csfs.launch_daemon
  CSFS.use_local_root_directories = SGAD_CONF.csfs.use_local_root_directories
  CSFS.retries_number = SGAD_CONF.csfs_retries_number
else 
  CSFS.properties = {}
end

local logdir = os.getenv("SGALOG_DIR")
if logdir then
  local logname = "csfs-" ..SGAD_CONF.name..".log"
  CSFS.properties.SERVER_LOG = "../src/"..logdir.."/"..logname
end
CSFS.properties.HOST = CSFS.properties.HOST or
  (CSFS.launch_daemon and SGAD_CONF.localhost..SGAD_CONF.domain)

local iperfbindir = string.format("../bin/%s", SGAD_CONF.platform_os)
IPERF.command = " cd "..iperfbindir.." && ./iperf -s "
IPERF.process_id = "IPERF_PROCESS"

-------------------------------------------------------------------------
