-------------------------------------------------------------------------
-- $Author$
-- $Revision$  - $Date$
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- Arquivo de configurao do SGA Daemon
-------------------------------------------------------------------------

-- Configurao padro
SGAD_CONF.node_defaults.platform_id = "No especificada"
SGAD_CONF.node_defaults.num_processors = 1
SGAD_CONF.node_defaults.memory_ram_info_mb = 0
SGAD_CONF.node_defaults.memory_swap_info_mb = 0
SGAD_CONF.node_defaults.clock_speed_mhz = 0
SGAD_CONF.node_defaults.file_separator = "/"
SGAD_CONF.node_defaults.project_root_directory = "../../csgrid/project" --Em relao ao SGA!
SGAD_CONF.node_defaults.algorithm_root_directory = "../../csgrid/algorithms" --Em relao ao SGA!
SGAD_CONF.node_defaults.sandbox_root_directory = "/tmp/sandbox" 
SGAD_CONF.node_defaults.byte_order = BIG_ENDIAN
SGAD_CONF.node_defaults.disabled = NO
SGAD_CONF.node_defaults.benchmarks = NO
SGAD_CONF.node_defaults.net_benchmark = NO
SGAD_CONF.node_defaults.cpu_capacity = NO_CAPACITY
SGAD_CONF.node_defaults.reading_disk_capacity = NO_CAPACITY
SGAD_CONF.node_defaults.writing_disk_capacity = NO_CAPACITY
SGAD_CONF.node_defaults.enable_historic = NO
SGAD_CONF.node_defaults.partition_name = "sda"
SGAD_CONF.node_defaults.net_interface_name = "eth0"

SGAD_CONF.platform_mapping.Windows64 = "Windows"

local verbose = require "sga.verbose"
verbose.init("")
verbose.init("** ATENCAO!!!! -- Usando arquivo de configurao default.       **")
verbose.init("** Este arquivo deve ser copiado para outro diretorio, que      **")
verbose.init("** deve estar definido no arquivo ./sga-daemon (sga-daemon.bat) **")
verbose.init("** em DEFAULT_SGA_CONFIG_DIR.                                   **")
verbose.init("")

-------------------------------------------------------------------------
-- Configurao dos SGAs
-------------------------------------------------------------------------
-- Para definir um SGA simples, basta definir seu nome e os campos
-- que so diferentes da configurao default.
-- Node{ 
--   name = "singleNode",
--   platform_id = "Linux24",
--   clock_speed_mhz = 1000,
--   memory_ram_info_mb = 2048,
--   memory_swap_info_mb = 5376,
--   byte_order = LITTLE_ENDIAN,
--   disabled = YES,
--   csfs = { properties = { HOST="kobke" } },
--   requirements = { "Excel" },
-- }

-- Para definir um cluster, pode-se utilizar 3 opoes.
-- Grupos:
--   No exemplo, as maquinas node01, node02 e node03 so do tipo "group1" e
--   as maquinas node04 e node05 so do tipo "group2"
-- SGAs definidos anteriormente:
--   No exemplo, a maquina single node ja foi definida.
-- A configurao default daquele grid:
--   No exemplo, a maquina otherNode segue a configurao default do
--   Grid.
-- Grid{
--   name = "myCluster",
--   machine_time_seconds = 20,
--   deny_node_selection = YES,
--   ids = { {"node01", "group1"}, "node02", "node03",
--           {"node04", "group2"}, "node05",
--            "singleNode", -- SGA simples definido anteriormente
--            "otherNode",  -- SGA no definido, usar a configurao
--   },                     -- default do Grid
--   default = {
--     num_processors = 2,
--     platform_id = "Windows",
--     clock_speed_mhz = 3060,
--     memory_ram_info_mb = 4096,
--     memory_swap_info_mb = 9728,
--     csfs = { properties = { HOST="node01"} },
--     byte_order = LITTLE_ENDIAN
--   },
--   groups = {
--     group1 = { 
--         platform_id = "Linux24g3",
--         clock_speed_mhz = 1000,
--         memory_ram_info_mb = 3*1024,
--         memory_swap_info_mb = 16*1024,
--     },
--     group2 = { 
--         platform_id = "Linux24",
--         clock_speed_mhz = 1000,
--         memory_ram_info_mb = 1024,
--         memory_swap_info_mb = 17216,
--     },
--   }
-- }
-------------------------------------------------------------------------
