/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.jacorb.orb.etf.StreamConnectionBase;
import org.jacorb.orb.listener.SSLListenerUtil;
import org.omg.CORBA.COMM_FAILURE;

public abstract class IIOPConnection
extends StreamConnectionBase {
    protected Socket socket;
    protected boolean use_ssl;

    @Override
    public boolean isSSL() {
        return this.use_ssl;
    }

    @Override
    protected synchronized void setTimeout(int timeout) {
        block4: {
            if (this.socket != null) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Socket timeout set to " + timeout + " ms");
                    }
                    this.socket.setSoTimeout(timeout);
                }
                catch (SocketException se) {
                    if (!this.logger.isInfoEnabled()) break block4;
                    this.logger.info("SocketException", (Throwable)se);
                }
            }
        }
    }

    @Override
    protected COMM_FAILURE handleCommFailure(IOException e) {
        SSLListenerUtil.processException(this.orb, this, this.socket, e);
        return this.to_COMM_FAILURE(e);
    }

    @Override
    protected synchronized int getTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException ex) {
            throw this.handleCommFailure(ex);
        }
    }

    public int hashCode() {
        if (this.socket == null || !this.connected) {
            return super.hashCode();
        }
        return this.socket.hashCode();
    }

    public Socket getSocket() {
        return this.socket;
    }
}

