-------------------------------------------------------------------------
-- $Author: fpina $
-- $Revision: 161412 $  - $Date: 2015-01-29 11:09:11 -0200 (Qui, 29 jan 2015) $
-------------------------------------------------------------------------

require "lib.shellExtension"
require "sga.daemon"
require "sga.services"
require "sga.command"

local oil = require "oil"
local verbose = require "sga.verbose"

oil.main(
  function ()
    SGA_DAEMON:loadBasicConfiguration()
    SGA_DAEMON:doPresentation()

    local status, error_msg = SGA_DAEMON:initServer()
    if not status then
      verbose:init( "Erro ao iniciar o SGA.\n\t\t\t"..error_msg )
      os.exit(0)
    end
    SGA_DAEMON:register()
    if CSFS.launch_daemon == YES and CSFS.process == nil then
      SGA_DAEMON:createCSFSProcess()
    end
    if SGAD_CONF.net_benchmark == YES and IPERF.process == nil then
      SGA_DAEMON:createIPerfProcess()
    end
    SGA_DAEMON:startServer()
  end
)
