local WinPIDTab = {}
local ErrorFile = "ERROR."

function collectWinPID()
   WinPIDTab = {}

-- local output = os.tmpname()
   local output = string.format("collectWinPID.%s.%d" , SGA_PID, os.time())
   os.execute(string.format("ps -l > %s", output))
   for line in io.lines(output) do
      local _,_,pid,ppid,pgid,winpid =
         string.find(line, "^%D+(%d+)%s+(%d+)%s+(%d+)%s+(%d+)")

      if pid then
         pgid = tonumber(pgid)
         winpid = tonumber(winpid)

         if not WinPIDTab[pgid] then
            WinPIDTab[pgid] = {}
         end

         table.insert(WinPIDTab[pgid], winpid)
      end
   end
   os.remove(output)
end

function getWinPID(pgid)
   return WinPIDTab[pgid]
end

-- Redefinio da funo executecommand para capturar a sada de erro,
-- caso um arquivo no tenha sido definido.
-- servermanager.winexec = servermanager.executecommand
-- servermanager.executecommand = function(cmdid, command, input,
--   output, err_output, host, startdir)
--   err_output = err_output or ErrorFile .. cmdid
--   return servermanager.winexec(cmdid, command, input,
--     output,err_output, host, startdir)
-- end

-- Se a sada de erro tiver sido capturada, exibe o erro na console do
-- sga.
_checkforerror = function (handle)
  local cmdid = servermanager.getcommandid(handle)
  if not cmdid then
    return
  end
  local errorfile = ErrorFile .. cmdid
  local str
  local fd = io.open(errorfile, "r")
  if not fd then
--   servermanager.writeError( "Erro ao abrir arquivo temporrio:\n"..
--                            "\t["..tostring(errorfile).."]\n"..
--                            "\tpara aquisio de dados de execuo\n" )
    return
  end
  str = fd:read("*a")
  fd:close()
  os.remove(errorfile)
  if str and string.len(str) > 0 then
    local errormsg = string.format(
      "Possvel erro na execuo do comando %s:\n%s",
      cmdid, str)
    servermanager.writeError(errormsg)
  end
end

-- A primeira coleta no consegue retornar a carga da cpu porque ela
-- precisa de duas chamadas para poder fazer a conta. Por isso, da
-- primeira vez, chamamos o mtodo que obtm a carga da cpu duas vezes.
servermanager.oldgetcpuload = servermanager.getcpuload
servermanager.firstcpuload = true
servermanager.getcpuload = function (handle)
  if servermanager.firstcpuload then
    local cpuload, err = servermanager.oldgetcpuload(handle) 
    servermanager.firstcpuload = false
    if err then
      cpuload, err = servermanager.oldgetcpuload(handle)
    end
    servermanager.getcpuload = servermanager.oldgetcpuload
    return cpuload, err
  end
end
