/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jacorb.config.ConfigurationException;

public class JacORBLogFormatter
extends Formatter {
    private final DateFormat timeFormat;
    private boolean showThread;
    private boolean showSrcInfo;
    private ClockFormat clockFormat;

    public JacORBLogFormatter(boolean show_thread, boolean srcinfo, ClockFormat cf) {
        this.showThread = show_thread;
        this.showSrcInfo = srcinfo;
        this.clockFormat = cf;
        this.timeFormat = this.clockFormat == ClockFormat.DATE_TIME ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : null;
    }

    @Override
    public String format(LogRecord record) {
        String result = String.format((this.clockFormat != ClockFormat.NONE ? "%s %s " : "%s%s ") + (this.showSrcInfo ? "%s::%s" : "%s%s") + (this.showThread ? " [%d] " : "%s") + "%s\n", this.clockFormat != ClockFormat.NONE ? this.getClockFormat(record.getMillis()) : "", record.getLevel(), this.showSrcInfo ? record.getSourceClassName() : "", this.showSrcInfo ? record.getSourceMethodName() : "", this.showThread ? Integer.valueOf(record.getThreadID()) : "", record.getMessage());
        Throwable t = record.getThrown();
        return t == null ? result : result + this.getStackTrace(t);
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private String getClockFormat(long millis) {
        switch (this.clockFormat) {
            case NONE: {
                return "";
            }
            case TIME: {
                return String.format("%02d:%02d:%02d", millis / 3600000L % 24L, millis / 60000L % 60L, millis / 1000L % 60L);
            }
            case DATE_TIME: {
                return this.timeFormat.format(millis);
            }
        }
        throw new RuntimeException("Invalid clock format type");
    }

    public static enum ClockFormat {
        TIME,
        DATE_TIME,
        NONE;


        public static ClockFormat getClockFormat(String cf) throws ConfigurationException {
            try {
                return ClockFormat.valueOf(cf.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Invalid type for ClockFormat", e);
            }
        }
    }
}

