/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ServerInfo;

public class ImRTreeCellRenderer
extends DefaultTreeCellRenderer {
    private boolean m_use_html_labels = false;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Object _node = ((DefaultMutableTreeNode)value).getUserObject();
        if (_node instanceof ImRInfo) {
            this.setText("Repository");
            this.setToolTipText("Port: " + ((ImRInfo)_node).port + ", Host: " + ((ImRInfo)_node).host);
        } else if (_node instanceof POAInfo) {
            POAInfo _poa = (POAInfo)_node;
            this.setToolTipText("POA is " + (_poa.active ? "active" : "inactive"));
            if (this.m_use_html_labels) {
                String _color = _poa.active ? "green" : "red";
                this.setText("<html> <font color=" + _color + ">" + _poa.name + "</font></html>");
            } else {
                this.setText(_poa.name);
            }
        } else if (_node instanceof ServerInfo) {
            ServerInfo _server = (ServerInfo)_node;
            this.setToolTipText("Server is " + (_server.active ? "active" : "down") + (_server.holding ? "and holding" : ""));
            if (this.m_use_html_labels) {
                String _color = _server.active ? "green" : "red";
                this.setText("<tml> <font color=" + _color + ">" + (_server.holding ? "<blink>" : "") + _server.name + (_server.holding ? "</blink>" : "") + "</font></html>");
            } else {
                this.setText(_server.name);
            }
        }
        return this;
    }
}

