/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.HashSet;
import java.util.Set;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.omg.ETF.Profile;

public class ReplyGroup {
    private boolean is_open = true;
    private Set<ReplyPlaceholder> replies = null;
    private Profile profile;
    private Delegate owner;

    ReplyGroup(Delegate d, Profile p) {
        this.owner = d;
        this.profile = p;
    }

    synchronized void postInit() {
        this.replies = new HashSet<ReplyPlaceholder>();
    }

    synchronized void lockBarrier() {
        this.is_open = false;
    }

    synchronized void openBarrier() {
        this.is_open = true;
        this.notifyAll();
    }

    synchronized void waitOnBarrier() {
        while (!this.is_open) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Set<ReplyPlaceholder> getReplies() {
        return this.replies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retry() {
        Set<ReplyPlaceholder> set = this.replies;
        synchronized (set) {
            for (ReplyPlaceholder p : this.replies) {
                p.retry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHolder(ReplyPlaceholder holder) {
        Set<ReplyPlaceholder> set = this.replies;
        synchronized (set) {
            this.replies.add(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHolder(ReplyPlaceholder holder) {
        Set<ReplyPlaceholder> set = this.replies;
        synchronized (set) {
            this.replies.remove(holder);
        }
    }
}

